#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# This script is invoked every time EventHandler is triggered.
# The following cli is issued by P4RuntimeRouting Plugin.
# CLI:
# event-handler p4rtEventHandler
# action bash "python /usr/share/P4Runtime/P4RtSyslogEventHandler.py"
# delay 1
# trigger on-logging",
# poll interval 5
# regex "PID: [0-9]* Comm: .* Tainted:.*"

# The script will then read the syslog message from the environment variable
# and invoke AristaPiServer::triggerCriticalState to push the syslog message
# into the P4RtSystemStatus::switchEvents and put switch into critical state

import PyClient
import os
import sys
import re
import AgentDirectory

# Usage: ./sys.argv[0] sysname
if len( sys.argv ) > 2:
   print "Usage: ./sys.argv[0] sysname"
   sys.exit( 2 )

sysname = 'ar'
if len( sys.argv ) == 2:
   sysname = sys.argv[ 1 ]

# Make sure p4runtime is running
if not AgentDirectory.agentIsRunning( sysname, 'P4Runtime' ):
   print "P4Runtime agent is not running"
   sys.exit( 2 )

pc = PyClient.PyClient( sysname, "P4Runtime" )
script = """
import re
import Tac
piServer = Tac.root[ '%s' ][ 'P4Runtime' ][ 'P4Runtime' ].piServer
""" % ( sysname )

pc.execute( script )

agentsToIgnore = [ " netns " ]

sysLogMsg = os.environ.get( 'EVENT_LOG_MSG' )
sysLogMsgCount = os.environ.get( 'EVENT_COUNT' )
if not sysLogMsg:
   print "Empty syslog msg"
   sys.exit( 3 )
else:
   # Ignore specified agents
   # Right now, we only ignore netns.
   # Maybe we should add Strata related agents?
   for agent in agentsToIgnore:
      if re.search( agent, sysLogMsg ):
         print "Ignore LogMsg %s" % sysLogMsg
         sys.exit()
   # TODO: Further handle syslog messages here
   pc.execute( "piServer.triggerCriticalState( '%s', %d )" % \
               ( sysLogMsg, int( sysLogMsgCount ) ) )

