# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import commands

INVALID_TUNNEL = 512

@commands.cmd( 'show nhresolve TUNID [INDEX]',
      'Show nextHop resolve entries for all or a given index and tunid' )
def show_nhresolve( cli, tunid, index ):
   args = {}
   if not tunid:
      raise cli.CommandError( 'No tunnel id specified' )

   if index:
      args[ 'index' ] = index

   if tunid == INVALID_TUNNEL:
      cli.fout.write( 'Global NhResolve entries:\n' )
      ret = cli.bess.run_module_command( 'NhResolve',
                                      'showNhResolve',
                                      'NhResolveShowInfoArg', args )
   else:
      ret = cli.bess.run_module_command( 'NhResolve_tu' + str( tunid ),
                                      'showNhResolve',
                                      'NhResolveShowInfoArg', args )
   cli.fout.write( f'show nhresolve response: { repr(ret) }\n' )
