# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import commands

@commands.cmd( 'show openflow-stats TABLEID',
     'Show openflow stats for a given table id' )
def show_openflow_stats( cli, table_id ):
   args = {}
   args[ 'table_id' ] = table_id
   ret = cli.bess.run_module_command( 'OpenFlow', 'getStats',
                                     'OpenFlowGetStatsArg', args )
   cli.fout.write( 'openflow-stats for table id %d: %s\n' %
                  ( table_id, repr( ret ) ) )

@commands.var_attrs( 'TABLEID' )
def table_id_var_attrs():
   # Return (var_type(str), var_desc(str), var_candidates([str]))
   return ( 'int', '', [] )
