# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
from .option_validator import OptionValidator

class StringValidator(OptionValidator):

   def __init__(self):
      OptionValidator.__init__(self)
      self.tokens = []
      self.brackets = ["'", '"']
      self.pos = 0
      self.value = None

   @staticmethod
   def _is_start(token, bracket):
      if len(token) > 1:
         if token[0] == bracket and token[-1] != bracket:
            return True
      return False

   @staticmethod
   def _is_end(token, bracket):
      if len(token) > 1:
         if token[-1] == bracket and token[0] != bracket:
            return True
      return False

   @staticmethod
   def _is_enclosed(token):
      if len(token) > 1:
         double_enclosed = token[0] == '"' and token[-1] == '"'
         single_enclosed = token[0] == "'" and token[-1] == "'"
         if double_enclosed or single_enclosed:
            return True
      return False

   @staticmethod
   def _is_word(token, brackets):
      if token.strip():
         if not token[0] in brackets and not token[-1] in brackets:
            return True
      return False

   def _bracket_enclosed_string(self):
      for bracket in self.brackets:
         token = self.params[self.pos]
         if self._is_start(token, bracket) or token == bracket:
            token = token[1:]
            self.tokens.append(token)
            self.pos += 1

            length = len(self.params)
            while self.pos < length and \
                  self._is_word(self.params[self.pos], [bracket]):
               token = self.params[self.pos]
               self.tokens.append(token)
               self.pos += 1

            if self.pos == length:
               raise Exception("String parsing error")

            if self._is_end(self.params[self.pos], bracket):
               token = self.params[self.pos][:-1]
               self.tokens.append(token)
               self.pos += 1
            elif self.params[self.pos] == bracket:
               self.pos += 1
            else:
               raise Exception("String parsing error")
            return True
      return False

   def _bracket_enclosed_word(self):
      if self._is_enclosed(self.params[self.pos]):
         token = self.params[self.pos][1:-1]
         self.tokens.append(token)
         self.pos += 1
         return True
      return False

   def _single_word(self):
      if self._is_word(self.params[self.pos], self.brackets):
         self.tokens.append(self.params[self.pos])
         self.pos += 1
         return True
      return False

   def run(self):
      self.pos += 1
      if self._bracket_enclosed_string() or \
         self._bracket_enclosed_word() or \
         self._single_word():
         self.value = " ".join(self.tokens)
      else:
         raise Exception("String parsing error")

