# Copyright (c) 2014-2016, The Regents of the University of California.
# Copyright (c) 2016-2017, Nefeli Networks, Inc.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# * Redistributions of source code must retain the above copyright notice, this
# list of conditions and the following disclaimer.
#
# * Redistributions in binary form must reproduce the above copyright notice,
# this list of conditions and the following disclaimer in the documentation
# and/or other materials provided with the distribution.
#
# * Neither the names of the copyright holders nor the names of their
# contributors may be used to endorse or promote products derived from this
# software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

import types

def _callback_factory(self, cmd, arg_type):
    return lambda mod, **kwargs: \
        self.bess.run_port_command(self.name, cmd, arg_type, kwargs)

class Port(object):

    def __init__(self, **kwargs):
        self.name = '<uninitialized>'
        self.driver = self.__class__.__name__

        assert self.driver != 'Port', "Do not instantiate 'Port' directly"

        name = kwargs.pop('name', None)

        ret = self.bess.create_port(self.driver, name,
                                    self.choose_arg(None, kwargs))

        self.name = ret.name
        self.mac_addr = ret.mac_addr

        # add driverclass-specific methods
        cls = self.bess.get_driver_info(self.__class__.__name__)
        assert len(cls.commands) == len(cls.cmd_args)
        for i, cmd in enumerate(cls.commands):
            func = _callback_factory(self, cmd, cls.cmd_args[i])
            setattr(self, cmd, types.MethodType(func, self))

    def __str__(self):
        return '%s/%s' % (self.name, self.driver)

    def get_port_stats(self):
        return self.bess.get_port_stats(self.name)

    def get_port_module_eeprom(self, offset, size):
        return self.bess.get_port_module_eeprom(self.name, offset, size)

    def get_port_module_eeprom_length(self):
        return self.bess.get_port_module_eeprom_length(self.name)

    def get_port_xstats_names(self):
        return self.bess.get_port_xstats_names(self.name)

    def get_port_xstats(self, ids):
        return self.bess.get_port_xstats(self.name, ids)

    def get_port_firmware_version(self):
        return self.bess.get_port_firmware_version(self.name)

    def get_port_transceiver_information(self):
        return self.bess.get_port_transceiver_information(self.name)

    def get_link_settings(self):
        return self.bess.get_link_settings(self.name)

    def get_link_status(self):
        return self.bess.get_link_status(self.name)

    def set_port_config(self, **kwargs):
        return self.bess.set_port_config(self.name,
                                         self.choose_arg(None, kwargs))

    def get_port_config(self):
        return self.bess.get_port_config(self.name)

    def set_port_mac_address(self, mac_addr):
        return self.bess.set_port_mac_address(self.name, mac_addr)

    def get_port_mac_address(self):
        return self.bess.get_port_mac_address(self.name)

    def set_port_mtu(self, mtu):
        return self.bess.set_port_mtu(self.name, mtu)

    def get_port_mtu(self):
        return self.bess.get_port_mtu(self.name)

    def set_port_admin_state(self, admin_up):
        return self.bess.set_port_admin_state(self.name, admin_up)

    def get_port_admin_state(self):
        return self.bess.get_port_admin_state(self.name)
