// Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
// Arista Networks, Inc. Confidential and Proprietary.
// Subject to Arista Networks, Inc.'s EULA.
// FOR INTERNAL USE ONLY. NOT FOR DISTRIBUTION.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        v3.20.3
// source: arista/segmentation.v1/segmentation.proto

package segmentation

import (
	reflect "reflect"
	sync "sync"

	fmp "github.com/aristanetworks/cloudvision-go/api/fmp"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Action int32

const (
	// ACTION_UNSPECIFIED indicates that a action is unspecified.
	Action_ACTION_UNSPECIFIED Action = 0
	// ACTION_DROP indicates that packets should be dropped.
	Action_ACTION_DROP Action = 1
	// ACTION_FORWARD indicates that packets should be forwarded.
	Action_ACTION_FORWARD Action = 2
)

// Enum value maps for Action.
var (
	Action_name = map[int32]string{
		0: "ACTION_UNSPECIFIED",
		1: "ACTION_DROP",
		2: "ACTION_FORWARD",
	}
	Action_value = map[string]int32{
		"ACTION_UNSPECIFIED": 0,
		"ACTION_DROP":        1,
		"ACTION_FORWARD":     2,
	}
)

func (x Action) Enum() *Action {
	p := new(Action)
	*p = x
	return p
}

func (x Action) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Action) Descriptor() protoreflect.EnumDescriptor {
	return file_arista_segmentation_v1_segmentation_proto_enumTypes[0].Descriptor()
}

func (Action) Type() protoreflect.EnumType {
	return &file_arista_segmentation_v1_segmentation_proto_enumTypes[0]
}

func (x Action) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Action.Descriptor instead.
func (Action) EnumDescriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_segmentation_proto_rawDescGZIP(), []int{0}
}

type DomainKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Domain *wrapperspb.StringValue `protobuf:"bytes,1,opt,name=domain,proto3" json:"domain,omitempty"`
	Vrf    *wrapperspb.StringValue `protobuf:"bytes,2,opt,name=vrf,proto3" json:"vrf,omitempty"`
}

func (x *DomainKey) Reset() {
	*x = DomainKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_segmentation_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainKey) ProtoMessage() {}

func (x *DomainKey) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_segmentation_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainKey.ProtoReflect.Descriptor instead.
func (*DomainKey) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_segmentation_proto_rawDescGZIP(), []int{0}
}

func (x *DomainKey) GetDomain() *wrapperspb.StringValue {
	if x != nil {
		return x.Domain
	}
	return nil
}

func (x *DomainKey) GetVrf() *wrapperspb.StringValue {
	if x != nil {
		return x.Vrf
	}
	return nil
}

// ApplicationKey is the name of the application.
type ApplicationKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Application *wrapperspb.StringValue `protobuf:"bytes,1,opt,name=application,proto3" json:"application,omitempty"`
}

func (x *ApplicationKey) Reset() {
	*x = ApplicationKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_segmentation_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationKey) ProtoMessage() {}

func (x *ApplicationKey) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_segmentation_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationKey.ProtoReflect.Descriptor instead.
func (*ApplicationKey) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_segmentation_proto_rawDescGZIP(), []int{1}
}

func (x *ApplicationKey) GetApplication() *wrapperspb.StringValue {
	if x != nil {
		return x.Application
	}
	return nil
}

// ApplicationList is a container for a list of application names.
type ApplicationList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Values []string `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *ApplicationList) Reset() {
	*x = ApplicationList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_segmentation_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationList) ProtoMessage() {}

func (x *ApplicationList) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_segmentation_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationList.ProtoReflect.Descriptor instead.
func (*ApplicationList) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_segmentation_proto_rawDescGZIP(), []int{2}
}

func (x *ApplicationList) GetValues() []string {
	if x != nil {
		return x.Values
	}
	return nil
}

// ApplicationAction is the application name - Action pairing.
type ApplicationAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Values map[string]Action `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3,enum=arista.segmentation.v1.Action"`
}

func (x *ApplicationAction) Reset() {
	*x = ApplicationAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_segmentation_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationAction) ProtoMessage() {}

func (x *ApplicationAction) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_segmentation_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationAction.ProtoReflect.Descriptor instead.
func (*ApplicationAction) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_segmentation_proto_rawDescGZIP(), []int{3}
}

func (x *ApplicationAction) GetValues() map[string]Action {
	if x != nil {
		return x.Values
	}
	return nil
}

type ApplicationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key          *ApplicationKey         `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	SrcPortStart *fmp.Port               `protobuf:"bytes,2,opt,name=src_port_start,json=srcPortStart,proto3" json:"src_port_start,omitempty"`
	SrcPortEnd   *fmp.Port               `protobuf:"bytes,3,opt,name=src_port_end,json=srcPortEnd,proto3" json:"src_port_end,omitempty"`
	DstPortStart *fmp.Port               `protobuf:"bytes,4,opt,name=dst_port_start,json=dstPortStart,proto3" json:"dst_port_start,omitempty"`
	DstPortEnd   *fmp.Port               `protobuf:"bytes,5,opt,name=dst_port_end,json=dstPortEnd,proto3" json:"dst_port_end,omitempty"`
	Protocol     *wrapperspb.UInt32Value `protobuf:"bytes,6,opt,name=protocol,proto3" json:"protocol,omitempty"`
}

func (x *ApplicationConfig) Reset() {
	*x = ApplicationConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_segmentation_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationConfig) ProtoMessage() {}

func (x *ApplicationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_segmentation_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationConfig.ProtoReflect.Descriptor instead.
func (*ApplicationConfig) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_segmentation_proto_rawDescGZIP(), []int{4}
}

func (x *ApplicationConfig) GetKey() *ApplicationKey {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *ApplicationConfig) GetSrcPortStart() *fmp.Port {
	if x != nil {
		return x.SrcPortStart
	}
	return nil
}

func (x *ApplicationConfig) GetSrcPortEnd() *fmp.Port {
	if x != nil {
		return x.SrcPortEnd
	}
	return nil
}

func (x *ApplicationConfig) GetDstPortStart() *fmp.Port {
	if x != nil {
		return x.DstPortStart
	}
	return nil
}

func (x *ApplicationConfig) GetDstPortEnd() *fmp.Port {
	if x != nil {
		return x.DstPortEnd
	}
	return nil
}

func (x *ApplicationConfig) GetProtocol() *wrapperspb.UInt32Value {
	if x != nil {
		return x.Protocol
	}
	return nil
}

// PolicyKey is a unique identifier for a Policy
type PolicyKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Policy *wrapperspb.StringValue `protobuf:"bytes,1,opt,name=policy,proto3" json:"policy,omitempty"`
}

func (x *PolicyKey) Reset() {
	*x = PolicyKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_segmentation_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyKey) ProtoMessage() {}

func (x *PolicyKey) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_segmentation_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyKey.ProtoReflect.Descriptor instead.
func (*PolicyKey) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_segmentation_proto_rawDescGZIP(), []int{5}
}

func (x *PolicyKey) GetPolicy() *wrapperspb.StringValue {
	if x != nil {
		return x.Policy
	}
	return nil
}

// PolicyConfig contains the actions to take for each application in the policy.
type PolicyConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key               *PolicyKey         `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	ApplicationOrder  *ApplicationList   `protobuf:"bytes,2,opt,name=application_order,json=applicationOrder,proto3" json:"application_order,omitempty"`
	ApplicationAction *ApplicationAction `protobuf:"bytes,3,opt,name=application_action,json=applicationAction,proto3" json:"application_action,omitempty"`
}

func (x *PolicyConfig) Reset() {
	*x = PolicyConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_segmentation_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyConfig) ProtoMessage() {}

func (x *PolicyConfig) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_segmentation_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyConfig.ProtoReflect.Descriptor instead.
func (*PolicyConfig) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_segmentation_proto_rawDescGZIP(), []int{6}
}

func (x *PolicyConfig) GetKey() *PolicyKey {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *PolicyConfig) GetApplicationOrder() *ApplicationList {
	if x != nil {
		return x.ApplicationOrder
	}
	return nil
}

func (x *PolicyConfig) GetApplicationAction() *ApplicationAction {
	if x != nil {
		return x.ApplicationAction
	}
	return nil
}

type SegmentPolicyKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SrcSegment *wrapperspb.StringValue `protobuf:"bytes,1,opt,name=src_segment,json=srcSegment,proto3" json:"src_segment,omitempty"`
	DstSegment *wrapperspb.StringValue `protobuf:"bytes,2,opt,name=dst_segment,json=dstSegment,proto3" json:"dst_segment,omitempty"`
}

func (x *SegmentPolicyKey) Reset() {
	*x = SegmentPolicyKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_segmentation_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SegmentPolicyKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SegmentPolicyKey) ProtoMessage() {}

func (x *SegmentPolicyKey) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_segmentation_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SegmentPolicyKey.ProtoReflect.Descriptor instead.
func (*SegmentPolicyKey) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_segmentation_proto_rawDescGZIP(), []int{7}
}

func (x *SegmentPolicyKey) GetSrcSegment() *wrapperspb.StringValue {
	if x != nil {
		return x.SrcSegment
	}
	return nil
}

func (x *SegmentPolicyKey) GetDstSegment() *wrapperspb.StringValue {
	if x != nil {
		return x.DstSegment
	}
	return nil
}

type SegmentPolicyConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key    *SegmentPolicyKey       `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Policy *wrapperspb.StringValue `protobuf:"bytes,2,opt,name=policy,proto3" json:"policy,omitempty"`
}

func (x *SegmentPolicyConfig) Reset() {
	*x = SegmentPolicyConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_segmentation_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SegmentPolicyConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SegmentPolicyConfig) ProtoMessage() {}

func (x *SegmentPolicyConfig) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_segmentation_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SegmentPolicyConfig.ProtoReflect.Descriptor instead.
func (*SegmentPolicyConfig) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_segmentation_proto_rawDescGZIP(), []int{8}
}

func (x *SegmentPolicyConfig) GetKey() *SegmentPolicyKey {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *SegmentPolicyConfig) GetPolicy() *wrapperspb.StringValue {
	if x != nil {
		return x.Policy
	}
	return nil
}

type SegmentPolicyConfigList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Values []*SegmentPolicyConfig `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *SegmentPolicyConfigList) Reset() {
	*x = SegmentPolicyConfigList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_segmentation_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SegmentPolicyConfigList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SegmentPolicyConfigList) ProtoMessage() {}

func (x *SegmentPolicyConfigList) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_segmentation_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SegmentPolicyConfigList.ProtoReflect.Descriptor instead.
func (*SegmentPolicyConfigList) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_segmentation_proto_rawDescGZIP(), []int{9}
}

func (x *SegmentPolicyConfigList) GetValues() []*SegmentPolicyConfig {
	if x != nil {
		return x.Values
	}
	return nil
}

// SegmentKey is a unique key representing a Segment.
type SegmentKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Segment *wrapperspb.StringValue `protobuf:"bytes,1,opt,name=segment,proto3" json:"segment,omitempty"`
}

func (x *SegmentKey) Reset() {
	*x = SegmentKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_segmentation_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SegmentKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SegmentKey) ProtoMessage() {}

func (x *SegmentKey) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_segmentation_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SegmentKey.ProtoReflect.Descriptor instead.
func (*SegmentKey) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_segmentation_proto_rawDescGZIP(), []int{10}
}

func (x *SegmentKey) GetSegment() *wrapperspb.StringValue {
	if x != nil {
		return x.Segment
	}
	return nil
}

type SegmentConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key *SegmentKey `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
}

func (x *SegmentConfig) Reset() {
	*x = SegmentConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_segmentation_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SegmentConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SegmentConfig) ProtoMessage() {}

func (x *SegmentConfig) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_segmentation_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SegmentConfig.ProtoReflect.Descriptor instead.
func (*SegmentConfig) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_segmentation_proto_rawDescGZIP(), []int{11}
}

func (x *SegmentConfig) GetKey() *SegmentKey {
	if x != nil {
		return x.Key
	}
	return nil
}

type SegmentConfigList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Values []*SegmentConfig `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *SegmentConfigList) Reset() {
	*x = SegmentConfigList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_segmentation_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SegmentConfigList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SegmentConfigList) ProtoMessage() {}

func (x *SegmentConfigList) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_segmentation_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SegmentConfigList.ProtoReflect.Descriptor instead.
func (*SegmentConfigList) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_segmentation_proto_rawDescGZIP(), []int{12}
}

func (x *SegmentConfigList) GetValues() []*SegmentConfig {
	if x != nil {
		return x.Values
	}
	return nil
}

// IPPrefixKey is a unique IP prefix.
type IPPrefixKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	IpPrefix *fmp.IPPrefix `protobuf:"bytes,1,opt,name=ip_prefix,json=ipPrefix,proto3" json:"ip_prefix,omitempty"`
}

func (x *IPPrefixKey) Reset() {
	*x = IPPrefixKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_segmentation_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IPPrefixKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IPPrefixKey) ProtoMessage() {}

func (x *IPPrefixKey) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_segmentation_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IPPrefixKey.ProtoReflect.Descriptor instead.
func (*IPPrefixKey) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_segmentation_proto_rawDescGZIP(), []int{13}
}

func (x *IPPrefixKey) GetIpPrefix() *fmp.IPPrefix {
	if x != nil {
		return x.IpPrefix
	}
	return nil
}

// IPPrefixConfig is a collection of prefix mapped to a segment.
type IPPrefixConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key     *IPPrefixKey            `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Segment *wrapperspb.StringValue `protobuf:"bytes,2,opt,name=segment,proto3" json:"segment,omitempty"`
}

func (x *IPPrefixConfig) Reset() {
	*x = IPPrefixConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_segmentation_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IPPrefixConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IPPrefixConfig) ProtoMessage() {}

func (x *IPPrefixConfig) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_segmentation_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IPPrefixConfig.ProtoReflect.Descriptor instead.
func (*IPPrefixConfig) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_segmentation_proto_rawDescGZIP(), []int{14}
}

func (x *IPPrefixConfig) GetKey() *IPPrefixKey {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *IPPrefixConfig) GetSegment() *wrapperspb.StringValue {
	if x != nil {
		return x.Segment
	}
	return nil
}

type IPPrefixConfigList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Values []*IPPrefixConfig `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *IPPrefixConfigList) Reset() {
	*x = IPPrefixConfigList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_segmentation_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IPPrefixConfigList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IPPrefixConfigList) ProtoMessage() {}

func (x *IPPrefixConfigList) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_segmentation_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IPPrefixConfigList.ProtoReflect.Descriptor instead.
func (*IPPrefixConfigList) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_segmentation_proto_rawDescGZIP(), []int{15}
}

func (x *IPPrefixConfigList) GetValues() []*IPPrefixConfig {
	if x != nil {
		return x.Values
	}
	return nil
}

type DefaultActionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// unspecified_policy_action determines what action the
	// hardware should take when it sees a packet whose
	// destination IP is assigned to a segment, but no
	// segment policy applies.
	UnspecifiedPolicyAction Action `protobuf:"varint,1,opt,name=unspecified_policy_action,json=unspecifiedPolicyAction,proto3,enum=arista.segmentation.v1.Action" json:"unspecified_policy_action,omitempty"`
}

func (x *DefaultActionConfig) Reset() {
	*x = DefaultActionConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_segmentation_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DefaultActionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DefaultActionConfig) ProtoMessage() {}

func (x *DefaultActionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_segmentation_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DefaultActionConfig.ProtoReflect.Descriptor instead.
func (*DefaultActionConfig) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_segmentation_proto_rawDescGZIP(), []int{16}
}

func (x *DefaultActionConfig) GetUnspecifiedPolicyAction() Action {
	if x != nil {
		return x.UnspecifiedPolicyAction
	}
	return Action_ACTION_UNSPECIFIED
}

type DomainConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key           *DomainKey               `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	IpPrefix      *IPPrefixConfigList      `protobuf:"bytes,2,opt,name=ip_prefix,json=ipPrefix,proto3" json:"ip_prefix,omitempty"`
	Segment       *SegmentConfigList       `protobuf:"bytes,3,opt,name=segment,proto3" json:"segment,omitempty"`
	SegmentPolicy *SegmentPolicyConfigList `protobuf:"bytes,4,opt,name=segment_policy,json=segmentPolicy,proto3" json:"segment_policy,omitempty"`
}

func (x *DomainConfig) Reset() {
	*x = DomainConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_segmentation_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainConfig) ProtoMessage() {}

func (x *DomainConfig) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_segmentation_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainConfig.ProtoReflect.Descriptor instead.
func (*DomainConfig) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_segmentation_proto_rawDescGZIP(), []int{17}
}

func (x *DomainConfig) GetKey() *DomainKey {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *DomainConfig) GetIpPrefix() *IPPrefixConfigList {
	if x != nil {
		return x.IpPrefix
	}
	return nil
}

func (x *DomainConfig) GetSegment() *SegmentConfigList {
	if x != nil {
		return x.Segment
	}
	return nil
}

func (x *DomainConfig) GetSegmentPolicy() *SegmentPolicyConfigList {
	if x != nil {
		return x.SegmentPolicy
	}
	return nil
}

type SegmentPolicyCounters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Hits  *wrapperspb.UInt64Value `protobuf:"bytes,1,opt,name=hits,proto3" json:"hits,omitempty"`
	Drops *wrapperspb.UInt64Value `protobuf:"bytes,2,opt,name=drops,proto3" json:"drops,omitempty"`
}

func (x *SegmentPolicyCounters) Reset() {
	*x = SegmentPolicyCounters{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_segmentation_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SegmentPolicyCounters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SegmentPolicyCounters) ProtoMessage() {}

func (x *SegmentPolicyCounters) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_segmentation_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SegmentPolicyCounters.ProtoReflect.Descriptor instead.
func (*SegmentPolicyCounters) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_segmentation_proto_rawDescGZIP(), []int{18}
}

func (x *SegmentPolicyCounters) GetHits() *wrapperspb.UInt64Value {
	if x != nil {
		return x.Hits
	}
	return nil
}

func (x *SegmentPolicyCounters) GetDrops() *wrapperspb.UInt64Value {
	if x != nil {
		return x.Drops
	}
	return nil
}

type SegmentPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key      *SegmentPolicyKey      `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Counters *SegmentPolicyCounters `protobuf:"bytes,2,opt,name=counters,proto3" json:"counters,omitempty"`
}

func (x *SegmentPolicy) Reset() {
	*x = SegmentPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_segmentation_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SegmentPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SegmentPolicy) ProtoMessage() {}

func (x *SegmentPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_segmentation_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SegmentPolicy.ProtoReflect.Descriptor instead.
func (*SegmentPolicy) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_segmentation_proto_rawDescGZIP(), []int{19}
}

func (x *SegmentPolicy) GetKey() *SegmentPolicyKey {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *SegmentPolicy) GetCounters() *SegmentPolicyCounters {
	if x != nil {
		return x.Counters
	}
	return nil
}

type SegmentPolicyList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Values []*SegmentPolicy `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *SegmentPolicyList) Reset() {
	*x = SegmentPolicyList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_segmentation_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SegmentPolicyList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SegmentPolicyList) ProtoMessage() {}

func (x *SegmentPolicyList) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_segmentation_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SegmentPolicyList.ProtoReflect.Descriptor instead.
func (*SegmentPolicyList) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_segmentation_proto_rawDescGZIP(), []int{20}
}

func (x *SegmentPolicyList) GetValues() []*SegmentPolicy {
	if x != nil {
		return x.Values
	}
	return nil
}

type Domain struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key           *DomainKey         `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	SegmentPolicy *SegmentPolicyList `protobuf:"bytes,2,opt,name=segment_policy,json=segmentPolicy,proto3" json:"segment_policy,omitempty"`
}

func (x *Domain) Reset() {
	*x = Domain{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_segmentation_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Domain) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Domain) ProtoMessage() {}

func (x *Domain) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_segmentation_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Domain.ProtoReflect.Descriptor instead.
func (*Domain) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_segmentation_proto_rawDescGZIP(), []int{21}
}

func (x *Domain) GetKey() *DomainKey {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *Domain) GetSegmentPolicy() *SegmentPolicyList {
	if x != nil {
		return x.SegmentPolicy
	}
	return nil
}

var File_arista_segmentation_v1_segmentation_proto protoreflect.FileDescriptor

var file_arista_segmentation_v1_segmentation_proto_rawDesc = []byte{
	0x0a, 0x29, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2f, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2f, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x61, 0x72, 0x69,
	0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x14, 0x66, 0x6d, 0x70, 0x2f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x0e, 0x66, 0x6d, 0x70, 0x2f, 0x69,
	0x6e, 0x65, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x77, 0x0a, 0x09, 0x44, 0x6f, 0x6d,
	0x61, 0x69, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x34, 0x0a, 0x06, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x12, 0x2e, 0x0a, 0x03,
	0x76, 0x72, 0x66, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x03, 0x76, 0x72, 0x66, 0x3a, 0x04, 0x80, 0x8e,
	0x19, 0x01, 0x22, 0x56, 0x0a, 0x0e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4b, 0x65, 0x79, 0x12, 0x3e, 0x0a, 0x0b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x04, 0x80, 0x8e, 0x19, 0x01, 0x22, 0x29, 0x0a, 0x0f, 0x41, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x16, 0x0a,
	0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x22, 0xbd, 0x01, 0x0a, 0x11, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4d, 0x0a, 0x06, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x61, 0x72,
	0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x1a, 0x59, 0x0a, 0x0b, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x34, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1e, 0x2e, 0x61, 0x72, 0x69,
	0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xcb, 0x02, 0x0a, 0x11, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x38, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74,
	0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2f, 0x0a, 0x0e, 0x73, 0x72, 0x63, 0x5f, 0x70, 0x6f, 0x72,
	0x74, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x09, 0x2e,
	0x66, 0x6d, 0x70, 0x2e, 0x50, 0x6f, 0x72, 0x74, 0x52, 0x0c, 0x73, 0x72, 0x63, 0x50, 0x6f, 0x72,
	0x74, 0x53, 0x74, 0x61, 0x72, 0x74, 0x12, 0x2b, 0x0a, 0x0c, 0x73, 0x72, 0x63, 0x5f, 0x70, 0x6f,
	0x72, 0x74, 0x5f, 0x65, 0x6e, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x09, 0x2e, 0x66,
	0x6d, 0x70, 0x2e, 0x50, 0x6f, 0x72, 0x74, 0x52, 0x0a, 0x73, 0x72, 0x63, 0x50, 0x6f, 0x72, 0x74,
	0x45, 0x6e, 0x64, 0x12, 0x2f, 0x0a, 0x0e, 0x64, 0x73, 0x74, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x5f,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x09, 0x2e, 0x66, 0x6d,
	0x70, 0x2e, 0x50, 0x6f, 0x72, 0x74, 0x52, 0x0c, 0x64, 0x73, 0x74, 0x50, 0x6f, 0x72, 0x74, 0x53,
	0x74, 0x61, 0x72, 0x74, 0x12, 0x2b, 0x0a, 0x0c, 0x64, 0x73, 0x74, 0x5f, 0x70, 0x6f, 0x72, 0x74,
	0x5f, 0x65, 0x6e, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x09, 0x2e, 0x66, 0x6d, 0x70,
	0x2e, 0x50, 0x6f, 0x72, 0x74, 0x52, 0x0a, 0x64, 0x73, 0x74, 0x50, 0x6f, 0x72, 0x74, 0x45, 0x6e,
	0x64, 0x12, 0x38, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x3a, 0x06, 0xfa, 0x8d, 0x19,
	0x02, 0x72, 0x77, 0x22, 0x47, 0x0a, 0x09, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4b, 0x65, 0x79,
	0x12, 0x34, 0x0a, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x3a, 0x04, 0x80, 0x8e, 0x19, 0x01, 0x22, 0xfb, 0x01, 0x0a,
	0x0c, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x33, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x61, 0x72, 0x69,
	0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4b, 0x65, 0x79, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x54, 0x0a, 0x11, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e,
	0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x10, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x12, 0x58, 0x0a, 0x12, 0x61, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x11, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x3a, 0x06, 0xfa, 0x8d, 0x19, 0x02, 0x72, 0x77, 0x22, 0x96, 0x01, 0x0a, 0x10, 0x53,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4b, 0x65, 0x79, 0x12,
	0x3d, 0x0a, 0x0b, 0x73, 0x72, 0x63, 0x5f, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x0a, 0x73, 0x72, 0x63, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x3d,
	0x0a, 0x0b, 0x64, 0x73, 0x74, 0x5f, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x0a, 0x64, 0x73, 0x74, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x3a, 0x04, 0x80,
	0x8e, 0x19, 0x01, 0x22, 0x87, 0x01, 0x0a, 0x13, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3a, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74,
	0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4b,
	0x65, 0x79, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x34, 0x0a, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x5e, 0x0a,
	0x17, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74,
	0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x22, 0x4a, 0x0a,
	0x0a, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x4b, 0x65, 0x79, 0x12, 0x36, 0x0a, 0x07, 0x73,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x07, 0x73, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x3a, 0x04, 0x80, 0x8e, 0x19, 0x01, 0x22, 0x45, 0x0a, 0x0d, 0x53, 0x65, 0x67,
	0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x34, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61,
	0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x4b, 0x65, 0x79, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x22, 0x52, 0x0a, 0x11, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x73, 0x22, 0x3f, 0x0a, 0x0b, 0x49, 0x50, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78,
	0x4b, 0x65, 0x79, 0x12, 0x2a, 0x0a, 0x09, 0x69, 0x70, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x66, 0x6d, 0x70, 0x2e, 0x49, 0x50, 0x50,
	0x72, 0x65, 0x66, 0x69, 0x78, 0x52, 0x08, 0x69, 0x70, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x3a,
	0x04, 0x80, 0x8e, 0x19, 0x01, 0x22, 0x7f, 0x0a, 0x0e, 0x49, 0x50, 0x50, 0x72, 0x65, 0x66, 0x69,
	0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x35, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x50,
	0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x4b, 0x65, 0x79, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x36,
	0x0a, 0x07, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x07, 0x73,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x54, 0x0a, 0x12, 0x49, 0x50, 0x50, 0x72, 0x65, 0x66,
	0x69, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x06,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x61,
	0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x50, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x22, 0x79, 0x0a, 0x13,
	0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x5a, 0x0a, 0x19, 0x75, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69,
	0x65, 0x64, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1e, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e,
	0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x17, 0x75, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66,
	0x69, 0x65, 0x64, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x3a,
	0x06, 0xa2, 0x8e, 0x19, 0x02, 0x72, 0x77, 0x22, 0xc9, 0x02, 0x0a, 0x0c, 0x44, 0x6f, 0x6d, 0x61,
	0x69, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x33, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x4f, 0x0a,
	0x09, 0x69, 0x70, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2a, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x50, 0x50, 0x72, 0x65, 0x66,
	0x69, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x06, 0xca, 0x8f,
	0x19, 0x02, 0x72, 0x77, 0x52, 0x08, 0x69, 0x70, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x12, 0x4b,
	0x0a, 0x07, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x06, 0xca, 0x8f, 0x19, 0x02,
	0x72, 0x77, 0x52, 0x07, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x5e, 0x0a, 0x0e, 0x73,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x67,
	0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x4c, 0x69, 0x73, 0x74, 0x42, 0x06, 0xca, 0x8f, 0x19, 0x02, 0x72, 0x77, 0x52, 0x0d, 0x73, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x3a, 0x06, 0xfa, 0x8d, 0x19,
	0x02, 0x72, 0x77, 0x22, 0x7d, 0x0a, 0x15, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x73, 0x12, 0x30, 0x0a, 0x04,
	0x68, 0x69, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e,
	0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x04, 0x68, 0x69, 0x74, 0x73, 0x12, 0x32,
	0x0a, 0x05, 0x64, 0x72, 0x6f, 0x70, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x55, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x64, 0x72, 0x6f,
	0x70, 0x73, 0x22, 0x96, 0x01, 0x0a, 0x0d, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x12, 0x3a, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4b, 0x65, 0x79, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x49, 0x0a, 0x08, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72,
	0x73, 0x52, 0x08, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x73, 0x22, 0x52, 0x0a, 0x11, 0x53,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4c, 0x69, 0x73, 0x74,
	0x12, 0x3d, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x25, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e,
	0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x22,
	0x9f, 0x01, 0x0a, 0x06, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x12, 0x33, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61,
	0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x58, 0x0a, 0x0e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61,
	0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4c, 0x69,
	0x73, 0x74, 0x42, 0x06, 0xca, 0x8f, 0x19, 0x02, 0x72, 0x6f, 0x52, 0x0d, 0x73, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x3a, 0x06, 0xfa, 0x8d, 0x19, 0x02, 0x72,
	0x6f, 0x2a, 0x45, 0x0a, 0x06, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x12, 0x41,
	0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x52,
	0x4f, 0x50, 0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x46,
	0x4f, 0x52, 0x57, 0x41, 0x52, 0x44, 0x10, 0x02, 0x42, 0x62, 0x0a, 0x1a, 0x63, 0x6f, 0x6d, 0x2e,
	0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x42, 0x0c, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x01, 0x5a, 0x34, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2f,
	0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x3b,
	0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_arista_segmentation_v1_segmentation_proto_rawDescOnce sync.Once
	file_arista_segmentation_v1_segmentation_proto_rawDescData = file_arista_segmentation_v1_segmentation_proto_rawDesc
)

func file_arista_segmentation_v1_segmentation_proto_rawDescGZIP() []byte {
	file_arista_segmentation_v1_segmentation_proto_rawDescOnce.Do(func() {
		file_arista_segmentation_v1_segmentation_proto_rawDescData = protoimpl.X.CompressGZIP(file_arista_segmentation_v1_segmentation_proto_rawDescData)
	})
	return file_arista_segmentation_v1_segmentation_proto_rawDescData
}

var file_arista_segmentation_v1_segmentation_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_arista_segmentation_v1_segmentation_proto_msgTypes = make([]protoimpl.MessageInfo, 23)
var file_arista_segmentation_v1_segmentation_proto_goTypes = []interface{}{
	(Action)(0),                     // 0: arista.segmentation.v1.Action
	(*DomainKey)(nil),               // 1: arista.segmentation.v1.DomainKey
	(*ApplicationKey)(nil),          // 2: arista.segmentation.v1.ApplicationKey
	(*ApplicationList)(nil),         // 3: arista.segmentation.v1.ApplicationList
	(*ApplicationAction)(nil),       // 4: arista.segmentation.v1.ApplicationAction
	(*ApplicationConfig)(nil),       // 5: arista.segmentation.v1.ApplicationConfig
	(*PolicyKey)(nil),               // 6: arista.segmentation.v1.PolicyKey
	(*PolicyConfig)(nil),            // 7: arista.segmentation.v1.PolicyConfig
	(*SegmentPolicyKey)(nil),        // 8: arista.segmentation.v1.SegmentPolicyKey
	(*SegmentPolicyConfig)(nil),     // 9: arista.segmentation.v1.SegmentPolicyConfig
	(*SegmentPolicyConfigList)(nil), // 10: arista.segmentation.v1.SegmentPolicyConfigList
	(*SegmentKey)(nil),              // 11: arista.segmentation.v1.SegmentKey
	(*SegmentConfig)(nil),           // 12: arista.segmentation.v1.SegmentConfig
	(*SegmentConfigList)(nil),       // 13: arista.segmentation.v1.SegmentConfigList
	(*IPPrefixKey)(nil),             // 14: arista.segmentation.v1.IPPrefixKey
	(*IPPrefixConfig)(nil),          // 15: arista.segmentation.v1.IPPrefixConfig
	(*IPPrefixConfigList)(nil),      // 16: arista.segmentation.v1.IPPrefixConfigList
	(*DefaultActionConfig)(nil),     // 17: arista.segmentation.v1.DefaultActionConfig
	(*DomainConfig)(nil),            // 18: arista.segmentation.v1.DomainConfig
	(*SegmentPolicyCounters)(nil),   // 19: arista.segmentation.v1.SegmentPolicyCounters
	(*SegmentPolicy)(nil),           // 20: arista.segmentation.v1.SegmentPolicy
	(*SegmentPolicyList)(nil),       // 21: arista.segmentation.v1.SegmentPolicyList
	(*Domain)(nil),                  // 22: arista.segmentation.v1.Domain
	nil,                             // 23: arista.segmentation.v1.ApplicationAction.ValuesEntry
	(*wrapperspb.StringValue)(nil),  // 24: google.protobuf.StringValue
	(*fmp.Port)(nil),                // 25: fmp.Port
	(*wrapperspb.UInt32Value)(nil),  // 26: google.protobuf.UInt32Value
	(*fmp.IPPrefix)(nil),            // 27: fmp.IPPrefix
	(*wrapperspb.UInt64Value)(nil),  // 28: google.protobuf.UInt64Value
}
var file_arista_segmentation_v1_segmentation_proto_depIdxs = []int32{
	24, // 0: arista.segmentation.v1.DomainKey.domain:type_name -> google.protobuf.StringValue
	24, // 1: arista.segmentation.v1.DomainKey.vrf:type_name -> google.protobuf.StringValue
	24, // 2: arista.segmentation.v1.ApplicationKey.application:type_name -> google.protobuf.StringValue
	23, // 3: arista.segmentation.v1.ApplicationAction.values:type_name -> arista.segmentation.v1.ApplicationAction.ValuesEntry
	2,  // 4: arista.segmentation.v1.ApplicationConfig.key:type_name -> arista.segmentation.v1.ApplicationKey
	25, // 5: arista.segmentation.v1.ApplicationConfig.src_port_start:type_name -> fmp.Port
	25, // 6: arista.segmentation.v1.ApplicationConfig.src_port_end:type_name -> fmp.Port
	25, // 7: arista.segmentation.v1.ApplicationConfig.dst_port_start:type_name -> fmp.Port
	25, // 8: arista.segmentation.v1.ApplicationConfig.dst_port_end:type_name -> fmp.Port
	26, // 9: arista.segmentation.v1.ApplicationConfig.protocol:type_name -> google.protobuf.UInt32Value
	24, // 10: arista.segmentation.v1.PolicyKey.policy:type_name -> google.protobuf.StringValue
	6,  // 11: arista.segmentation.v1.PolicyConfig.key:type_name -> arista.segmentation.v1.PolicyKey
	3,  // 12: arista.segmentation.v1.PolicyConfig.application_order:type_name -> arista.segmentation.v1.ApplicationList
	4,  // 13: arista.segmentation.v1.PolicyConfig.application_action:type_name -> arista.segmentation.v1.ApplicationAction
	24, // 14: arista.segmentation.v1.SegmentPolicyKey.src_segment:type_name -> google.protobuf.StringValue
	24, // 15: arista.segmentation.v1.SegmentPolicyKey.dst_segment:type_name -> google.protobuf.StringValue
	8,  // 16: arista.segmentation.v1.SegmentPolicyConfig.key:type_name -> arista.segmentation.v1.SegmentPolicyKey
	24, // 17: arista.segmentation.v1.SegmentPolicyConfig.policy:type_name -> google.protobuf.StringValue
	9,  // 18: arista.segmentation.v1.SegmentPolicyConfigList.values:type_name -> arista.segmentation.v1.SegmentPolicyConfig
	24, // 19: arista.segmentation.v1.SegmentKey.segment:type_name -> google.protobuf.StringValue
	11, // 20: arista.segmentation.v1.SegmentConfig.key:type_name -> arista.segmentation.v1.SegmentKey
	12, // 21: arista.segmentation.v1.SegmentConfigList.values:type_name -> arista.segmentation.v1.SegmentConfig
	27, // 22: arista.segmentation.v1.IPPrefixKey.ip_prefix:type_name -> fmp.IPPrefix
	14, // 23: arista.segmentation.v1.IPPrefixConfig.key:type_name -> arista.segmentation.v1.IPPrefixKey
	24, // 24: arista.segmentation.v1.IPPrefixConfig.segment:type_name -> google.protobuf.StringValue
	15, // 25: arista.segmentation.v1.IPPrefixConfigList.values:type_name -> arista.segmentation.v1.IPPrefixConfig
	0,  // 26: arista.segmentation.v1.DefaultActionConfig.unspecified_policy_action:type_name -> arista.segmentation.v1.Action
	1,  // 27: arista.segmentation.v1.DomainConfig.key:type_name -> arista.segmentation.v1.DomainKey
	16, // 28: arista.segmentation.v1.DomainConfig.ip_prefix:type_name -> arista.segmentation.v1.IPPrefixConfigList
	13, // 29: arista.segmentation.v1.DomainConfig.segment:type_name -> arista.segmentation.v1.SegmentConfigList
	10, // 30: arista.segmentation.v1.DomainConfig.segment_policy:type_name -> arista.segmentation.v1.SegmentPolicyConfigList
	28, // 31: arista.segmentation.v1.SegmentPolicyCounters.hits:type_name -> google.protobuf.UInt64Value
	28, // 32: arista.segmentation.v1.SegmentPolicyCounters.drops:type_name -> google.protobuf.UInt64Value
	8,  // 33: arista.segmentation.v1.SegmentPolicy.key:type_name -> arista.segmentation.v1.SegmentPolicyKey
	19, // 34: arista.segmentation.v1.SegmentPolicy.counters:type_name -> arista.segmentation.v1.SegmentPolicyCounters
	20, // 35: arista.segmentation.v1.SegmentPolicyList.values:type_name -> arista.segmentation.v1.SegmentPolicy
	1,  // 36: arista.segmentation.v1.Domain.key:type_name -> arista.segmentation.v1.DomainKey
	21, // 37: arista.segmentation.v1.Domain.segment_policy:type_name -> arista.segmentation.v1.SegmentPolicyList
	0,  // 38: arista.segmentation.v1.ApplicationAction.ValuesEntry.value:type_name -> arista.segmentation.v1.Action
	39, // [39:39] is the sub-list for method output_type
	39, // [39:39] is the sub-list for method input_type
	39, // [39:39] is the sub-list for extension type_name
	39, // [39:39] is the sub-list for extension extendee
	0,  // [0:39] is the sub-list for field type_name
}

func init() { file_arista_segmentation_v1_segmentation_proto_init() }
func file_arista_segmentation_v1_segmentation_proto_init() {
	if File_arista_segmentation_v1_segmentation_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_arista_segmentation_v1_segmentation_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_segmentation_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_segmentation_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_segmentation_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_segmentation_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_segmentation_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PolicyKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_segmentation_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PolicyConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_segmentation_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SegmentPolicyKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_segmentation_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SegmentPolicyConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_segmentation_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SegmentPolicyConfigList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_segmentation_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SegmentKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_segmentation_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SegmentConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_segmentation_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SegmentConfigList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_segmentation_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IPPrefixKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_segmentation_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IPPrefixConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_segmentation_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IPPrefixConfigList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_segmentation_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DefaultActionConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_segmentation_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_segmentation_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SegmentPolicyCounters); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_segmentation_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SegmentPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_segmentation_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SegmentPolicyList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_segmentation_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Domain); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_arista_segmentation_v1_segmentation_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   23,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_arista_segmentation_v1_segmentation_proto_goTypes,
		DependencyIndexes: file_arista_segmentation_v1_segmentation_proto_depIdxs,
		EnumInfos:         file_arista_segmentation_v1_segmentation_proto_enumTypes,
		MessageInfos:      file_arista_segmentation_v1_segmentation_proto_msgTypes,
	}.Build()
	File_arista_segmentation_v1_segmentation_proto = out.File
	file_arista_segmentation_v1_segmentation_proto_rawDesc = nil
	file_arista_segmentation_v1_segmentation_proto_goTypes = nil
	file_arista_segmentation_v1_segmentation_proto_depIdxs = nil
}
