// Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
// Arista Networks, Inc. Confidential and Proprietary.
// Subject to Arista Networks, Inc.'s EULA.
// FOR INTERNAL USE ONLY. NOT FOR DISTRIBUTION.

//
// Code generated by boomtown. DO NOT EDIT.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        v3.20.3
// source: arista/segmentation.v1/services.gen.proto

package segmentation

import (
	reflect "reflect"
	sync "sync"

	subscriptions "github.com/aristanetworks/cloudvision-go/api/arista/subscriptions"
	time "github.com/aristanetworks/cloudvision-go/api/arista/time"
	fmp "github.com/aristanetworks/cloudvision-go/api/fmp"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type MetaResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Time holds the timestamp of the last item included in the metadata calculation.
	Time *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=time,proto3" json:"time,omitempty"`
	// Operation indicates how the value in this response should be considered.
	// Under non-subscribe requests, this value should always be INITIAL. In a subscription,
	// once all initial data is streamed and the client begins to receive modification updates,
	// you should not see INITIAL again.
	Type subscriptions.Operation `protobuf:"varint,2,opt,name=type,proto3,enum=arista.subscriptions.Operation" json:"type,omitempty"`
	// Count is the number of items present under the conditions of the request.
	Count *wrapperspb.UInt32Value `protobuf:"bytes,3,opt,name=count,proto3" json:"count,omitempty"`
}

func (x *MetaResponse) Reset() {
	*x = MetaResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MetaResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetaResponse) ProtoMessage() {}

func (x *MetaResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetaResponse.ProtoReflect.Descriptor instead.
func (*MetaResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{0}
}

func (x *MetaResponse) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

func (x *MetaResponse) GetType() subscriptions.Operation {
	if x != nil {
		return x.Type
	}
	return subscriptions.Operation(0)
}

func (x *MetaResponse) GetCount() *wrapperspb.UInt32Value {
	if x != nil {
		return x.Count
	}
	return nil
}

type ApplicationConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Key uniquely identifies a ApplicationConfig instance to retrieve.
	// This value must be populated.
	Key *ApplicationKey `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Time indicates the time for which you are interested in the data.
	// If no time is given, the server will use the time at which it makes the request.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *ApplicationConfigRequest) Reset() {
	*x = ApplicationConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationConfigRequest) ProtoMessage() {}

func (x *ApplicationConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationConfigRequest.ProtoReflect.Descriptor instead.
func (*ApplicationConfigRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{1}
}

func (x *ApplicationConfigRequest) GetKey() *ApplicationKey {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *ApplicationConfigRequest) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type ApplicationConfigResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Value is the value requested.
	// This structure will be fully-populated as it exists in the datastore. If
	// optional fields were not given at creation, these fields will be empty or
	// set to default values.
	Value *ApplicationConfig `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Time carries the (UTC) timestamp of the last-modification of the
	// ApplicationConfig instance in this response.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *ApplicationConfigResponse) Reset() {
	*x = ApplicationConfigResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationConfigResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationConfigResponse) ProtoMessage() {}

func (x *ApplicationConfigResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationConfigResponse.ProtoReflect.Descriptor instead.
func (*ApplicationConfigResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{2}
}

func (x *ApplicationConfigResponse) GetValue() *ApplicationConfig {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *ApplicationConfigResponse) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type ApplicationConfigSomeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Keys []*ApplicationKey `protobuf:"bytes,1,rep,name=keys,proto3" json:"keys,omitempty"`
	// Time indicates the time for which you are interested in the data.
	// If no time is given, the server will use the time at which it makes the request.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *ApplicationConfigSomeRequest) Reset() {
	*x = ApplicationConfigSomeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationConfigSomeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationConfigSomeRequest) ProtoMessage() {}

func (x *ApplicationConfigSomeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationConfigSomeRequest.ProtoReflect.Descriptor instead.
func (*ApplicationConfigSomeRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{3}
}

func (x *ApplicationConfigSomeRequest) GetKeys() []*ApplicationKey {
	if x != nil {
		return x.Keys
	}
	return nil
}

func (x *ApplicationConfigSomeRequest) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type ApplicationConfigSomeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Value is the value requested.
	// This structure will be fully-populated as it exists in the datastore. If
	// optional fields were not given at creation, these fields will be empty or
	// set to default values.
	Value *ApplicationConfig `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Error is an optional field.
	// It should be filled when there is an error in the GetSome process.
	Error *wrapperspb.StringValue `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	Time  *timestamppb.Timestamp  `protobuf:"bytes,3,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *ApplicationConfigSomeResponse) Reset() {
	*x = ApplicationConfigSomeResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationConfigSomeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationConfigSomeResponse) ProtoMessage() {}

func (x *ApplicationConfigSomeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationConfigSomeResponse.ProtoReflect.Descriptor instead.
func (*ApplicationConfigSomeResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{4}
}

func (x *ApplicationConfigSomeResponse) GetValue() *ApplicationConfig {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *ApplicationConfigSomeResponse) GetError() *wrapperspb.StringValue {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *ApplicationConfigSomeResponse) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type ApplicationConfigStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// PartialEqFilter provides a way to server-side filter a GetAll/Subscribe.
	// This requires all provided fields to be equal to the response.
	//
	// While transparent to users, this field also allows services to optimize internal
	// subscriptions if filter(s) are sufficiently specific.
	PartialEqFilter []*ApplicationConfig `protobuf:"bytes,1,rep,name=partial_eq_filter,json=partialEqFilter,proto3" json:"partial_eq_filter,omitempty"`
	// TimeRange allows limiting response data to within a specified time window.
	// If this field is populated, at least one of the two time fields are required.
	//
	// For GetAll, the fields start and end can be used as follows:
	//
	//   - end: Returns the state of each ApplicationConfig at end.
	//   - Each ApplicationConfig response is fully-specified (all fields set).
	//   - start: Returns the state of each ApplicationConfig at start, followed by updates until now.
	//   - Each ApplicationConfig response at start is fully-specified, but updates may be partial.
	//   - start and end: Returns the state of each ApplicationConfig at start, followed by updates
	//     until end.
	//   - Each ApplicationConfig response at start is fully-specified, but updates until end may
	//     be partial.
	//
	// This field is not allowed in the Subscribe RPC.
	Time *time.TimeBounds `protobuf:"bytes,3,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *ApplicationConfigStreamRequest) Reset() {
	*x = ApplicationConfigStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationConfigStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationConfigStreamRequest) ProtoMessage() {}

func (x *ApplicationConfigStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationConfigStreamRequest.ProtoReflect.Descriptor instead.
func (*ApplicationConfigStreamRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{5}
}

func (x *ApplicationConfigStreamRequest) GetPartialEqFilter() []*ApplicationConfig {
	if x != nil {
		return x.PartialEqFilter
	}
	return nil
}

func (x *ApplicationConfigStreamRequest) GetTime() *time.TimeBounds {
	if x != nil {
		return x.Time
	}
	return nil
}

type ApplicationConfigStreamResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Value is a value deemed relevant to the initiating request.
	// This structure will always have its key-field populated. Which other fields are
	// populated, and why, depends on the value of Operation and what triggered this notification.
	Value *ApplicationConfig `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Time holds the timestamp of this ApplicationConfig's last modification.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
	// Operation indicates how the ApplicationConfig value in this response should be considered.
	// Under non-subscribe requests, this value should always be INITIAL. In a subscription,
	// once all initial data is streamed and the client begins to receive modification updates,
	// you should not see INITIAL again.
	Type subscriptions.Operation `protobuf:"varint,3,opt,name=type,proto3,enum=arista.subscriptions.Operation" json:"type,omitempty"`
}

func (x *ApplicationConfigStreamResponse) Reset() {
	*x = ApplicationConfigStreamResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationConfigStreamResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationConfigStreamResponse) ProtoMessage() {}

func (x *ApplicationConfigStreamResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationConfigStreamResponse.ProtoReflect.Descriptor instead.
func (*ApplicationConfigStreamResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{6}
}

func (x *ApplicationConfigStreamResponse) GetValue() *ApplicationConfig {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *ApplicationConfigStreamResponse) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

func (x *ApplicationConfigStreamResponse) GetType() subscriptions.Operation {
	if x != nil {
		return x.Type
	}
	return subscriptions.Operation(0)
}

type ApplicationConfigSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ApplicationConfig carries the value to set into the datastore.
	// See the documentation on the ApplicationConfig struct for which fields are required.
	Value *ApplicationConfig `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *ApplicationConfigSetRequest) Reset() {
	*x = ApplicationConfigSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationConfigSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationConfigSetRequest) ProtoMessage() {}

func (x *ApplicationConfigSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationConfigSetRequest.ProtoReflect.Descriptor instead.
func (*ApplicationConfigSetRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{7}
}

func (x *ApplicationConfigSetRequest) GetValue() *ApplicationConfig {
	if x != nil {
		return x.Value
	}
	return nil
}

type ApplicationConfigSetResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Value carries all the values given in the ApplicationConfigSetRequest as well
	// as any server-generated values.
	Value *ApplicationConfig `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Time indicates the (UTC) timestamp at which the system recognizes the
	// creation. The only guarantees made about this timestamp are:
	//
	//   - it is after the time the request was received
	//   - a time-ranged query with StartTime==CreatedAt will include this instance.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *ApplicationConfigSetResponse) Reset() {
	*x = ApplicationConfigSetResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationConfigSetResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationConfigSetResponse) ProtoMessage() {}

func (x *ApplicationConfigSetResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationConfigSetResponse.ProtoReflect.Descriptor instead.
func (*ApplicationConfigSetResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{8}
}

func (x *ApplicationConfigSetResponse) GetValue() *ApplicationConfig {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *ApplicationConfigSetResponse) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type ApplicationConfigSetSomeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// value contains a list of ApplicationConfig values to write.
	// It is possible to provide more values than can fit within either:
	//   - the maxiumum send size of the client
	//   - the maximum receive size of the server
	//
	// If this error occurs you must reduce the number of values sent.
	// See gRPC "maximum message size" documentation for more information.
	Values []*ApplicationConfig `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *ApplicationConfigSetSomeRequest) Reset() {
	*x = ApplicationConfigSetSomeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationConfigSetSomeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationConfigSetSomeRequest) ProtoMessage() {}

func (x *ApplicationConfigSetSomeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationConfigSetSomeRequest.ProtoReflect.Descriptor instead.
func (*ApplicationConfigSetSomeRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{9}
}

func (x *ApplicationConfigSetSomeRequest) GetValues() []*ApplicationConfig {
	if x != nil {
		return x.Values
	}
	return nil
}

type ApplicationConfigSetSomeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key   *ApplicationKey `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Error string          `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *ApplicationConfigSetSomeResponse) Reset() {
	*x = ApplicationConfigSetSomeResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationConfigSetSomeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationConfigSetSomeResponse) ProtoMessage() {}

func (x *ApplicationConfigSetSomeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationConfigSetSomeResponse.ProtoReflect.Descriptor instead.
func (*ApplicationConfigSetSomeResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{10}
}

func (x *ApplicationConfigSetSomeResponse) GetKey() *ApplicationKey {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *ApplicationConfigSetSomeResponse) GetError() string {
	if x != nil {
		return x.Error
	}
	return ""
}

type ApplicationConfigDeleteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Key indicates which ApplicationConfig instance to remove.
	// This field must always be set.
	Key *ApplicationKey `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
}

func (x *ApplicationConfigDeleteRequest) Reset() {
	*x = ApplicationConfigDeleteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationConfigDeleteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationConfigDeleteRequest) ProtoMessage() {}

func (x *ApplicationConfigDeleteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationConfigDeleteRequest.ProtoReflect.Descriptor instead.
func (*ApplicationConfigDeleteRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{11}
}

func (x *ApplicationConfigDeleteRequest) GetKey() *ApplicationKey {
	if x != nil {
		return x.Key
	}
	return nil
}

type ApplicationConfigDeleteResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Key echoes back the key of the deleted ApplicationConfig instance.
	Key *ApplicationKey `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Time indicates the (UTC) timestamp at which the system recognizes the
	// deletion. The only guarantees made about this timestamp are:
	//
	//   - it is after the time the request was received
	//   - a time-ranged query with StartTime==DeletedAt will not include this instance.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *ApplicationConfigDeleteResponse) Reset() {
	*x = ApplicationConfigDeleteResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationConfigDeleteResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationConfigDeleteResponse) ProtoMessage() {}

func (x *ApplicationConfigDeleteResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationConfigDeleteResponse.ProtoReflect.Descriptor instead.
func (*ApplicationConfigDeleteResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{12}
}

func (x *ApplicationConfigDeleteResponse) GetKey() *ApplicationKey {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *ApplicationConfigDeleteResponse) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type ApplicationConfigDeleteSomeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// key contains a list of ApplicationConfig keys to delete
	Keys []*ApplicationKey `protobuf:"bytes,1,rep,name=keys,proto3" json:"keys,omitempty"`
}

func (x *ApplicationConfigDeleteSomeRequest) Reset() {
	*x = ApplicationConfigDeleteSomeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationConfigDeleteSomeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationConfigDeleteSomeRequest) ProtoMessage() {}

func (x *ApplicationConfigDeleteSomeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationConfigDeleteSomeRequest.ProtoReflect.Descriptor instead.
func (*ApplicationConfigDeleteSomeRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{13}
}

func (x *ApplicationConfigDeleteSomeRequest) GetKeys() []*ApplicationKey {
	if x != nil {
		return x.Keys
	}
	return nil
}

// ApplicationConfigDeleteSomeResponse is only sent when there is an error.
type ApplicationConfigDeleteSomeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key   *ApplicationKey `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Error string          `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *ApplicationConfigDeleteSomeResponse) Reset() {
	*x = ApplicationConfigDeleteSomeResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationConfigDeleteSomeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationConfigDeleteSomeResponse) ProtoMessage() {}

func (x *ApplicationConfigDeleteSomeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationConfigDeleteSomeResponse.ProtoReflect.Descriptor instead.
func (*ApplicationConfigDeleteSomeResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{14}
}

func (x *ApplicationConfigDeleteSomeResponse) GetKey() *ApplicationKey {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *ApplicationConfigDeleteSomeResponse) GetError() string {
	if x != nil {
		return x.Error
	}
	return ""
}

type ApplicationConfigDeleteAllRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ApplicationConfigDeleteAllRequest) Reset() {
	*x = ApplicationConfigDeleteAllRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationConfigDeleteAllRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationConfigDeleteAllRequest) ProtoMessage() {}

func (x *ApplicationConfigDeleteAllRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationConfigDeleteAllRequest.ProtoReflect.Descriptor instead.
func (*ApplicationConfigDeleteAllRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{15}
}

type ApplicationConfigDeleteAllResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This describes the class of delete error.
	Type fmp.DeleteError `protobuf:"varint,1,opt,name=type,proto3,enum=fmp.DeleteError" json:"type,omitempty"`
	// This indicates the error message from the delete failure.
	Error *wrapperspb.StringValue `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	// This is the key of the ApplicationConfig instance that failed to be deleted.
	Key *ApplicationKey `protobuf:"bytes,3,opt,name=key,proto3" json:"key,omitempty"`
	// Time indicates the (UTC) timestamp when the key was being deleted.
	Time *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *ApplicationConfigDeleteAllResponse) Reset() {
	*x = ApplicationConfigDeleteAllResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationConfigDeleteAllResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationConfigDeleteAllResponse) ProtoMessage() {}

func (x *ApplicationConfigDeleteAllResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationConfigDeleteAllResponse.ProtoReflect.Descriptor instead.
func (*ApplicationConfigDeleteAllResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{16}
}

func (x *ApplicationConfigDeleteAllResponse) GetType() fmp.DeleteError {
	if x != nil {
		return x.Type
	}
	return fmp.DeleteError(0)
}

func (x *ApplicationConfigDeleteAllResponse) GetError() *wrapperspb.StringValue {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *ApplicationConfigDeleteAllResponse) GetKey() *ApplicationKey {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *ApplicationConfigDeleteAllResponse) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type DefaultActionConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Time indicates the time for which you are interested in the data.
	// If no time is given, the server will use the time at which it makes the request.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *DefaultActionConfigRequest) Reset() {
	*x = DefaultActionConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DefaultActionConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DefaultActionConfigRequest) ProtoMessage() {}

func (x *DefaultActionConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DefaultActionConfigRequest.ProtoReflect.Descriptor instead.
func (*DefaultActionConfigRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{17}
}

func (x *DefaultActionConfigRequest) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type DefaultActionConfigResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Value is the value requested.
	// This structure will be fully-populated as it exists in the datastore. If
	// optional fields were not given at creation, these fields will be empty or
	// set to default values.
	Value *DefaultActionConfig `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Time carries the (UTC) timestamp of the last-modification of the
	// DefaultActionConfig instance in this response.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *DefaultActionConfigResponse) Reset() {
	*x = DefaultActionConfigResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DefaultActionConfigResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DefaultActionConfigResponse) ProtoMessage() {}

func (x *DefaultActionConfigResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DefaultActionConfigResponse.ProtoReflect.Descriptor instead.
func (*DefaultActionConfigResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{18}
}

func (x *DefaultActionConfigResponse) GetValue() *DefaultActionConfig {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *DefaultActionConfigResponse) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type DefaultActionConfigStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// PartialEqFilter provides a way to server-side filter a GetAll/Subscribe.
	// This requires all provided fields to be equal to the response.
	//
	// While transparent to users, this field also allows services to optimize internal
	// subscriptions if filter(s) are sufficiently specific.
	PartialEqFilter []*DefaultActionConfig `protobuf:"bytes,1,rep,name=partial_eq_filter,json=partialEqFilter,proto3" json:"partial_eq_filter,omitempty"`
	// TimeRange allows limiting response data to within a specified time window.
	// If this field is populated, at least one of the two time fields are required.
	//
	// For GetAll, the fields start and end can be used as follows:
	//
	//   - end: Returns the state of each DefaultActionConfig at end.
	//   - Each DefaultActionConfig response is fully-specified (all fields set).
	//   - start: Returns the state of each DefaultActionConfig at start, followed by updates until now.
	//   - Each DefaultActionConfig response at start is fully-specified, but updates may be partial.
	//   - start and end: Returns the state of each DefaultActionConfig at start, followed by updates
	//     until end.
	//   - Each DefaultActionConfig response at start is fully-specified, but updates until end may
	//     be partial.
	//
	// This field is not allowed in the Subscribe RPC.
	Time *time.TimeBounds `protobuf:"bytes,3,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *DefaultActionConfigStreamRequest) Reset() {
	*x = DefaultActionConfigStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DefaultActionConfigStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DefaultActionConfigStreamRequest) ProtoMessage() {}

func (x *DefaultActionConfigStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DefaultActionConfigStreamRequest.ProtoReflect.Descriptor instead.
func (*DefaultActionConfigStreamRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{19}
}

func (x *DefaultActionConfigStreamRequest) GetPartialEqFilter() []*DefaultActionConfig {
	if x != nil {
		return x.PartialEqFilter
	}
	return nil
}

func (x *DefaultActionConfigStreamRequest) GetTime() *time.TimeBounds {
	if x != nil {
		return x.Time
	}
	return nil
}

type DefaultActionConfigStreamResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Value is a value deemed relevant to the initiating request.
	// This structure will always have its key-field populated. Which other fields are
	// populated, and why, depends on the value of Operation and what triggered this notification.
	Value *DefaultActionConfig `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Time holds the timestamp of this DefaultActionConfig's last modification.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
	// Operation indicates how the DefaultActionConfig value in this response should be considered.
	// Under non-subscribe requests, this value should always be INITIAL. In a subscription,
	// once all initial data is streamed and the client begins to receive modification updates,
	// you should not see INITIAL again.
	Type subscriptions.Operation `protobuf:"varint,3,opt,name=type,proto3,enum=arista.subscriptions.Operation" json:"type,omitempty"`
}

func (x *DefaultActionConfigStreamResponse) Reset() {
	*x = DefaultActionConfigStreamResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DefaultActionConfigStreamResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DefaultActionConfigStreamResponse) ProtoMessage() {}

func (x *DefaultActionConfigStreamResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DefaultActionConfigStreamResponse.ProtoReflect.Descriptor instead.
func (*DefaultActionConfigStreamResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{20}
}

func (x *DefaultActionConfigStreamResponse) GetValue() *DefaultActionConfig {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *DefaultActionConfigStreamResponse) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

func (x *DefaultActionConfigStreamResponse) GetType() subscriptions.Operation {
	if x != nil {
		return x.Type
	}
	return subscriptions.Operation(0)
}

type DefaultActionConfigSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// DefaultActionConfig carries the value to set into the datastore.
	// See the documentation on the DefaultActionConfig struct for which fields are required.
	Value *DefaultActionConfig `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *DefaultActionConfigSetRequest) Reset() {
	*x = DefaultActionConfigSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DefaultActionConfigSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DefaultActionConfigSetRequest) ProtoMessage() {}

func (x *DefaultActionConfigSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DefaultActionConfigSetRequest.ProtoReflect.Descriptor instead.
func (*DefaultActionConfigSetRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{21}
}

func (x *DefaultActionConfigSetRequest) GetValue() *DefaultActionConfig {
	if x != nil {
		return x.Value
	}
	return nil
}

type DefaultActionConfigSetResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Value carries all the values given in the DefaultActionConfigSetRequest as well
	// as any server-generated values.
	Value *DefaultActionConfig `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Time indicates the (UTC) timestamp at which the system recognizes the
	// creation. The only guarantees made about this timestamp are:
	//
	//   - it is after the time the request was received
	//   - a time-ranged query with StartTime==CreatedAt will include this instance.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *DefaultActionConfigSetResponse) Reset() {
	*x = DefaultActionConfigSetResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DefaultActionConfigSetResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DefaultActionConfigSetResponse) ProtoMessage() {}

func (x *DefaultActionConfigSetResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DefaultActionConfigSetResponse.ProtoReflect.Descriptor instead.
func (*DefaultActionConfigSetResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{22}
}

func (x *DefaultActionConfigSetResponse) GetValue() *DefaultActionConfig {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *DefaultActionConfigSetResponse) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type DomainSegmentPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Key uniquely identifies a DomainSegmentPolicy instance to retrieve.
	// This value must be populated.
	Key *DomainSegmentPolicyKey `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Time indicates the time for which you are interested in the data.
	// If no time is given, the server will use the time at which it makes the request.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *DomainSegmentPolicyRequest) Reset() {
	*x = DomainSegmentPolicyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainSegmentPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainSegmentPolicyRequest) ProtoMessage() {}

func (x *DomainSegmentPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainSegmentPolicyRequest.ProtoReflect.Descriptor instead.
func (*DomainSegmentPolicyRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{23}
}

func (x *DomainSegmentPolicyRequest) GetKey() *DomainSegmentPolicyKey {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *DomainSegmentPolicyRequest) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type DomainSegmentPolicyResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Value is the value requested.
	// This structure will be fully-populated as it exists in the datastore. If
	// optional fields were not given at creation, these fields will be empty or
	// set to default values.
	Value *DomainSegmentPolicy `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Time carries the (UTC) timestamp of the last-modification of the
	// DomainSegmentPolicy instance in this response.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *DomainSegmentPolicyResponse) Reset() {
	*x = DomainSegmentPolicyResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainSegmentPolicyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainSegmentPolicyResponse) ProtoMessage() {}

func (x *DomainSegmentPolicyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainSegmentPolicyResponse.ProtoReflect.Descriptor instead.
func (*DomainSegmentPolicyResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{24}
}

func (x *DomainSegmentPolicyResponse) GetValue() *DomainSegmentPolicy {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *DomainSegmentPolicyResponse) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type DomainSegmentPolicySomeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Keys []*DomainSegmentPolicyKey `protobuf:"bytes,1,rep,name=keys,proto3" json:"keys,omitempty"`
	// Time indicates the time for which you are interested in the data.
	// If no time is given, the server will use the time at which it makes the request.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *DomainSegmentPolicySomeRequest) Reset() {
	*x = DomainSegmentPolicySomeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainSegmentPolicySomeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainSegmentPolicySomeRequest) ProtoMessage() {}

func (x *DomainSegmentPolicySomeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainSegmentPolicySomeRequest.ProtoReflect.Descriptor instead.
func (*DomainSegmentPolicySomeRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{25}
}

func (x *DomainSegmentPolicySomeRequest) GetKeys() []*DomainSegmentPolicyKey {
	if x != nil {
		return x.Keys
	}
	return nil
}

func (x *DomainSegmentPolicySomeRequest) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type DomainSegmentPolicySomeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Value is the value requested.
	// This structure will be fully-populated as it exists in the datastore. If
	// optional fields were not given at creation, these fields will be empty or
	// set to default values.
	Value *DomainSegmentPolicy `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Error is an optional field.
	// It should be filled when there is an error in the GetSome process.
	Error *wrapperspb.StringValue `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	Time  *timestamppb.Timestamp  `protobuf:"bytes,3,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *DomainSegmentPolicySomeResponse) Reset() {
	*x = DomainSegmentPolicySomeResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainSegmentPolicySomeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainSegmentPolicySomeResponse) ProtoMessage() {}

func (x *DomainSegmentPolicySomeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainSegmentPolicySomeResponse.ProtoReflect.Descriptor instead.
func (*DomainSegmentPolicySomeResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{26}
}

func (x *DomainSegmentPolicySomeResponse) GetValue() *DomainSegmentPolicy {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *DomainSegmentPolicySomeResponse) GetError() *wrapperspb.StringValue {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *DomainSegmentPolicySomeResponse) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type DomainSegmentPolicyStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// PartialEqFilter provides a way to server-side filter a GetAll/Subscribe.
	// This requires all provided fields to be equal to the response.
	//
	// While transparent to users, this field also allows services to optimize internal
	// subscriptions if filter(s) are sufficiently specific.
	PartialEqFilter []*DomainSegmentPolicy `protobuf:"bytes,1,rep,name=partial_eq_filter,json=partialEqFilter,proto3" json:"partial_eq_filter,omitempty"`
	// TimeRange allows limiting response data to within a specified time window.
	// If this field is populated, at least one of the two time fields are required.
	//
	// For GetAll, the fields start and end can be used as follows:
	//
	//   - end: Returns the state of each DomainSegmentPolicy at end.
	//   - Each DomainSegmentPolicy response is fully-specified (all fields set).
	//   - start: Returns the state of each DomainSegmentPolicy at start, followed by updates until now.
	//   - Each DomainSegmentPolicy response at start is fully-specified, but updates may be partial.
	//   - start and end: Returns the state of each DomainSegmentPolicy at start, followed by updates
	//     until end.
	//   - Each DomainSegmentPolicy response at start is fully-specified, but updates until end may
	//     be partial.
	//
	// This field is not allowed in the Subscribe RPC.
	Time *time.TimeBounds `protobuf:"bytes,3,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *DomainSegmentPolicyStreamRequest) Reset() {
	*x = DomainSegmentPolicyStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainSegmentPolicyStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainSegmentPolicyStreamRequest) ProtoMessage() {}

func (x *DomainSegmentPolicyStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainSegmentPolicyStreamRequest.ProtoReflect.Descriptor instead.
func (*DomainSegmentPolicyStreamRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{27}
}

func (x *DomainSegmentPolicyStreamRequest) GetPartialEqFilter() []*DomainSegmentPolicy {
	if x != nil {
		return x.PartialEqFilter
	}
	return nil
}

func (x *DomainSegmentPolicyStreamRequest) GetTime() *time.TimeBounds {
	if x != nil {
		return x.Time
	}
	return nil
}

type DomainSegmentPolicyStreamResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Value is a value deemed relevant to the initiating request.
	// This structure will always have its key-field populated. Which other fields are
	// populated, and why, depends on the value of Operation and what triggered this notification.
	Value *DomainSegmentPolicy `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Time holds the timestamp of this DomainSegmentPolicy's last modification.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
	// Operation indicates how the DomainSegmentPolicy value in this response should be considered.
	// Under non-subscribe requests, this value should always be INITIAL. In a subscription,
	// once all initial data is streamed and the client begins to receive modification updates,
	// you should not see INITIAL again.
	Type subscriptions.Operation `protobuf:"varint,3,opt,name=type,proto3,enum=arista.subscriptions.Operation" json:"type,omitempty"`
}

func (x *DomainSegmentPolicyStreamResponse) Reset() {
	*x = DomainSegmentPolicyStreamResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainSegmentPolicyStreamResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainSegmentPolicyStreamResponse) ProtoMessage() {}

func (x *DomainSegmentPolicyStreamResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainSegmentPolicyStreamResponse.ProtoReflect.Descriptor instead.
func (*DomainSegmentPolicyStreamResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{28}
}

func (x *DomainSegmentPolicyStreamResponse) GetValue() *DomainSegmentPolicy {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *DomainSegmentPolicyStreamResponse) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

func (x *DomainSegmentPolicyStreamResponse) GetType() subscriptions.Operation {
	if x != nil {
		return x.Type
	}
	return subscriptions.Operation(0)
}

type DomainRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Key uniquely identifies a Domain instance to retrieve.
	// This value must be populated.
	Key *DomainKey `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Time indicates the time for which you are interested in the data.
	// If no time is given, the server will use the time at which it makes the request.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *DomainRequest) Reset() {
	*x = DomainRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainRequest) ProtoMessage() {}

func (x *DomainRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainRequest.ProtoReflect.Descriptor instead.
func (*DomainRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{29}
}

func (x *DomainRequest) GetKey() *DomainKey {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *DomainRequest) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type DomainResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Value is the value requested.
	// This structure will be fully-populated as it exists in the datastore. If
	// optional fields were not given at creation, these fields will be empty or
	// set to default values.
	Value *Domain `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Time carries the (UTC) timestamp of the last-modification of the
	// Domain instance in this response.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *DomainResponse) Reset() {
	*x = DomainResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainResponse) ProtoMessage() {}

func (x *DomainResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainResponse.ProtoReflect.Descriptor instead.
func (*DomainResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{30}
}

func (x *DomainResponse) GetValue() *Domain {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *DomainResponse) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type DomainSomeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Keys []*DomainKey `protobuf:"bytes,1,rep,name=keys,proto3" json:"keys,omitempty"`
	// Time indicates the time for which you are interested in the data.
	// If no time is given, the server will use the time at which it makes the request.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *DomainSomeRequest) Reset() {
	*x = DomainSomeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainSomeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainSomeRequest) ProtoMessage() {}

func (x *DomainSomeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainSomeRequest.ProtoReflect.Descriptor instead.
func (*DomainSomeRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{31}
}

func (x *DomainSomeRequest) GetKeys() []*DomainKey {
	if x != nil {
		return x.Keys
	}
	return nil
}

func (x *DomainSomeRequest) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type DomainSomeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Value is the value requested.
	// This structure will be fully-populated as it exists in the datastore. If
	// optional fields were not given at creation, these fields will be empty or
	// set to default values.
	Value *Domain `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Error is an optional field.
	// It should be filled when there is an error in the GetSome process.
	Error *wrapperspb.StringValue `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	Time  *timestamppb.Timestamp  `protobuf:"bytes,3,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *DomainSomeResponse) Reset() {
	*x = DomainSomeResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainSomeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainSomeResponse) ProtoMessage() {}

func (x *DomainSomeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainSomeResponse.ProtoReflect.Descriptor instead.
func (*DomainSomeResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{32}
}

func (x *DomainSomeResponse) GetValue() *Domain {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *DomainSomeResponse) GetError() *wrapperspb.StringValue {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *DomainSomeResponse) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type DomainStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// PartialEqFilter provides a way to server-side filter a GetAll/Subscribe.
	// This requires all provided fields to be equal to the response.
	//
	// While transparent to users, this field also allows services to optimize internal
	// subscriptions if filter(s) are sufficiently specific.
	PartialEqFilter []*Domain `protobuf:"bytes,1,rep,name=partial_eq_filter,json=partialEqFilter,proto3" json:"partial_eq_filter,omitempty"`
	// TimeRange allows limiting response data to within a specified time window.
	// If this field is populated, at least one of the two time fields are required.
	//
	// For GetAll, the fields start and end can be used as follows:
	//
	//   - end: Returns the state of each Domain at end.
	//   - Each Domain response is fully-specified (all fields set).
	//   - start: Returns the state of each Domain at start, followed by updates until now.
	//   - Each Domain response at start is fully-specified, but updates may be partial.
	//   - start and end: Returns the state of each Domain at start, followed by updates
	//     until end.
	//   - Each Domain response at start is fully-specified, but updates until end may
	//     be partial.
	//
	// This field is not allowed in the Subscribe RPC.
	Time *time.TimeBounds `protobuf:"bytes,3,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *DomainStreamRequest) Reset() {
	*x = DomainStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainStreamRequest) ProtoMessage() {}

func (x *DomainStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainStreamRequest.ProtoReflect.Descriptor instead.
func (*DomainStreamRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{33}
}

func (x *DomainStreamRequest) GetPartialEqFilter() []*Domain {
	if x != nil {
		return x.PartialEqFilter
	}
	return nil
}

func (x *DomainStreamRequest) GetTime() *time.TimeBounds {
	if x != nil {
		return x.Time
	}
	return nil
}

type DomainStreamResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Value is a value deemed relevant to the initiating request.
	// This structure will always have its key-field populated. Which other fields are
	// populated, and why, depends on the value of Operation and what triggered this notification.
	Value *Domain `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Time holds the timestamp of this Domain's last modification.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
	// Operation indicates how the Domain value in this response should be considered.
	// Under non-subscribe requests, this value should always be INITIAL. In a subscription,
	// once all initial data is streamed and the client begins to receive modification updates,
	// you should not see INITIAL again.
	Type subscriptions.Operation `protobuf:"varint,3,opt,name=type,proto3,enum=arista.subscriptions.Operation" json:"type,omitempty"`
}

func (x *DomainStreamResponse) Reset() {
	*x = DomainStreamResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainStreamResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainStreamResponse) ProtoMessage() {}

func (x *DomainStreamResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainStreamResponse.ProtoReflect.Descriptor instead.
func (*DomainStreamResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{34}
}

func (x *DomainStreamResponse) GetValue() *Domain {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *DomainStreamResponse) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

func (x *DomainStreamResponse) GetType() subscriptions.Operation {
	if x != nil {
		return x.Type
	}
	return subscriptions.Operation(0)
}

type DomainIPPrefixConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Key uniquely identifies a DomainIPPrefixConfig instance to retrieve.
	// This value must be populated.
	Key *DomainIPPrefixKey `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Time indicates the time for which you are interested in the data.
	// If no time is given, the server will use the time at which it makes the request.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *DomainIPPrefixConfigRequest) Reset() {
	*x = DomainIPPrefixConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainIPPrefixConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainIPPrefixConfigRequest) ProtoMessage() {}

func (x *DomainIPPrefixConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainIPPrefixConfigRequest.ProtoReflect.Descriptor instead.
func (*DomainIPPrefixConfigRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{35}
}

func (x *DomainIPPrefixConfigRequest) GetKey() *DomainIPPrefixKey {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *DomainIPPrefixConfigRequest) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type DomainIPPrefixConfigResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Value is the value requested.
	// This structure will be fully-populated as it exists in the datastore. If
	// optional fields were not given at creation, these fields will be empty or
	// set to default values.
	Value *DomainIPPrefixConfig `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Time carries the (UTC) timestamp of the last-modification of the
	// DomainIPPrefixConfig instance in this response.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *DomainIPPrefixConfigResponse) Reset() {
	*x = DomainIPPrefixConfigResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainIPPrefixConfigResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainIPPrefixConfigResponse) ProtoMessage() {}

func (x *DomainIPPrefixConfigResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainIPPrefixConfigResponse.ProtoReflect.Descriptor instead.
func (*DomainIPPrefixConfigResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{36}
}

func (x *DomainIPPrefixConfigResponse) GetValue() *DomainIPPrefixConfig {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *DomainIPPrefixConfigResponse) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type DomainIPPrefixConfigSomeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Keys []*DomainIPPrefixKey `protobuf:"bytes,1,rep,name=keys,proto3" json:"keys,omitempty"`
	// Time indicates the time for which you are interested in the data.
	// If no time is given, the server will use the time at which it makes the request.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *DomainIPPrefixConfigSomeRequest) Reset() {
	*x = DomainIPPrefixConfigSomeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainIPPrefixConfigSomeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainIPPrefixConfigSomeRequest) ProtoMessage() {}

func (x *DomainIPPrefixConfigSomeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainIPPrefixConfigSomeRequest.ProtoReflect.Descriptor instead.
func (*DomainIPPrefixConfigSomeRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{37}
}

func (x *DomainIPPrefixConfigSomeRequest) GetKeys() []*DomainIPPrefixKey {
	if x != nil {
		return x.Keys
	}
	return nil
}

func (x *DomainIPPrefixConfigSomeRequest) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type DomainIPPrefixConfigSomeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Value is the value requested.
	// This structure will be fully-populated as it exists in the datastore. If
	// optional fields were not given at creation, these fields will be empty or
	// set to default values.
	Value *DomainIPPrefixConfig `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Error is an optional field.
	// It should be filled when there is an error in the GetSome process.
	Error *wrapperspb.StringValue `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	Time  *timestamppb.Timestamp  `protobuf:"bytes,3,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *DomainIPPrefixConfigSomeResponse) Reset() {
	*x = DomainIPPrefixConfigSomeResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainIPPrefixConfigSomeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainIPPrefixConfigSomeResponse) ProtoMessage() {}

func (x *DomainIPPrefixConfigSomeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainIPPrefixConfigSomeResponse.ProtoReflect.Descriptor instead.
func (*DomainIPPrefixConfigSomeResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{38}
}

func (x *DomainIPPrefixConfigSomeResponse) GetValue() *DomainIPPrefixConfig {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *DomainIPPrefixConfigSomeResponse) GetError() *wrapperspb.StringValue {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *DomainIPPrefixConfigSomeResponse) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type DomainIPPrefixConfigStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// PartialEqFilter provides a way to server-side filter a GetAll/Subscribe.
	// This requires all provided fields to be equal to the response.
	//
	// While transparent to users, this field also allows services to optimize internal
	// subscriptions if filter(s) are sufficiently specific.
	PartialEqFilter []*DomainIPPrefixConfig `protobuf:"bytes,1,rep,name=partial_eq_filter,json=partialEqFilter,proto3" json:"partial_eq_filter,omitempty"`
	// TimeRange allows limiting response data to within a specified time window.
	// If this field is populated, at least one of the two time fields are required.
	//
	// For GetAll, the fields start and end can be used as follows:
	//
	//   - end: Returns the state of each DomainIPPrefixConfig at end.
	//   - Each DomainIPPrefixConfig response is fully-specified (all fields set).
	//   - start: Returns the state of each DomainIPPrefixConfig at start, followed by updates until now.
	//   - Each DomainIPPrefixConfig response at start is fully-specified, but updates may be partial.
	//   - start and end: Returns the state of each DomainIPPrefixConfig at start, followed by updates
	//     until end.
	//   - Each DomainIPPrefixConfig response at start is fully-specified, but updates until end may
	//     be partial.
	//
	// This field is not allowed in the Subscribe RPC.
	Time *time.TimeBounds `protobuf:"bytes,3,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *DomainIPPrefixConfigStreamRequest) Reset() {
	*x = DomainIPPrefixConfigStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainIPPrefixConfigStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainIPPrefixConfigStreamRequest) ProtoMessage() {}

func (x *DomainIPPrefixConfigStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainIPPrefixConfigStreamRequest.ProtoReflect.Descriptor instead.
func (*DomainIPPrefixConfigStreamRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{39}
}

func (x *DomainIPPrefixConfigStreamRequest) GetPartialEqFilter() []*DomainIPPrefixConfig {
	if x != nil {
		return x.PartialEqFilter
	}
	return nil
}

func (x *DomainIPPrefixConfigStreamRequest) GetTime() *time.TimeBounds {
	if x != nil {
		return x.Time
	}
	return nil
}

type DomainIPPrefixConfigStreamResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Value is a value deemed relevant to the initiating request.
	// This structure will always have its key-field populated. Which other fields are
	// populated, and why, depends on the value of Operation and what triggered this notification.
	Value *DomainIPPrefixConfig `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Time holds the timestamp of this DomainIPPrefixConfig's last modification.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
	// Operation indicates how the DomainIPPrefixConfig value in this response should be considered.
	// Under non-subscribe requests, this value should always be INITIAL. In a subscription,
	// once all initial data is streamed and the client begins to receive modification updates,
	// you should not see INITIAL again.
	Type subscriptions.Operation `protobuf:"varint,3,opt,name=type,proto3,enum=arista.subscriptions.Operation" json:"type,omitempty"`
}

func (x *DomainIPPrefixConfigStreamResponse) Reset() {
	*x = DomainIPPrefixConfigStreamResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainIPPrefixConfigStreamResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainIPPrefixConfigStreamResponse) ProtoMessage() {}

func (x *DomainIPPrefixConfigStreamResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainIPPrefixConfigStreamResponse.ProtoReflect.Descriptor instead.
func (*DomainIPPrefixConfigStreamResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{40}
}

func (x *DomainIPPrefixConfigStreamResponse) GetValue() *DomainIPPrefixConfig {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *DomainIPPrefixConfigStreamResponse) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

func (x *DomainIPPrefixConfigStreamResponse) GetType() subscriptions.Operation {
	if x != nil {
		return x.Type
	}
	return subscriptions.Operation(0)
}

type DomainIPPrefixConfigSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// DomainIPPrefixConfig carries the value to set into the datastore.
	// See the documentation on the DomainIPPrefixConfig struct for which fields are required.
	Value *DomainIPPrefixConfig `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *DomainIPPrefixConfigSetRequest) Reset() {
	*x = DomainIPPrefixConfigSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainIPPrefixConfigSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainIPPrefixConfigSetRequest) ProtoMessage() {}

func (x *DomainIPPrefixConfigSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainIPPrefixConfigSetRequest.ProtoReflect.Descriptor instead.
func (*DomainIPPrefixConfigSetRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{41}
}

func (x *DomainIPPrefixConfigSetRequest) GetValue() *DomainIPPrefixConfig {
	if x != nil {
		return x.Value
	}
	return nil
}

type DomainIPPrefixConfigSetResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Value carries all the values given in the DomainIPPrefixConfigSetRequest as well
	// as any server-generated values.
	Value *DomainIPPrefixConfig `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Time indicates the (UTC) timestamp at which the system recognizes the
	// creation. The only guarantees made about this timestamp are:
	//
	//   - it is after the time the request was received
	//   - a time-ranged query with StartTime==CreatedAt will include this instance.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *DomainIPPrefixConfigSetResponse) Reset() {
	*x = DomainIPPrefixConfigSetResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainIPPrefixConfigSetResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainIPPrefixConfigSetResponse) ProtoMessage() {}

func (x *DomainIPPrefixConfigSetResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainIPPrefixConfigSetResponse.ProtoReflect.Descriptor instead.
func (*DomainIPPrefixConfigSetResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{42}
}

func (x *DomainIPPrefixConfigSetResponse) GetValue() *DomainIPPrefixConfig {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *DomainIPPrefixConfigSetResponse) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type DomainIPPrefixConfigSetSomeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// value contains a list of DomainIPPrefixConfig values to write.
	// It is possible to provide more values than can fit within either:
	//   - the maxiumum send size of the client
	//   - the maximum receive size of the server
	//
	// If this error occurs you must reduce the number of values sent.
	// See gRPC "maximum message size" documentation for more information.
	Values []*DomainIPPrefixConfig `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *DomainIPPrefixConfigSetSomeRequest) Reset() {
	*x = DomainIPPrefixConfigSetSomeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainIPPrefixConfigSetSomeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainIPPrefixConfigSetSomeRequest) ProtoMessage() {}

func (x *DomainIPPrefixConfigSetSomeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainIPPrefixConfigSetSomeRequest.ProtoReflect.Descriptor instead.
func (*DomainIPPrefixConfigSetSomeRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{43}
}

func (x *DomainIPPrefixConfigSetSomeRequest) GetValues() []*DomainIPPrefixConfig {
	if x != nil {
		return x.Values
	}
	return nil
}

type DomainIPPrefixConfigSetSomeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key   *DomainIPPrefixKey `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Error string             `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *DomainIPPrefixConfigSetSomeResponse) Reset() {
	*x = DomainIPPrefixConfigSetSomeResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainIPPrefixConfigSetSomeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainIPPrefixConfigSetSomeResponse) ProtoMessage() {}

func (x *DomainIPPrefixConfigSetSomeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainIPPrefixConfigSetSomeResponse.ProtoReflect.Descriptor instead.
func (*DomainIPPrefixConfigSetSomeResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{44}
}

func (x *DomainIPPrefixConfigSetSomeResponse) GetKey() *DomainIPPrefixKey {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *DomainIPPrefixConfigSetSomeResponse) GetError() string {
	if x != nil {
		return x.Error
	}
	return ""
}

type DomainIPPrefixConfigDeleteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Key indicates which DomainIPPrefixConfig instance to remove.
	// This field must always be set.
	Key *DomainIPPrefixKey `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
}

func (x *DomainIPPrefixConfigDeleteRequest) Reset() {
	*x = DomainIPPrefixConfigDeleteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainIPPrefixConfigDeleteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainIPPrefixConfigDeleteRequest) ProtoMessage() {}

func (x *DomainIPPrefixConfigDeleteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainIPPrefixConfigDeleteRequest.ProtoReflect.Descriptor instead.
func (*DomainIPPrefixConfigDeleteRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{45}
}

func (x *DomainIPPrefixConfigDeleteRequest) GetKey() *DomainIPPrefixKey {
	if x != nil {
		return x.Key
	}
	return nil
}

type DomainIPPrefixConfigDeleteResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Key echoes back the key of the deleted DomainIPPrefixConfig instance.
	Key *DomainIPPrefixKey `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Time indicates the (UTC) timestamp at which the system recognizes the
	// deletion. The only guarantees made about this timestamp are:
	//
	//   - it is after the time the request was received
	//   - a time-ranged query with StartTime==DeletedAt will not include this instance.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *DomainIPPrefixConfigDeleteResponse) Reset() {
	*x = DomainIPPrefixConfigDeleteResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainIPPrefixConfigDeleteResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainIPPrefixConfigDeleteResponse) ProtoMessage() {}

func (x *DomainIPPrefixConfigDeleteResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainIPPrefixConfigDeleteResponse.ProtoReflect.Descriptor instead.
func (*DomainIPPrefixConfigDeleteResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{46}
}

func (x *DomainIPPrefixConfigDeleteResponse) GetKey() *DomainIPPrefixKey {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *DomainIPPrefixConfigDeleteResponse) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type DomainIPPrefixConfigDeleteSomeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// key contains a list of DomainIPPrefixConfig keys to delete
	Keys []*DomainIPPrefixKey `protobuf:"bytes,1,rep,name=keys,proto3" json:"keys,omitempty"`
}

func (x *DomainIPPrefixConfigDeleteSomeRequest) Reset() {
	*x = DomainIPPrefixConfigDeleteSomeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainIPPrefixConfigDeleteSomeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainIPPrefixConfigDeleteSomeRequest) ProtoMessage() {}

func (x *DomainIPPrefixConfigDeleteSomeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainIPPrefixConfigDeleteSomeRequest.ProtoReflect.Descriptor instead.
func (*DomainIPPrefixConfigDeleteSomeRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{47}
}

func (x *DomainIPPrefixConfigDeleteSomeRequest) GetKeys() []*DomainIPPrefixKey {
	if x != nil {
		return x.Keys
	}
	return nil
}

// DomainIPPrefixConfigDeleteSomeResponse is only sent when there is an error.
type DomainIPPrefixConfigDeleteSomeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key   *DomainIPPrefixKey `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Error string             `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *DomainIPPrefixConfigDeleteSomeResponse) Reset() {
	*x = DomainIPPrefixConfigDeleteSomeResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainIPPrefixConfigDeleteSomeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainIPPrefixConfigDeleteSomeResponse) ProtoMessage() {}

func (x *DomainIPPrefixConfigDeleteSomeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainIPPrefixConfigDeleteSomeResponse.ProtoReflect.Descriptor instead.
func (*DomainIPPrefixConfigDeleteSomeResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{48}
}

func (x *DomainIPPrefixConfigDeleteSomeResponse) GetKey() *DomainIPPrefixKey {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *DomainIPPrefixConfigDeleteSomeResponse) GetError() string {
	if x != nil {
		return x.Error
	}
	return ""
}

type DomainIPPrefixConfigDeleteAllRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DomainIPPrefixConfigDeleteAllRequest) Reset() {
	*x = DomainIPPrefixConfigDeleteAllRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainIPPrefixConfigDeleteAllRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainIPPrefixConfigDeleteAllRequest) ProtoMessage() {}

func (x *DomainIPPrefixConfigDeleteAllRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainIPPrefixConfigDeleteAllRequest.ProtoReflect.Descriptor instead.
func (*DomainIPPrefixConfigDeleteAllRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{49}
}

type DomainIPPrefixConfigDeleteAllResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This describes the class of delete error.
	Type fmp.DeleteError `protobuf:"varint,1,opt,name=type,proto3,enum=fmp.DeleteError" json:"type,omitempty"`
	// This indicates the error message from the delete failure.
	Error *wrapperspb.StringValue `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	// This is the key of the DomainIPPrefixConfig instance that failed to be deleted.
	Key *DomainIPPrefixKey `protobuf:"bytes,3,opt,name=key,proto3" json:"key,omitempty"`
	// Time indicates the (UTC) timestamp when the key was being deleted.
	Time *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *DomainIPPrefixConfigDeleteAllResponse) Reset() {
	*x = DomainIPPrefixConfigDeleteAllResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainIPPrefixConfigDeleteAllResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainIPPrefixConfigDeleteAllResponse) ProtoMessage() {}

func (x *DomainIPPrefixConfigDeleteAllResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainIPPrefixConfigDeleteAllResponse.ProtoReflect.Descriptor instead.
func (*DomainIPPrefixConfigDeleteAllResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{50}
}

func (x *DomainIPPrefixConfigDeleteAllResponse) GetType() fmp.DeleteError {
	if x != nil {
		return x.Type
	}
	return fmp.DeleteError(0)
}

func (x *DomainIPPrefixConfigDeleteAllResponse) GetError() *wrapperspb.StringValue {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *DomainIPPrefixConfigDeleteAllResponse) GetKey() *DomainIPPrefixKey {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *DomainIPPrefixConfigDeleteAllResponse) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type DomainSegmentConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Key uniquely identifies a DomainSegmentConfig instance to retrieve.
	// This value must be populated.
	Key *DomainSegmentKey `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Time indicates the time for which you are interested in the data.
	// If no time is given, the server will use the time at which it makes the request.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *DomainSegmentConfigRequest) Reset() {
	*x = DomainSegmentConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainSegmentConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainSegmentConfigRequest) ProtoMessage() {}

func (x *DomainSegmentConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainSegmentConfigRequest.ProtoReflect.Descriptor instead.
func (*DomainSegmentConfigRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{51}
}

func (x *DomainSegmentConfigRequest) GetKey() *DomainSegmentKey {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *DomainSegmentConfigRequest) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type DomainSegmentConfigResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Value is the value requested.
	// This structure will be fully-populated as it exists in the datastore. If
	// optional fields were not given at creation, these fields will be empty or
	// set to default values.
	Value *DomainSegmentConfig `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Time carries the (UTC) timestamp of the last-modification of the
	// DomainSegmentConfig instance in this response.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *DomainSegmentConfigResponse) Reset() {
	*x = DomainSegmentConfigResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainSegmentConfigResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainSegmentConfigResponse) ProtoMessage() {}

func (x *DomainSegmentConfigResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainSegmentConfigResponse.ProtoReflect.Descriptor instead.
func (*DomainSegmentConfigResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{52}
}

func (x *DomainSegmentConfigResponse) GetValue() *DomainSegmentConfig {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *DomainSegmentConfigResponse) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type DomainSegmentConfigSomeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Keys []*DomainSegmentKey `protobuf:"bytes,1,rep,name=keys,proto3" json:"keys,omitempty"`
	// Time indicates the time for which you are interested in the data.
	// If no time is given, the server will use the time at which it makes the request.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *DomainSegmentConfigSomeRequest) Reset() {
	*x = DomainSegmentConfigSomeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainSegmentConfigSomeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainSegmentConfigSomeRequest) ProtoMessage() {}

func (x *DomainSegmentConfigSomeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainSegmentConfigSomeRequest.ProtoReflect.Descriptor instead.
func (*DomainSegmentConfigSomeRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{53}
}

func (x *DomainSegmentConfigSomeRequest) GetKeys() []*DomainSegmentKey {
	if x != nil {
		return x.Keys
	}
	return nil
}

func (x *DomainSegmentConfigSomeRequest) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type DomainSegmentConfigSomeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Value is the value requested.
	// This structure will be fully-populated as it exists in the datastore. If
	// optional fields were not given at creation, these fields will be empty or
	// set to default values.
	Value *DomainSegmentConfig `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Error is an optional field.
	// It should be filled when there is an error in the GetSome process.
	Error *wrapperspb.StringValue `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	Time  *timestamppb.Timestamp  `protobuf:"bytes,3,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *DomainSegmentConfigSomeResponse) Reset() {
	*x = DomainSegmentConfigSomeResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainSegmentConfigSomeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainSegmentConfigSomeResponse) ProtoMessage() {}

func (x *DomainSegmentConfigSomeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainSegmentConfigSomeResponse.ProtoReflect.Descriptor instead.
func (*DomainSegmentConfigSomeResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{54}
}

func (x *DomainSegmentConfigSomeResponse) GetValue() *DomainSegmentConfig {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *DomainSegmentConfigSomeResponse) GetError() *wrapperspb.StringValue {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *DomainSegmentConfigSomeResponse) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type DomainSegmentConfigStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// PartialEqFilter provides a way to server-side filter a GetAll/Subscribe.
	// This requires all provided fields to be equal to the response.
	//
	// While transparent to users, this field also allows services to optimize internal
	// subscriptions if filter(s) are sufficiently specific.
	PartialEqFilter []*DomainSegmentConfig `protobuf:"bytes,1,rep,name=partial_eq_filter,json=partialEqFilter,proto3" json:"partial_eq_filter,omitempty"`
	// TimeRange allows limiting response data to within a specified time window.
	// If this field is populated, at least one of the two time fields are required.
	//
	// For GetAll, the fields start and end can be used as follows:
	//
	//   - end: Returns the state of each DomainSegmentConfig at end.
	//   - Each DomainSegmentConfig response is fully-specified (all fields set).
	//   - start: Returns the state of each DomainSegmentConfig at start, followed by updates until now.
	//   - Each DomainSegmentConfig response at start is fully-specified, but updates may be partial.
	//   - start and end: Returns the state of each DomainSegmentConfig at start, followed by updates
	//     until end.
	//   - Each DomainSegmentConfig response at start is fully-specified, but updates until end may
	//     be partial.
	//
	// This field is not allowed in the Subscribe RPC.
	Time *time.TimeBounds `protobuf:"bytes,3,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *DomainSegmentConfigStreamRequest) Reset() {
	*x = DomainSegmentConfigStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainSegmentConfigStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainSegmentConfigStreamRequest) ProtoMessage() {}

func (x *DomainSegmentConfigStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainSegmentConfigStreamRequest.ProtoReflect.Descriptor instead.
func (*DomainSegmentConfigStreamRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{55}
}

func (x *DomainSegmentConfigStreamRequest) GetPartialEqFilter() []*DomainSegmentConfig {
	if x != nil {
		return x.PartialEqFilter
	}
	return nil
}

func (x *DomainSegmentConfigStreamRequest) GetTime() *time.TimeBounds {
	if x != nil {
		return x.Time
	}
	return nil
}

type DomainSegmentConfigStreamResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Value is a value deemed relevant to the initiating request.
	// This structure will always have its key-field populated. Which other fields are
	// populated, and why, depends on the value of Operation and what triggered this notification.
	Value *DomainSegmentConfig `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Time holds the timestamp of this DomainSegmentConfig's last modification.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
	// Operation indicates how the DomainSegmentConfig value in this response should be considered.
	// Under non-subscribe requests, this value should always be INITIAL. In a subscription,
	// once all initial data is streamed and the client begins to receive modification updates,
	// you should not see INITIAL again.
	Type subscriptions.Operation `protobuf:"varint,3,opt,name=type,proto3,enum=arista.subscriptions.Operation" json:"type,omitempty"`
}

func (x *DomainSegmentConfigStreamResponse) Reset() {
	*x = DomainSegmentConfigStreamResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainSegmentConfigStreamResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainSegmentConfigStreamResponse) ProtoMessage() {}

func (x *DomainSegmentConfigStreamResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainSegmentConfigStreamResponse.ProtoReflect.Descriptor instead.
func (*DomainSegmentConfigStreamResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{56}
}

func (x *DomainSegmentConfigStreamResponse) GetValue() *DomainSegmentConfig {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *DomainSegmentConfigStreamResponse) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

func (x *DomainSegmentConfigStreamResponse) GetType() subscriptions.Operation {
	if x != nil {
		return x.Type
	}
	return subscriptions.Operation(0)
}

type DomainSegmentConfigSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// DomainSegmentConfig carries the value to set into the datastore.
	// See the documentation on the DomainSegmentConfig struct for which fields are required.
	Value *DomainSegmentConfig `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *DomainSegmentConfigSetRequest) Reset() {
	*x = DomainSegmentConfigSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[57]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainSegmentConfigSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainSegmentConfigSetRequest) ProtoMessage() {}

func (x *DomainSegmentConfigSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[57]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainSegmentConfigSetRequest.ProtoReflect.Descriptor instead.
func (*DomainSegmentConfigSetRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{57}
}

func (x *DomainSegmentConfigSetRequest) GetValue() *DomainSegmentConfig {
	if x != nil {
		return x.Value
	}
	return nil
}

type DomainSegmentConfigSetResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Value carries all the values given in the DomainSegmentConfigSetRequest as well
	// as any server-generated values.
	Value *DomainSegmentConfig `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Time indicates the (UTC) timestamp at which the system recognizes the
	// creation. The only guarantees made about this timestamp are:
	//
	//   - it is after the time the request was received
	//   - a time-ranged query with StartTime==CreatedAt will include this instance.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *DomainSegmentConfigSetResponse) Reset() {
	*x = DomainSegmentConfigSetResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[58]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainSegmentConfigSetResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainSegmentConfigSetResponse) ProtoMessage() {}

func (x *DomainSegmentConfigSetResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[58]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainSegmentConfigSetResponse.ProtoReflect.Descriptor instead.
func (*DomainSegmentConfigSetResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{58}
}

func (x *DomainSegmentConfigSetResponse) GetValue() *DomainSegmentConfig {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *DomainSegmentConfigSetResponse) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type DomainSegmentConfigSetSomeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// value contains a list of DomainSegmentConfig values to write.
	// It is possible to provide more values than can fit within either:
	//   - the maxiumum send size of the client
	//   - the maximum receive size of the server
	//
	// If this error occurs you must reduce the number of values sent.
	// See gRPC "maximum message size" documentation for more information.
	Values []*DomainSegmentConfig `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *DomainSegmentConfigSetSomeRequest) Reset() {
	*x = DomainSegmentConfigSetSomeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[59]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainSegmentConfigSetSomeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainSegmentConfigSetSomeRequest) ProtoMessage() {}

func (x *DomainSegmentConfigSetSomeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[59]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainSegmentConfigSetSomeRequest.ProtoReflect.Descriptor instead.
func (*DomainSegmentConfigSetSomeRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{59}
}

func (x *DomainSegmentConfigSetSomeRequest) GetValues() []*DomainSegmentConfig {
	if x != nil {
		return x.Values
	}
	return nil
}

type DomainSegmentConfigSetSomeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key   *DomainSegmentKey `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Error string            `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *DomainSegmentConfigSetSomeResponse) Reset() {
	*x = DomainSegmentConfigSetSomeResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[60]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainSegmentConfigSetSomeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainSegmentConfigSetSomeResponse) ProtoMessage() {}

func (x *DomainSegmentConfigSetSomeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[60]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainSegmentConfigSetSomeResponse.ProtoReflect.Descriptor instead.
func (*DomainSegmentConfigSetSomeResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{60}
}

func (x *DomainSegmentConfigSetSomeResponse) GetKey() *DomainSegmentKey {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *DomainSegmentConfigSetSomeResponse) GetError() string {
	if x != nil {
		return x.Error
	}
	return ""
}

type DomainSegmentConfigDeleteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Key indicates which DomainSegmentConfig instance to remove.
	// This field must always be set.
	Key *DomainSegmentKey `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
}

func (x *DomainSegmentConfigDeleteRequest) Reset() {
	*x = DomainSegmentConfigDeleteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[61]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainSegmentConfigDeleteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainSegmentConfigDeleteRequest) ProtoMessage() {}

func (x *DomainSegmentConfigDeleteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[61]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainSegmentConfigDeleteRequest.ProtoReflect.Descriptor instead.
func (*DomainSegmentConfigDeleteRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{61}
}

func (x *DomainSegmentConfigDeleteRequest) GetKey() *DomainSegmentKey {
	if x != nil {
		return x.Key
	}
	return nil
}

type DomainSegmentConfigDeleteResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Key echoes back the key of the deleted DomainSegmentConfig instance.
	Key *DomainSegmentKey `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Time indicates the (UTC) timestamp at which the system recognizes the
	// deletion. The only guarantees made about this timestamp are:
	//
	//   - it is after the time the request was received
	//   - a time-ranged query with StartTime==DeletedAt will not include this instance.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *DomainSegmentConfigDeleteResponse) Reset() {
	*x = DomainSegmentConfigDeleteResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[62]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainSegmentConfigDeleteResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainSegmentConfigDeleteResponse) ProtoMessage() {}

func (x *DomainSegmentConfigDeleteResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[62]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainSegmentConfigDeleteResponse.ProtoReflect.Descriptor instead.
func (*DomainSegmentConfigDeleteResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{62}
}

func (x *DomainSegmentConfigDeleteResponse) GetKey() *DomainSegmentKey {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *DomainSegmentConfigDeleteResponse) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type DomainSegmentConfigDeleteSomeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// key contains a list of DomainSegmentConfig keys to delete
	Keys []*DomainSegmentKey `protobuf:"bytes,1,rep,name=keys,proto3" json:"keys,omitempty"`
}

func (x *DomainSegmentConfigDeleteSomeRequest) Reset() {
	*x = DomainSegmentConfigDeleteSomeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[63]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainSegmentConfigDeleteSomeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainSegmentConfigDeleteSomeRequest) ProtoMessage() {}

func (x *DomainSegmentConfigDeleteSomeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[63]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainSegmentConfigDeleteSomeRequest.ProtoReflect.Descriptor instead.
func (*DomainSegmentConfigDeleteSomeRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{63}
}

func (x *DomainSegmentConfigDeleteSomeRequest) GetKeys() []*DomainSegmentKey {
	if x != nil {
		return x.Keys
	}
	return nil
}

// DomainSegmentConfigDeleteSomeResponse is only sent when there is an error.
type DomainSegmentConfigDeleteSomeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key   *DomainSegmentKey `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Error string            `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *DomainSegmentConfigDeleteSomeResponse) Reset() {
	*x = DomainSegmentConfigDeleteSomeResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[64]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainSegmentConfigDeleteSomeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainSegmentConfigDeleteSomeResponse) ProtoMessage() {}

func (x *DomainSegmentConfigDeleteSomeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[64]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainSegmentConfigDeleteSomeResponse.ProtoReflect.Descriptor instead.
func (*DomainSegmentConfigDeleteSomeResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{64}
}

func (x *DomainSegmentConfigDeleteSomeResponse) GetKey() *DomainSegmentKey {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *DomainSegmentConfigDeleteSomeResponse) GetError() string {
	if x != nil {
		return x.Error
	}
	return ""
}

type DomainSegmentConfigDeleteAllRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DomainSegmentConfigDeleteAllRequest) Reset() {
	*x = DomainSegmentConfigDeleteAllRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[65]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainSegmentConfigDeleteAllRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainSegmentConfigDeleteAllRequest) ProtoMessage() {}

func (x *DomainSegmentConfigDeleteAllRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[65]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainSegmentConfigDeleteAllRequest.ProtoReflect.Descriptor instead.
func (*DomainSegmentConfigDeleteAllRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{65}
}

type DomainSegmentConfigDeleteAllResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This describes the class of delete error.
	Type fmp.DeleteError `protobuf:"varint,1,opt,name=type,proto3,enum=fmp.DeleteError" json:"type,omitempty"`
	// This indicates the error message from the delete failure.
	Error *wrapperspb.StringValue `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	// This is the key of the DomainSegmentConfig instance that failed to be deleted.
	Key *DomainSegmentKey `protobuf:"bytes,3,opt,name=key,proto3" json:"key,omitempty"`
	// Time indicates the (UTC) timestamp when the key was being deleted.
	Time *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *DomainSegmentConfigDeleteAllResponse) Reset() {
	*x = DomainSegmentConfigDeleteAllResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[66]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainSegmentConfigDeleteAllResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainSegmentConfigDeleteAllResponse) ProtoMessage() {}

func (x *DomainSegmentConfigDeleteAllResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[66]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainSegmentConfigDeleteAllResponse.ProtoReflect.Descriptor instead.
func (*DomainSegmentConfigDeleteAllResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{66}
}

func (x *DomainSegmentConfigDeleteAllResponse) GetType() fmp.DeleteError {
	if x != nil {
		return x.Type
	}
	return fmp.DeleteError(0)
}

func (x *DomainSegmentConfigDeleteAllResponse) GetError() *wrapperspb.StringValue {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *DomainSegmentConfigDeleteAllResponse) GetKey() *DomainSegmentKey {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *DomainSegmentConfigDeleteAllResponse) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type DomainSegmentPolicyConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Key uniquely identifies a DomainSegmentPolicyConfig instance to retrieve.
	// This value must be populated.
	Key *DomainSegmentPolicyKey `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Time indicates the time for which you are interested in the data.
	// If no time is given, the server will use the time at which it makes the request.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *DomainSegmentPolicyConfigRequest) Reset() {
	*x = DomainSegmentPolicyConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[67]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainSegmentPolicyConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainSegmentPolicyConfigRequest) ProtoMessage() {}

func (x *DomainSegmentPolicyConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[67]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainSegmentPolicyConfigRequest.ProtoReflect.Descriptor instead.
func (*DomainSegmentPolicyConfigRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{67}
}

func (x *DomainSegmentPolicyConfigRequest) GetKey() *DomainSegmentPolicyKey {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *DomainSegmentPolicyConfigRequest) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type DomainSegmentPolicyConfigResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Value is the value requested.
	// This structure will be fully-populated as it exists in the datastore. If
	// optional fields were not given at creation, these fields will be empty or
	// set to default values.
	Value *DomainSegmentPolicyConfig `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Time carries the (UTC) timestamp of the last-modification of the
	// DomainSegmentPolicyConfig instance in this response.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *DomainSegmentPolicyConfigResponse) Reset() {
	*x = DomainSegmentPolicyConfigResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[68]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainSegmentPolicyConfigResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainSegmentPolicyConfigResponse) ProtoMessage() {}

func (x *DomainSegmentPolicyConfigResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[68]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainSegmentPolicyConfigResponse.ProtoReflect.Descriptor instead.
func (*DomainSegmentPolicyConfigResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{68}
}

func (x *DomainSegmentPolicyConfigResponse) GetValue() *DomainSegmentPolicyConfig {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *DomainSegmentPolicyConfigResponse) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type DomainSegmentPolicyConfigSomeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Keys []*DomainSegmentPolicyKey `protobuf:"bytes,1,rep,name=keys,proto3" json:"keys,omitempty"`
	// Time indicates the time for which you are interested in the data.
	// If no time is given, the server will use the time at which it makes the request.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *DomainSegmentPolicyConfigSomeRequest) Reset() {
	*x = DomainSegmentPolicyConfigSomeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[69]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainSegmentPolicyConfigSomeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainSegmentPolicyConfigSomeRequest) ProtoMessage() {}

func (x *DomainSegmentPolicyConfigSomeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[69]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainSegmentPolicyConfigSomeRequest.ProtoReflect.Descriptor instead.
func (*DomainSegmentPolicyConfigSomeRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{69}
}

func (x *DomainSegmentPolicyConfigSomeRequest) GetKeys() []*DomainSegmentPolicyKey {
	if x != nil {
		return x.Keys
	}
	return nil
}

func (x *DomainSegmentPolicyConfigSomeRequest) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type DomainSegmentPolicyConfigSomeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Value is the value requested.
	// This structure will be fully-populated as it exists in the datastore. If
	// optional fields were not given at creation, these fields will be empty or
	// set to default values.
	Value *DomainSegmentPolicyConfig `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Error is an optional field.
	// It should be filled when there is an error in the GetSome process.
	Error *wrapperspb.StringValue `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	Time  *timestamppb.Timestamp  `protobuf:"bytes,3,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *DomainSegmentPolicyConfigSomeResponse) Reset() {
	*x = DomainSegmentPolicyConfigSomeResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[70]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainSegmentPolicyConfigSomeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainSegmentPolicyConfigSomeResponse) ProtoMessage() {}

func (x *DomainSegmentPolicyConfigSomeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[70]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainSegmentPolicyConfigSomeResponse.ProtoReflect.Descriptor instead.
func (*DomainSegmentPolicyConfigSomeResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{70}
}

func (x *DomainSegmentPolicyConfigSomeResponse) GetValue() *DomainSegmentPolicyConfig {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *DomainSegmentPolicyConfigSomeResponse) GetError() *wrapperspb.StringValue {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *DomainSegmentPolicyConfigSomeResponse) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type DomainSegmentPolicyConfigStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// PartialEqFilter provides a way to server-side filter a GetAll/Subscribe.
	// This requires all provided fields to be equal to the response.
	//
	// While transparent to users, this field also allows services to optimize internal
	// subscriptions if filter(s) are sufficiently specific.
	PartialEqFilter []*DomainSegmentPolicyConfig `protobuf:"bytes,1,rep,name=partial_eq_filter,json=partialEqFilter,proto3" json:"partial_eq_filter,omitempty"`
	// TimeRange allows limiting response data to within a specified time window.
	// If this field is populated, at least one of the two time fields are required.
	//
	// For GetAll, the fields start and end can be used as follows:
	//
	//   - end: Returns the state of each DomainSegmentPolicyConfig at end.
	//   - Each DomainSegmentPolicyConfig response is fully-specified (all fields set).
	//   - start: Returns the state of each DomainSegmentPolicyConfig at start, followed by updates until now.
	//   - Each DomainSegmentPolicyConfig response at start is fully-specified, but updates may be partial.
	//   - start and end: Returns the state of each DomainSegmentPolicyConfig at start, followed by updates
	//     until end.
	//   - Each DomainSegmentPolicyConfig response at start is fully-specified, but updates until end may
	//     be partial.
	//
	// This field is not allowed in the Subscribe RPC.
	Time *time.TimeBounds `protobuf:"bytes,3,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *DomainSegmentPolicyConfigStreamRequest) Reset() {
	*x = DomainSegmentPolicyConfigStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[71]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainSegmentPolicyConfigStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainSegmentPolicyConfigStreamRequest) ProtoMessage() {}

func (x *DomainSegmentPolicyConfigStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[71]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainSegmentPolicyConfigStreamRequest.ProtoReflect.Descriptor instead.
func (*DomainSegmentPolicyConfigStreamRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{71}
}

func (x *DomainSegmentPolicyConfigStreamRequest) GetPartialEqFilter() []*DomainSegmentPolicyConfig {
	if x != nil {
		return x.PartialEqFilter
	}
	return nil
}

func (x *DomainSegmentPolicyConfigStreamRequest) GetTime() *time.TimeBounds {
	if x != nil {
		return x.Time
	}
	return nil
}

type DomainSegmentPolicyConfigStreamResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Value is a value deemed relevant to the initiating request.
	// This structure will always have its key-field populated. Which other fields are
	// populated, and why, depends on the value of Operation and what triggered this notification.
	Value *DomainSegmentPolicyConfig `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Time holds the timestamp of this DomainSegmentPolicyConfig's last modification.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
	// Operation indicates how the DomainSegmentPolicyConfig value in this response should be considered.
	// Under non-subscribe requests, this value should always be INITIAL. In a subscription,
	// once all initial data is streamed and the client begins to receive modification updates,
	// you should not see INITIAL again.
	Type subscriptions.Operation `protobuf:"varint,3,opt,name=type,proto3,enum=arista.subscriptions.Operation" json:"type,omitempty"`
}

func (x *DomainSegmentPolicyConfigStreamResponse) Reset() {
	*x = DomainSegmentPolicyConfigStreamResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[72]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainSegmentPolicyConfigStreamResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainSegmentPolicyConfigStreamResponse) ProtoMessage() {}

func (x *DomainSegmentPolicyConfigStreamResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[72]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainSegmentPolicyConfigStreamResponse.ProtoReflect.Descriptor instead.
func (*DomainSegmentPolicyConfigStreamResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{72}
}

func (x *DomainSegmentPolicyConfigStreamResponse) GetValue() *DomainSegmentPolicyConfig {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *DomainSegmentPolicyConfigStreamResponse) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

func (x *DomainSegmentPolicyConfigStreamResponse) GetType() subscriptions.Operation {
	if x != nil {
		return x.Type
	}
	return subscriptions.Operation(0)
}

type DomainSegmentPolicyConfigSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// DomainSegmentPolicyConfig carries the value to set into the datastore.
	// See the documentation on the DomainSegmentPolicyConfig struct for which fields are required.
	Value *DomainSegmentPolicyConfig `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *DomainSegmentPolicyConfigSetRequest) Reset() {
	*x = DomainSegmentPolicyConfigSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[73]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainSegmentPolicyConfigSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainSegmentPolicyConfigSetRequest) ProtoMessage() {}

func (x *DomainSegmentPolicyConfigSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[73]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainSegmentPolicyConfigSetRequest.ProtoReflect.Descriptor instead.
func (*DomainSegmentPolicyConfigSetRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{73}
}

func (x *DomainSegmentPolicyConfigSetRequest) GetValue() *DomainSegmentPolicyConfig {
	if x != nil {
		return x.Value
	}
	return nil
}

type DomainSegmentPolicyConfigSetResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Value carries all the values given in the DomainSegmentPolicyConfigSetRequest as well
	// as any server-generated values.
	Value *DomainSegmentPolicyConfig `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Time indicates the (UTC) timestamp at which the system recognizes the
	// creation. The only guarantees made about this timestamp are:
	//
	//   - it is after the time the request was received
	//   - a time-ranged query with StartTime==CreatedAt will include this instance.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *DomainSegmentPolicyConfigSetResponse) Reset() {
	*x = DomainSegmentPolicyConfigSetResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[74]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainSegmentPolicyConfigSetResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainSegmentPolicyConfigSetResponse) ProtoMessage() {}

func (x *DomainSegmentPolicyConfigSetResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[74]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainSegmentPolicyConfigSetResponse.ProtoReflect.Descriptor instead.
func (*DomainSegmentPolicyConfigSetResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{74}
}

func (x *DomainSegmentPolicyConfigSetResponse) GetValue() *DomainSegmentPolicyConfig {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *DomainSegmentPolicyConfigSetResponse) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type DomainSegmentPolicyConfigSetSomeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// value contains a list of DomainSegmentPolicyConfig values to write.
	// It is possible to provide more values than can fit within either:
	//   - the maxiumum send size of the client
	//   - the maximum receive size of the server
	//
	// If this error occurs you must reduce the number of values sent.
	// See gRPC "maximum message size" documentation for more information.
	Values []*DomainSegmentPolicyConfig `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *DomainSegmentPolicyConfigSetSomeRequest) Reset() {
	*x = DomainSegmentPolicyConfigSetSomeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[75]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainSegmentPolicyConfigSetSomeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainSegmentPolicyConfigSetSomeRequest) ProtoMessage() {}

func (x *DomainSegmentPolicyConfigSetSomeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[75]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainSegmentPolicyConfigSetSomeRequest.ProtoReflect.Descriptor instead.
func (*DomainSegmentPolicyConfigSetSomeRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{75}
}

func (x *DomainSegmentPolicyConfigSetSomeRequest) GetValues() []*DomainSegmentPolicyConfig {
	if x != nil {
		return x.Values
	}
	return nil
}

type DomainSegmentPolicyConfigSetSomeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key   *DomainSegmentPolicyKey `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Error string                  `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *DomainSegmentPolicyConfigSetSomeResponse) Reset() {
	*x = DomainSegmentPolicyConfigSetSomeResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[76]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainSegmentPolicyConfigSetSomeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainSegmentPolicyConfigSetSomeResponse) ProtoMessage() {}

func (x *DomainSegmentPolicyConfigSetSomeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[76]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainSegmentPolicyConfigSetSomeResponse.ProtoReflect.Descriptor instead.
func (*DomainSegmentPolicyConfigSetSomeResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{76}
}

func (x *DomainSegmentPolicyConfigSetSomeResponse) GetKey() *DomainSegmentPolicyKey {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *DomainSegmentPolicyConfigSetSomeResponse) GetError() string {
	if x != nil {
		return x.Error
	}
	return ""
}

type DomainSegmentPolicyConfigDeleteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Key indicates which DomainSegmentPolicyConfig instance to remove.
	// This field must always be set.
	Key *DomainSegmentPolicyKey `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
}

func (x *DomainSegmentPolicyConfigDeleteRequest) Reset() {
	*x = DomainSegmentPolicyConfigDeleteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[77]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainSegmentPolicyConfigDeleteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainSegmentPolicyConfigDeleteRequest) ProtoMessage() {}

func (x *DomainSegmentPolicyConfigDeleteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[77]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainSegmentPolicyConfigDeleteRequest.ProtoReflect.Descriptor instead.
func (*DomainSegmentPolicyConfigDeleteRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{77}
}

func (x *DomainSegmentPolicyConfigDeleteRequest) GetKey() *DomainSegmentPolicyKey {
	if x != nil {
		return x.Key
	}
	return nil
}

type DomainSegmentPolicyConfigDeleteResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Key echoes back the key of the deleted DomainSegmentPolicyConfig instance.
	Key *DomainSegmentPolicyKey `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Time indicates the (UTC) timestamp at which the system recognizes the
	// deletion. The only guarantees made about this timestamp are:
	//
	//   - it is after the time the request was received
	//   - a time-ranged query with StartTime==DeletedAt will not include this instance.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *DomainSegmentPolicyConfigDeleteResponse) Reset() {
	*x = DomainSegmentPolicyConfigDeleteResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[78]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainSegmentPolicyConfigDeleteResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainSegmentPolicyConfigDeleteResponse) ProtoMessage() {}

func (x *DomainSegmentPolicyConfigDeleteResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[78]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainSegmentPolicyConfigDeleteResponse.ProtoReflect.Descriptor instead.
func (*DomainSegmentPolicyConfigDeleteResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{78}
}

func (x *DomainSegmentPolicyConfigDeleteResponse) GetKey() *DomainSegmentPolicyKey {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *DomainSegmentPolicyConfigDeleteResponse) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type DomainSegmentPolicyConfigDeleteSomeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// key contains a list of DomainSegmentPolicyConfig keys to delete
	Keys []*DomainSegmentPolicyKey `protobuf:"bytes,1,rep,name=keys,proto3" json:"keys,omitempty"`
}

func (x *DomainSegmentPolicyConfigDeleteSomeRequest) Reset() {
	*x = DomainSegmentPolicyConfigDeleteSomeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[79]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainSegmentPolicyConfigDeleteSomeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainSegmentPolicyConfigDeleteSomeRequest) ProtoMessage() {}

func (x *DomainSegmentPolicyConfigDeleteSomeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[79]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainSegmentPolicyConfigDeleteSomeRequest.ProtoReflect.Descriptor instead.
func (*DomainSegmentPolicyConfigDeleteSomeRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{79}
}

func (x *DomainSegmentPolicyConfigDeleteSomeRequest) GetKeys() []*DomainSegmentPolicyKey {
	if x != nil {
		return x.Keys
	}
	return nil
}

// DomainSegmentPolicyConfigDeleteSomeResponse is only sent when there is an error.
type DomainSegmentPolicyConfigDeleteSomeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key   *DomainSegmentPolicyKey `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Error string                  `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *DomainSegmentPolicyConfigDeleteSomeResponse) Reset() {
	*x = DomainSegmentPolicyConfigDeleteSomeResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[80]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainSegmentPolicyConfigDeleteSomeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainSegmentPolicyConfigDeleteSomeResponse) ProtoMessage() {}

func (x *DomainSegmentPolicyConfigDeleteSomeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[80]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainSegmentPolicyConfigDeleteSomeResponse.ProtoReflect.Descriptor instead.
func (*DomainSegmentPolicyConfigDeleteSomeResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{80}
}

func (x *DomainSegmentPolicyConfigDeleteSomeResponse) GetKey() *DomainSegmentPolicyKey {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *DomainSegmentPolicyConfigDeleteSomeResponse) GetError() string {
	if x != nil {
		return x.Error
	}
	return ""
}

type DomainSegmentPolicyConfigDeleteAllRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DomainSegmentPolicyConfigDeleteAllRequest) Reset() {
	*x = DomainSegmentPolicyConfigDeleteAllRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[81]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainSegmentPolicyConfigDeleteAllRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainSegmentPolicyConfigDeleteAllRequest) ProtoMessage() {}

func (x *DomainSegmentPolicyConfigDeleteAllRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[81]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainSegmentPolicyConfigDeleteAllRequest.ProtoReflect.Descriptor instead.
func (*DomainSegmentPolicyConfigDeleteAllRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{81}
}

type DomainSegmentPolicyConfigDeleteAllResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This describes the class of delete error.
	Type fmp.DeleteError `protobuf:"varint,1,opt,name=type,proto3,enum=fmp.DeleteError" json:"type,omitempty"`
	// This indicates the error message from the delete failure.
	Error *wrapperspb.StringValue `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	// This is the key of the DomainSegmentPolicyConfig instance that failed to be deleted.
	Key *DomainSegmentPolicyKey `protobuf:"bytes,3,opt,name=key,proto3" json:"key,omitempty"`
	// Time indicates the (UTC) timestamp when the key was being deleted.
	Time *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *DomainSegmentPolicyConfigDeleteAllResponse) Reset() {
	*x = DomainSegmentPolicyConfigDeleteAllResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[82]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainSegmentPolicyConfigDeleteAllResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainSegmentPolicyConfigDeleteAllResponse) ProtoMessage() {}

func (x *DomainSegmentPolicyConfigDeleteAllResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[82]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainSegmentPolicyConfigDeleteAllResponse.ProtoReflect.Descriptor instead.
func (*DomainSegmentPolicyConfigDeleteAllResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{82}
}

func (x *DomainSegmentPolicyConfigDeleteAllResponse) GetType() fmp.DeleteError {
	if x != nil {
		return x.Type
	}
	return fmp.DeleteError(0)
}

func (x *DomainSegmentPolicyConfigDeleteAllResponse) GetError() *wrapperspb.StringValue {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *DomainSegmentPolicyConfigDeleteAllResponse) GetKey() *DomainSegmentPolicyKey {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *DomainSegmentPolicyConfigDeleteAllResponse) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type DomainConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Key uniquely identifies a DomainConfig instance to retrieve.
	// This value must be populated.
	Key *DomainKey `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Time indicates the time for which you are interested in the data.
	// If no time is given, the server will use the time at which it makes the request.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *DomainConfigRequest) Reset() {
	*x = DomainConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[83]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainConfigRequest) ProtoMessage() {}

func (x *DomainConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[83]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainConfigRequest.ProtoReflect.Descriptor instead.
func (*DomainConfigRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{83}
}

func (x *DomainConfigRequest) GetKey() *DomainKey {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *DomainConfigRequest) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type DomainConfigResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Value is the value requested.
	// This structure will be fully-populated as it exists in the datastore. If
	// optional fields were not given at creation, these fields will be empty or
	// set to default values.
	Value *DomainConfig `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Time carries the (UTC) timestamp of the last-modification of the
	// DomainConfig instance in this response.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *DomainConfigResponse) Reset() {
	*x = DomainConfigResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[84]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainConfigResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainConfigResponse) ProtoMessage() {}

func (x *DomainConfigResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[84]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainConfigResponse.ProtoReflect.Descriptor instead.
func (*DomainConfigResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{84}
}

func (x *DomainConfigResponse) GetValue() *DomainConfig {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *DomainConfigResponse) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type DomainConfigSomeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Keys []*DomainKey `protobuf:"bytes,1,rep,name=keys,proto3" json:"keys,omitempty"`
	// Time indicates the time for which you are interested in the data.
	// If no time is given, the server will use the time at which it makes the request.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *DomainConfigSomeRequest) Reset() {
	*x = DomainConfigSomeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[85]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainConfigSomeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainConfigSomeRequest) ProtoMessage() {}

func (x *DomainConfigSomeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[85]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainConfigSomeRequest.ProtoReflect.Descriptor instead.
func (*DomainConfigSomeRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{85}
}

func (x *DomainConfigSomeRequest) GetKeys() []*DomainKey {
	if x != nil {
		return x.Keys
	}
	return nil
}

func (x *DomainConfigSomeRequest) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type DomainConfigSomeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Value is the value requested.
	// This structure will be fully-populated as it exists in the datastore. If
	// optional fields were not given at creation, these fields will be empty or
	// set to default values.
	Value *DomainConfig `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Error is an optional field.
	// It should be filled when there is an error in the GetSome process.
	Error *wrapperspb.StringValue `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	Time  *timestamppb.Timestamp  `protobuf:"bytes,3,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *DomainConfigSomeResponse) Reset() {
	*x = DomainConfigSomeResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[86]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainConfigSomeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainConfigSomeResponse) ProtoMessage() {}

func (x *DomainConfigSomeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[86]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainConfigSomeResponse.ProtoReflect.Descriptor instead.
func (*DomainConfigSomeResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{86}
}

func (x *DomainConfigSomeResponse) GetValue() *DomainConfig {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *DomainConfigSomeResponse) GetError() *wrapperspb.StringValue {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *DomainConfigSomeResponse) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type DomainConfigStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// PartialEqFilter provides a way to server-side filter a GetAll/Subscribe.
	// This requires all provided fields to be equal to the response.
	//
	// While transparent to users, this field also allows services to optimize internal
	// subscriptions if filter(s) are sufficiently specific.
	PartialEqFilter []*DomainConfig `protobuf:"bytes,1,rep,name=partial_eq_filter,json=partialEqFilter,proto3" json:"partial_eq_filter,omitempty"`
	// TimeRange allows limiting response data to within a specified time window.
	// If this field is populated, at least one of the two time fields are required.
	//
	// For GetAll, the fields start and end can be used as follows:
	//
	//   - end: Returns the state of each DomainConfig at end.
	//   - Each DomainConfig response is fully-specified (all fields set).
	//   - start: Returns the state of each DomainConfig at start, followed by updates until now.
	//   - Each DomainConfig response at start is fully-specified, but updates may be partial.
	//   - start and end: Returns the state of each DomainConfig at start, followed by updates
	//     until end.
	//   - Each DomainConfig response at start is fully-specified, but updates until end may
	//     be partial.
	//
	// This field is not allowed in the Subscribe RPC.
	Time *time.TimeBounds `protobuf:"bytes,3,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *DomainConfigStreamRequest) Reset() {
	*x = DomainConfigStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[87]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainConfigStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainConfigStreamRequest) ProtoMessage() {}

func (x *DomainConfigStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[87]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainConfigStreamRequest.ProtoReflect.Descriptor instead.
func (*DomainConfigStreamRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{87}
}

func (x *DomainConfigStreamRequest) GetPartialEqFilter() []*DomainConfig {
	if x != nil {
		return x.PartialEqFilter
	}
	return nil
}

func (x *DomainConfigStreamRequest) GetTime() *time.TimeBounds {
	if x != nil {
		return x.Time
	}
	return nil
}

type DomainConfigStreamResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Value is a value deemed relevant to the initiating request.
	// This structure will always have its key-field populated. Which other fields are
	// populated, and why, depends on the value of Operation and what triggered this notification.
	Value *DomainConfig `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Time holds the timestamp of this DomainConfig's last modification.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
	// Operation indicates how the DomainConfig value in this response should be considered.
	// Under non-subscribe requests, this value should always be INITIAL. In a subscription,
	// once all initial data is streamed and the client begins to receive modification updates,
	// you should not see INITIAL again.
	Type subscriptions.Operation `protobuf:"varint,3,opt,name=type,proto3,enum=arista.subscriptions.Operation" json:"type,omitempty"`
}

func (x *DomainConfigStreamResponse) Reset() {
	*x = DomainConfigStreamResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[88]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainConfigStreamResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainConfigStreamResponse) ProtoMessage() {}

func (x *DomainConfigStreamResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[88]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainConfigStreamResponse.ProtoReflect.Descriptor instead.
func (*DomainConfigStreamResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{88}
}

func (x *DomainConfigStreamResponse) GetValue() *DomainConfig {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *DomainConfigStreamResponse) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

func (x *DomainConfigStreamResponse) GetType() subscriptions.Operation {
	if x != nil {
		return x.Type
	}
	return subscriptions.Operation(0)
}

type DomainConfigSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// DomainConfig carries the value to set into the datastore.
	// See the documentation on the DomainConfig struct for which fields are required.
	Value *DomainConfig `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *DomainConfigSetRequest) Reset() {
	*x = DomainConfigSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[89]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainConfigSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainConfigSetRequest) ProtoMessage() {}

func (x *DomainConfigSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[89]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainConfigSetRequest.ProtoReflect.Descriptor instead.
func (*DomainConfigSetRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{89}
}

func (x *DomainConfigSetRequest) GetValue() *DomainConfig {
	if x != nil {
		return x.Value
	}
	return nil
}

type DomainConfigSetResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Value carries all the values given in the DomainConfigSetRequest as well
	// as any server-generated values.
	Value *DomainConfig `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Time indicates the (UTC) timestamp at which the system recognizes the
	// creation. The only guarantees made about this timestamp are:
	//
	//   - it is after the time the request was received
	//   - a time-ranged query with StartTime==CreatedAt will include this instance.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *DomainConfigSetResponse) Reset() {
	*x = DomainConfigSetResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[90]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainConfigSetResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainConfigSetResponse) ProtoMessage() {}

func (x *DomainConfigSetResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[90]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainConfigSetResponse.ProtoReflect.Descriptor instead.
func (*DomainConfigSetResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{90}
}

func (x *DomainConfigSetResponse) GetValue() *DomainConfig {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *DomainConfigSetResponse) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type DomainConfigSetSomeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// value contains a list of DomainConfig values to write.
	// It is possible to provide more values than can fit within either:
	//   - the maxiumum send size of the client
	//   - the maximum receive size of the server
	//
	// If this error occurs you must reduce the number of values sent.
	// See gRPC "maximum message size" documentation for more information.
	Values []*DomainConfig `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *DomainConfigSetSomeRequest) Reset() {
	*x = DomainConfigSetSomeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[91]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainConfigSetSomeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainConfigSetSomeRequest) ProtoMessage() {}

func (x *DomainConfigSetSomeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[91]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainConfigSetSomeRequest.ProtoReflect.Descriptor instead.
func (*DomainConfigSetSomeRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{91}
}

func (x *DomainConfigSetSomeRequest) GetValues() []*DomainConfig {
	if x != nil {
		return x.Values
	}
	return nil
}

type DomainConfigSetSomeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key   *DomainKey `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Error string     `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *DomainConfigSetSomeResponse) Reset() {
	*x = DomainConfigSetSomeResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[92]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainConfigSetSomeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainConfigSetSomeResponse) ProtoMessage() {}

func (x *DomainConfigSetSomeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[92]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainConfigSetSomeResponse.ProtoReflect.Descriptor instead.
func (*DomainConfigSetSomeResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{92}
}

func (x *DomainConfigSetSomeResponse) GetKey() *DomainKey {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *DomainConfigSetSomeResponse) GetError() string {
	if x != nil {
		return x.Error
	}
	return ""
}

type DomainConfigDeleteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Key indicates which DomainConfig instance to remove.
	// This field must always be set.
	Key *DomainKey `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
}

func (x *DomainConfigDeleteRequest) Reset() {
	*x = DomainConfigDeleteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[93]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainConfigDeleteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainConfigDeleteRequest) ProtoMessage() {}

func (x *DomainConfigDeleteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[93]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainConfigDeleteRequest.ProtoReflect.Descriptor instead.
func (*DomainConfigDeleteRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{93}
}

func (x *DomainConfigDeleteRequest) GetKey() *DomainKey {
	if x != nil {
		return x.Key
	}
	return nil
}

type DomainConfigDeleteResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Key echoes back the key of the deleted DomainConfig instance.
	Key *DomainKey `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Time indicates the (UTC) timestamp at which the system recognizes the
	// deletion. The only guarantees made about this timestamp are:
	//
	//   - it is after the time the request was received
	//   - a time-ranged query with StartTime==DeletedAt will not include this instance.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *DomainConfigDeleteResponse) Reset() {
	*x = DomainConfigDeleteResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[94]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainConfigDeleteResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainConfigDeleteResponse) ProtoMessage() {}

func (x *DomainConfigDeleteResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[94]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainConfigDeleteResponse.ProtoReflect.Descriptor instead.
func (*DomainConfigDeleteResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{94}
}

func (x *DomainConfigDeleteResponse) GetKey() *DomainKey {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *DomainConfigDeleteResponse) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type DomainConfigDeleteSomeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// key contains a list of DomainConfig keys to delete
	Keys []*DomainKey `protobuf:"bytes,1,rep,name=keys,proto3" json:"keys,omitempty"`
}

func (x *DomainConfigDeleteSomeRequest) Reset() {
	*x = DomainConfigDeleteSomeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[95]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainConfigDeleteSomeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainConfigDeleteSomeRequest) ProtoMessage() {}

func (x *DomainConfigDeleteSomeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[95]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainConfigDeleteSomeRequest.ProtoReflect.Descriptor instead.
func (*DomainConfigDeleteSomeRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{95}
}

func (x *DomainConfigDeleteSomeRequest) GetKeys() []*DomainKey {
	if x != nil {
		return x.Keys
	}
	return nil
}

// DomainConfigDeleteSomeResponse is only sent when there is an error.
type DomainConfigDeleteSomeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key   *DomainKey `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Error string     `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *DomainConfigDeleteSomeResponse) Reset() {
	*x = DomainConfigDeleteSomeResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[96]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainConfigDeleteSomeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainConfigDeleteSomeResponse) ProtoMessage() {}

func (x *DomainConfigDeleteSomeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[96]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainConfigDeleteSomeResponse.ProtoReflect.Descriptor instead.
func (*DomainConfigDeleteSomeResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{96}
}

func (x *DomainConfigDeleteSomeResponse) GetKey() *DomainKey {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *DomainConfigDeleteSomeResponse) GetError() string {
	if x != nil {
		return x.Error
	}
	return ""
}

type DomainConfigDeleteAllRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DomainConfigDeleteAllRequest) Reset() {
	*x = DomainConfigDeleteAllRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[97]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainConfigDeleteAllRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainConfigDeleteAllRequest) ProtoMessage() {}

func (x *DomainConfigDeleteAllRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[97]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainConfigDeleteAllRequest.ProtoReflect.Descriptor instead.
func (*DomainConfigDeleteAllRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{97}
}

type DomainConfigDeleteAllResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This describes the class of delete error.
	Type fmp.DeleteError `protobuf:"varint,1,opt,name=type,proto3,enum=fmp.DeleteError" json:"type,omitempty"`
	// This indicates the error message from the delete failure.
	Error *wrapperspb.StringValue `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	// This is the key of the DomainConfig instance that failed to be deleted.
	Key *DomainKey `protobuf:"bytes,3,opt,name=key,proto3" json:"key,omitempty"`
	// Time indicates the (UTC) timestamp when the key was being deleted.
	Time *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *DomainConfigDeleteAllResponse) Reset() {
	*x = DomainConfigDeleteAllResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[98]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DomainConfigDeleteAllResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DomainConfigDeleteAllResponse) ProtoMessage() {}

func (x *DomainConfigDeleteAllResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[98]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DomainConfigDeleteAllResponse.ProtoReflect.Descriptor instead.
func (*DomainConfigDeleteAllResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{98}
}

func (x *DomainConfigDeleteAllResponse) GetType() fmp.DeleteError {
	if x != nil {
		return x.Type
	}
	return fmp.DeleteError(0)
}

func (x *DomainConfigDeleteAllResponse) GetError() *wrapperspb.StringValue {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *DomainConfigDeleteAllResponse) GetKey() *DomainKey {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *DomainConfigDeleteAllResponse) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type PolicyConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Key uniquely identifies a PolicyConfig instance to retrieve.
	// This value must be populated.
	Key *PolicyKey `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Time indicates the time for which you are interested in the data.
	// If no time is given, the server will use the time at which it makes the request.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *PolicyConfigRequest) Reset() {
	*x = PolicyConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[99]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyConfigRequest) ProtoMessage() {}

func (x *PolicyConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[99]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyConfigRequest.ProtoReflect.Descriptor instead.
func (*PolicyConfigRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{99}
}

func (x *PolicyConfigRequest) GetKey() *PolicyKey {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *PolicyConfigRequest) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type PolicyConfigResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Value is the value requested.
	// This structure will be fully-populated as it exists in the datastore. If
	// optional fields were not given at creation, these fields will be empty or
	// set to default values.
	Value *PolicyConfig `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Time carries the (UTC) timestamp of the last-modification of the
	// PolicyConfig instance in this response.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *PolicyConfigResponse) Reset() {
	*x = PolicyConfigResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[100]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyConfigResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyConfigResponse) ProtoMessage() {}

func (x *PolicyConfigResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[100]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyConfigResponse.ProtoReflect.Descriptor instead.
func (*PolicyConfigResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{100}
}

func (x *PolicyConfigResponse) GetValue() *PolicyConfig {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *PolicyConfigResponse) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type PolicyConfigSomeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Keys []*PolicyKey `protobuf:"bytes,1,rep,name=keys,proto3" json:"keys,omitempty"`
	// Time indicates the time for which you are interested in the data.
	// If no time is given, the server will use the time at which it makes the request.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *PolicyConfigSomeRequest) Reset() {
	*x = PolicyConfigSomeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[101]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyConfigSomeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyConfigSomeRequest) ProtoMessage() {}

func (x *PolicyConfigSomeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[101]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyConfigSomeRequest.ProtoReflect.Descriptor instead.
func (*PolicyConfigSomeRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{101}
}

func (x *PolicyConfigSomeRequest) GetKeys() []*PolicyKey {
	if x != nil {
		return x.Keys
	}
	return nil
}

func (x *PolicyConfigSomeRequest) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type PolicyConfigSomeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Value is the value requested.
	// This structure will be fully-populated as it exists in the datastore. If
	// optional fields were not given at creation, these fields will be empty or
	// set to default values.
	Value *PolicyConfig `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Error is an optional field.
	// It should be filled when there is an error in the GetSome process.
	Error *wrapperspb.StringValue `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	Time  *timestamppb.Timestamp  `protobuf:"bytes,3,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *PolicyConfigSomeResponse) Reset() {
	*x = PolicyConfigSomeResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[102]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyConfigSomeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyConfigSomeResponse) ProtoMessage() {}

func (x *PolicyConfigSomeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[102]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyConfigSomeResponse.ProtoReflect.Descriptor instead.
func (*PolicyConfigSomeResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{102}
}

func (x *PolicyConfigSomeResponse) GetValue() *PolicyConfig {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *PolicyConfigSomeResponse) GetError() *wrapperspb.StringValue {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *PolicyConfigSomeResponse) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type PolicyConfigStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// PartialEqFilter provides a way to server-side filter a GetAll/Subscribe.
	// This requires all provided fields to be equal to the response.
	//
	// While transparent to users, this field also allows services to optimize internal
	// subscriptions if filter(s) are sufficiently specific.
	PartialEqFilter []*PolicyConfig `protobuf:"bytes,1,rep,name=partial_eq_filter,json=partialEqFilter,proto3" json:"partial_eq_filter,omitempty"`
	// TimeRange allows limiting response data to within a specified time window.
	// If this field is populated, at least one of the two time fields are required.
	//
	// For GetAll, the fields start and end can be used as follows:
	//
	//   - end: Returns the state of each PolicyConfig at end.
	//   - Each PolicyConfig response is fully-specified (all fields set).
	//   - start: Returns the state of each PolicyConfig at start, followed by updates until now.
	//   - Each PolicyConfig response at start is fully-specified, but updates may be partial.
	//   - start and end: Returns the state of each PolicyConfig at start, followed by updates
	//     until end.
	//   - Each PolicyConfig response at start is fully-specified, but updates until end may
	//     be partial.
	//
	// This field is not allowed in the Subscribe RPC.
	Time *time.TimeBounds `protobuf:"bytes,3,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *PolicyConfigStreamRequest) Reset() {
	*x = PolicyConfigStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[103]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyConfigStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyConfigStreamRequest) ProtoMessage() {}

func (x *PolicyConfigStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[103]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyConfigStreamRequest.ProtoReflect.Descriptor instead.
func (*PolicyConfigStreamRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{103}
}

func (x *PolicyConfigStreamRequest) GetPartialEqFilter() []*PolicyConfig {
	if x != nil {
		return x.PartialEqFilter
	}
	return nil
}

func (x *PolicyConfigStreamRequest) GetTime() *time.TimeBounds {
	if x != nil {
		return x.Time
	}
	return nil
}

type PolicyConfigStreamResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Value is a value deemed relevant to the initiating request.
	// This structure will always have its key-field populated. Which other fields are
	// populated, and why, depends on the value of Operation and what triggered this notification.
	Value *PolicyConfig `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Time holds the timestamp of this PolicyConfig's last modification.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
	// Operation indicates how the PolicyConfig value in this response should be considered.
	// Under non-subscribe requests, this value should always be INITIAL. In a subscription,
	// once all initial data is streamed and the client begins to receive modification updates,
	// you should not see INITIAL again.
	Type subscriptions.Operation `protobuf:"varint,3,opt,name=type,proto3,enum=arista.subscriptions.Operation" json:"type,omitempty"`
}

func (x *PolicyConfigStreamResponse) Reset() {
	*x = PolicyConfigStreamResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[104]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyConfigStreamResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyConfigStreamResponse) ProtoMessage() {}

func (x *PolicyConfigStreamResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[104]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyConfigStreamResponse.ProtoReflect.Descriptor instead.
func (*PolicyConfigStreamResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{104}
}

func (x *PolicyConfigStreamResponse) GetValue() *PolicyConfig {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *PolicyConfigStreamResponse) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

func (x *PolicyConfigStreamResponse) GetType() subscriptions.Operation {
	if x != nil {
		return x.Type
	}
	return subscriptions.Operation(0)
}

type PolicyConfigSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// PolicyConfig carries the value to set into the datastore.
	// See the documentation on the PolicyConfig struct for which fields are required.
	Value *PolicyConfig `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *PolicyConfigSetRequest) Reset() {
	*x = PolicyConfigSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[105]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyConfigSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyConfigSetRequest) ProtoMessage() {}

func (x *PolicyConfigSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[105]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyConfigSetRequest.ProtoReflect.Descriptor instead.
func (*PolicyConfigSetRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{105}
}

func (x *PolicyConfigSetRequest) GetValue() *PolicyConfig {
	if x != nil {
		return x.Value
	}
	return nil
}

type PolicyConfigSetResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Value carries all the values given in the PolicyConfigSetRequest as well
	// as any server-generated values.
	Value *PolicyConfig `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Time indicates the (UTC) timestamp at which the system recognizes the
	// creation. The only guarantees made about this timestamp are:
	//
	//   - it is after the time the request was received
	//   - a time-ranged query with StartTime==CreatedAt will include this instance.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *PolicyConfigSetResponse) Reset() {
	*x = PolicyConfigSetResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[106]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyConfigSetResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyConfigSetResponse) ProtoMessage() {}

func (x *PolicyConfigSetResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[106]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyConfigSetResponse.ProtoReflect.Descriptor instead.
func (*PolicyConfigSetResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{106}
}

func (x *PolicyConfigSetResponse) GetValue() *PolicyConfig {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *PolicyConfigSetResponse) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type PolicyConfigSetSomeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// value contains a list of PolicyConfig values to write.
	// It is possible to provide more values than can fit within either:
	//   - the maxiumum send size of the client
	//   - the maximum receive size of the server
	//
	// If this error occurs you must reduce the number of values sent.
	// See gRPC "maximum message size" documentation for more information.
	Values []*PolicyConfig `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *PolicyConfigSetSomeRequest) Reset() {
	*x = PolicyConfigSetSomeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[107]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyConfigSetSomeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyConfigSetSomeRequest) ProtoMessage() {}

func (x *PolicyConfigSetSomeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[107]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyConfigSetSomeRequest.ProtoReflect.Descriptor instead.
func (*PolicyConfigSetSomeRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{107}
}

func (x *PolicyConfigSetSomeRequest) GetValues() []*PolicyConfig {
	if x != nil {
		return x.Values
	}
	return nil
}

type PolicyConfigSetSomeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key   *PolicyKey `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Error string     `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *PolicyConfigSetSomeResponse) Reset() {
	*x = PolicyConfigSetSomeResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[108]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyConfigSetSomeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyConfigSetSomeResponse) ProtoMessage() {}

func (x *PolicyConfigSetSomeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[108]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyConfigSetSomeResponse.ProtoReflect.Descriptor instead.
func (*PolicyConfigSetSomeResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{108}
}

func (x *PolicyConfigSetSomeResponse) GetKey() *PolicyKey {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *PolicyConfigSetSomeResponse) GetError() string {
	if x != nil {
		return x.Error
	}
	return ""
}

type PolicyConfigDeleteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Key indicates which PolicyConfig instance to remove.
	// This field must always be set.
	Key *PolicyKey `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
}

func (x *PolicyConfigDeleteRequest) Reset() {
	*x = PolicyConfigDeleteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[109]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyConfigDeleteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyConfigDeleteRequest) ProtoMessage() {}

func (x *PolicyConfigDeleteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[109]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyConfigDeleteRequest.ProtoReflect.Descriptor instead.
func (*PolicyConfigDeleteRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{109}
}

func (x *PolicyConfigDeleteRequest) GetKey() *PolicyKey {
	if x != nil {
		return x.Key
	}
	return nil
}

type PolicyConfigDeleteResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Key echoes back the key of the deleted PolicyConfig instance.
	Key *PolicyKey `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Time indicates the (UTC) timestamp at which the system recognizes the
	// deletion. The only guarantees made about this timestamp are:
	//
	//   - it is after the time the request was received
	//   - a time-ranged query with StartTime==DeletedAt will not include this instance.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *PolicyConfigDeleteResponse) Reset() {
	*x = PolicyConfigDeleteResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[110]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyConfigDeleteResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyConfigDeleteResponse) ProtoMessage() {}

func (x *PolicyConfigDeleteResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[110]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyConfigDeleteResponse.ProtoReflect.Descriptor instead.
func (*PolicyConfigDeleteResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{110}
}

func (x *PolicyConfigDeleteResponse) GetKey() *PolicyKey {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *PolicyConfigDeleteResponse) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type PolicyConfigDeleteSomeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// key contains a list of PolicyConfig keys to delete
	Keys []*PolicyKey `protobuf:"bytes,1,rep,name=keys,proto3" json:"keys,omitempty"`
}

func (x *PolicyConfigDeleteSomeRequest) Reset() {
	*x = PolicyConfigDeleteSomeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[111]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyConfigDeleteSomeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyConfigDeleteSomeRequest) ProtoMessage() {}

func (x *PolicyConfigDeleteSomeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[111]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyConfigDeleteSomeRequest.ProtoReflect.Descriptor instead.
func (*PolicyConfigDeleteSomeRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{111}
}

func (x *PolicyConfigDeleteSomeRequest) GetKeys() []*PolicyKey {
	if x != nil {
		return x.Keys
	}
	return nil
}

// PolicyConfigDeleteSomeResponse is only sent when there is an error.
type PolicyConfigDeleteSomeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key   *PolicyKey `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Error string     `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *PolicyConfigDeleteSomeResponse) Reset() {
	*x = PolicyConfigDeleteSomeResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[112]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyConfigDeleteSomeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyConfigDeleteSomeResponse) ProtoMessage() {}

func (x *PolicyConfigDeleteSomeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[112]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyConfigDeleteSomeResponse.ProtoReflect.Descriptor instead.
func (*PolicyConfigDeleteSomeResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{112}
}

func (x *PolicyConfigDeleteSomeResponse) GetKey() *PolicyKey {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *PolicyConfigDeleteSomeResponse) GetError() string {
	if x != nil {
		return x.Error
	}
	return ""
}

type PolicyConfigDeleteAllRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PolicyConfigDeleteAllRequest) Reset() {
	*x = PolicyConfigDeleteAllRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[113]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyConfigDeleteAllRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyConfigDeleteAllRequest) ProtoMessage() {}

func (x *PolicyConfigDeleteAllRequest) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[113]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyConfigDeleteAllRequest.ProtoReflect.Descriptor instead.
func (*PolicyConfigDeleteAllRequest) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{113}
}

type PolicyConfigDeleteAllResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This describes the class of delete error.
	Type fmp.DeleteError `protobuf:"varint,1,opt,name=type,proto3,enum=fmp.DeleteError" json:"type,omitempty"`
	// This indicates the error message from the delete failure.
	Error *wrapperspb.StringValue `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	// This is the key of the PolicyConfig instance that failed to be deleted.
	Key *PolicyKey `protobuf:"bytes,3,opt,name=key,proto3" json:"key,omitempty"`
	// Time indicates the (UTC) timestamp when the key was being deleted.
	Time *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *PolicyConfigDeleteAllResponse) Reset() {
	*x = PolicyConfigDeleteAllResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[114]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyConfigDeleteAllResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyConfigDeleteAllResponse) ProtoMessage() {}

func (x *PolicyConfigDeleteAllResponse) ProtoReflect() protoreflect.Message {
	mi := &file_arista_segmentation_v1_services_gen_proto_msgTypes[114]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyConfigDeleteAllResponse.ProtoReflect.Descriptor instead.
func (*PolicyConfigDeleteAllResponse) Descriptor() ([]byte, []int) {
	return file_arista_segmentation_v1_services_gen_proto_rawDescGZIP(), []int{114}
}

func (x *PolicyConfigDeleteAllResponse) GetType() fmp.DeleteError {
	if x != nil {
		return x.Type
	}
	return fmp.DeleteError(0)
}

func (x *PolicyConfigDeleteAllResponse) GetError() *wrapperspb.StringValue {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *PolicyConfigDeleteAllResponse) GetKey() *PolicyKey {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *PolicyConfigDeleteAllResponse) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

var File_arista_segmentation_v1_services_gen_proto protoreflect.FileDescriptor

var file_arista_segmentation_v1_services_gen_proto_rawDesc = []byte{
	0x0a, 0x29, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2f, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x2e, 0x67, 0x65, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x61, 0x72, 0x69,
	0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x1a, 0x29, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2f, 0x73, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2f, 0x73, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x27,
	0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2f, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2f, 0x65, 0x78, 0x74, 0x72, 0x61, 0x73, 0x2e, 0x67, 0x65,
	0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x16, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2f,
	0x74, 0x69, 0x6d, 0x65, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x28, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2f, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x11, 0x66, 0x6d, 0x70, 0x2f, 0x64,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77,
	0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa7, 0x01,
	0x0a, 0x0c, 0x4d, 0x65, 0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2e,
	0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x33,
	0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x61,
	0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x12, 0x32, 0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x84, 0x01, 0x0a, 0x18, 0x41, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x38, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2e,
	0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x22, 0x8c,
	0x01, 0x0a, 0x19, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3f, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x61, 0x72,
	0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x2e, 0x0a,
	0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x22, 0x8a, 0x01,
	0x0a, 0x1c, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a,
	0x0a, 0x04, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x61,
	0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4b, 0x65, 0x79, 0x52, 0x04, 0x6b, 0x65, 0x79, 0x73, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x22, 0xc4, 0x01, 0x0a, 0x1d, 0x41,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3f, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x61, 0x72,
	0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x32, 0x0a,
	0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d,
	0x65, 0x22, 0xa4, 0x01, 0x0a, 0x1e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x55, 0x0a, 0x11, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x5f,
	0x65, 0x71, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0f, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x61, 0x6c, 0x45, 0x71, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x2b, 0x0a, 0x04, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x61, 0x72, 0x69, 0x73,
	0x74, 0x61, 0x2e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x42, 0x6f, 0x75, 0x6e,
	0x64, 0x73, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x22, 0xc7, 0x01, 0x0a, 0x1f, 0x41, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3f, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x61, 0x72,
	0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x2e, 0x0a,
	0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x33, 0x0a,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x61, 0x72,
	0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x22, 0x5e, 0x0a, 0x1b, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x3f, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x29, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x22, 0x8f, 0x01, 0x0a, 0x1c, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x3f, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x29, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04,
	0x74, 0x69, 0x6d, 0x65, 0x22, 0x64, 0x0a, 0x1f, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x53, 0x6f, 0x6d, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61,
	0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x22, 0x72, 0x0a, 0x20, 0x41, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53,
	0x65, 0x74, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x38,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x61, 0x72,
	0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4b, 0x65, 0x79, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x22, 0x5a,
	0x0a, 0x1e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x38, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e,
	0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x22, 0x8b, 0x01, 0x0a, 0x1f, 0x41,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x38,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x61, 0x72,
	0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4b, 0x65, 0x79, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x22, 0x60, 0x0a, 0x22, 0x41, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a,
	0x0a, 0x04, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x61,
	0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4b, 0x65, 0x79, 0x52, 0x04, 0x6b, 0x65, 0x79, 0x73, 0x22, 0x75, 0x0a, 0x23, 0x41, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x38, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26,
	0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x22, 0x23, 0x0a, 0x21, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6c, 0x6c, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0xe8, 0x01, 0x0a, 0x22, 0x41, 0x70, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x41, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x24, 0x0a,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x10, 0x2e, 0x66, 0x6d,
	0x70, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x12, 0x32, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x38, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d,
	0x65, 0x22, 0x4c, 0x0a, 0x1a, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x22,
	0x90, 0x01, 0x0a, 0x1b, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x41, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b,
	0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x41,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69,
	0x6d, 0x65, 0x22, 0xa8, 0x01, 0x0a, 0x20, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x41, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x57, 0x0a, 0x11, 0x70, 0x61, 0x72, 0x74, 0x69,
	0x61, 0x6c, 0x5f, 0x65, 0x71, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x0f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x45, 0x71, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x12, 0x2b, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17,
	0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x73, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x22, 0xcb, 0x01,
	0x0a, 0x21, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x41, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x33, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x75,
	0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x62, 0x0a, 0x1d, 0x44,
	0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x61, 0x72,
	0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22,
	0x93, 0x01, 0x0a, 0x1e, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x41, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2b, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x66, 0x61, 0x75,
	0x6c, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x04, 0x74, 0x69, 0x6d, 0x65, 0x22, 0x8e, 0x01, 0x0a, 0x1a, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e,
	0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2e, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69,
	0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4b, 0x65,
	0x79, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x22, 0x90, 0x01, 0x0a, 0x1b, 0x44, 0x6f, 0x6d, 0x61, 0x69,
	0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x41, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x22, 0x94, 0x01, 0x0a, 0x1e, 0x44, 0x6f,
	0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04,
	0x6b, 0x65, 0x79, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x61, 0x72, 0x69,
	0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e,
	0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4b, 0x65, 0x79, 0x52, 0x04, 0x6b, 0x65, 0x79, 0x73,
	0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65,
	0x22, 0xc8, 0x01, 0x0a, 0x1f, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x41, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d,
	0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x32, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x2e, 0x0a, 0x04, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x22, 0xa8, 0x01, 0x0a, 0x20,
	0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x57, 0x0a, 0x11, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x65, 0x71, 0x5f, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x61, 0x72,
	0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x0f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61,
	0x6c, 0x45, 0x71, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x2b, 0x0a, 0x04, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61,
	0x2e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x73,
	0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x22, 0xcb, 0x01, 0x0a, 0x21, 0x44, 0x6f, 0x6d, 0x61, 0x69,
	0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x41, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x61, 0x72,
	0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12,
	0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x12,
	0x33, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e,
	0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x22, 0x74, 0x0a, 0x0d, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x33, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x21, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61,
	0x69, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x22, 0x76, 0x0a, 0x0e, 0x44, 0x6f,
	0x6d, 0x61, 0x69, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x34, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x61, 0x72,
	0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69,
	0x6d, 0x65, 0x22, 0x7a, 0x0a, 0x11, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x6f, 0x6d, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x35, 0x0a, 0x04, 0x6b, 0x65, 0x79, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x04, 0x6b, 0x65, 0x79, 0x73, 0x12, 0x2e,
	0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x22, 0xae,
	0x01, 0x0a, 0x12, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x34, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f,
	0x6d, 0x61, 0x69, 0x6e, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x32, 0x0a, 0x05, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72,
	0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12,
	0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x22,
	0x8e, 0x01, 0x0a, 0x13, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x11, 0x70, 0x61, 0x72, 0x74, 0x69,
	0x61, 0x6c, 0x5f, 0x65, 0x71, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61,
	0x69, 0x6e, 0x52, 0x0f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x45, 0x71, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x12, 0x2b, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x17, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x74, 0x69, 0x6d, 0x65, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x73, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65,
	0x22, 0xb1, 0x01, 0x0a, 0x14, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x34, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74,
	0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12,
	0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x12,
	0x33, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e,
	0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x22, 0x8a, 0x01, 0x0a, 0x1b, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x49,
	0x50, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x29, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69,
	0x6e, 0x49, 0x50, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x4b, 0x65, 0x79, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d,
	0x65, 0x22, 0x92, 0x01, 0x0a, 0x1c, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x49, 0x50, 0x50, 0x72,
	0x65, 0x66, 0x69, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x42, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2c, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69,
	0x6e, 0x49, 0x50, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x22, 0x90, 0x01, 0x0a, 0x1f, 0x44, 0x6f, 0x6d, 0x61, 0x69,
	0x6e, 0x49, 0x50, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53,
	0x6f, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6b, 0x65,
	0x79, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74,
	0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x49, 0x50, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78,
	0x4b, 0x65, 0x79, 0x52, 0x04, 0x6b, 0x65, 0x79, 0x73, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x22, 0xca, 0x01, 0x0a, 0x20, 0x44, 0x6f,
	0x6d, 0x61, 0x69, 0x6e, 0x49, 0x50, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x42,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e,
	0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x49, 0x50, 0x50,
	0x72, 0x65, 0x66, 0x69, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x32, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x22, 0xaa, 0x01, 0x0a, 0x21, 0x44, 0x6f, 0x6d, 0x61, 0x69,
	0x6e, 0x49, 0x50, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x58, 0x0a, 0x11,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x65, 0x71, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61,
	0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x49, 0x50, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x45, 0x71,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x2b, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x74, 0x69,
	0x6d, 0x65, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x73, 0x52, 0x04, 0x74,
	0x69, 0x6d, 0x65, 0x22, 0xcd, 0x01, 0x0a, 0x22, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x49, 0x50,
	0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x42, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x61, 0x72, 0x69, 0x73,
	0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x49, 0x50, 0x50, 0x72, 0x65, 0x66, 0x69,
	0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x2e,
	0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x33,
	0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x61,
	0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x22, 0x64, 0x0a, 0x1e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x49, 0x50, 0x50,
	0x72, 0x65, 0x66, 0x69, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f,
	0x6d, 0x61, 0x69, 0x6e, 0x49, 0x50, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x95, 0x01, 0x0a, 0x1f, 0x44, 0x6f,
	0x6d, 0x61, 0x69, 0x6e, 0x49, 0x50, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x53, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x42, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x61,
	0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x49, 0x50, 0x50, 0x72,
	0x65, 0x66, 0x69, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d,
	0x65, 0x22, 0x6a, 0x0a, 0x22, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x49, 0x50, 0x50, 0x72, 0x65,
	0x66, 0x69, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x53, 0x6f, 0x6d, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61,
	0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x49, 0x50, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x22, 0x78, 0x0a,
	0x23, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x49, 0x50, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3b, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x29, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69,
	0x6e, 0x49, 0x50, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x4b, 0x65, 0x79, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x22, 0x60, 0x0a, 0x21, 0x44, 0x6f, 0x6d, 0x61, 0x69,
	0x6e, 0x49, 0x50, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x61, 0x72, 0x69, 0x73,
	0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x49, 0x50, 0x50, 0x72, 0x65, 0x66, 0x69,
	0x78, 0x4b, 0x65, 0x79, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x22, 0x91, 0x01, 0x0a, 0x22, 0x44, 0x6f,
	0x6d, 0x61, 0x69, 0x6e, 0x49, 0x50, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x3b, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e,
	0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x49, 0x50, 0x50,
	0x72, 0x65, 0x66, 0x69, 0x78, 0x4b, 0x65, 0x79, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2e, 0x0a,
	0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x22, 0x66, 0x0a,
	0x25, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x49, 0x50, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x6f, 0x6d, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f,
	0x6d, 0x61, 0x69, 0x6e, 0x49, 0x50, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x4b, 0x65, 0x79, 0x52,
	0x04, 0x6b, 0x65, 0x79, 0x73, 0x22, 0x7b, 0x0a, 0x26, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x49,
	0x50, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x3b, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x61,
	0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x49, 0x50, 0x50, 0x72,
	0x65, 0x66, 0x69, 0x78, 0x4b, 0x65, 0x79, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x22, 0x26, 0x0a, 0x24, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x49, 0x50, 0x50, 0x72,
	0x65, 0x66, 0x69, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x41, 0x6c, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0xee, 0x01, 0x0a, 0x25, 0x44,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x49, 0x50, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x24, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x10, 0x2e, 0x66, 0x6d, 0x70, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45,
	0x72, 0x72, 0x6f, 0x72, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x32, 0x0a, 0x05, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x3b,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x61, 0x72,
	0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x49, 0x50, 0x50, 0x72, 0x65,
	0x66, 0x69, 0x78, 0x4b, 0x65, 0x79, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2e, 0x0a, 0x04, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x22, 0x88, 0x01, 0x0a, 0x1a,
	0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61,
	0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x4b, 0x65,
	0x79, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x22, 0x90, 0x01, 0x0a, 0x1b, 0x44, 0x6f, 0x6d, 0x61, 0x69,
	0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x41, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x22, 0x8e, 0x01, 0x0a, 0x1e, 0x44, 0x6f,
	0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04,
	0x6b, 0x65, 0x79, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x61, 0x72, 0x69,
	0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e,
	0x74, 0x4b, 0x65, 0x79, 0x52, 0x04, 0x6b, 0x65, 0x79, 0x73, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x22, 0xc8, 0x01, 0x0a, 0x1f, 0x44,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x41,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e,
	0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67,
	0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x12, 0x32, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x04, 0x74, 0x69, 0x6d, 0x65, 0x22, 0xa8, 0x01, 0x0a, 0x20, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e,
	0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x57, 0x0a, 0x11, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x65, 0x71, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x0f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x45, 0x71, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x12, 0x2b, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x17, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x74, 0x69, 0x6d, 0x65, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x73, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65,
	0x22, 0xcb, 0x01, 0x0a, 0x21, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x41, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x33, 0x0a, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61,
	0x2e, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x62,
	0x0a, 0x1d, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x41, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b,
	0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x22, 0x93, 0x01, 0x0a, 0x1e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67,
	0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x41, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f,
	0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x22, 0x68, 0x0a, 0x21, 0x44, 0x6f, 0x6d, 0x61,
	0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53,
	0x65, 0x74, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a,
	0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e,
	0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67,
	0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x73, 0x22, 0x76, 0x0a, 0x22, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x53, 0x6f, 0x6d, 0x65,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3a, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x4b, 0x65, 0x79, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x22, 0x5e, 0x0a, 0x20, 0x44, 0x6f,
	0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x61, 0x72,
	0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x4b, 0x65, 0x79, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x22, 0x8f, 0x01, 0x0a, 0x21, 0x44,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x3a, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e,
	0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67,
	0x6d, 0x65, 0x6e, 0x74, 0x4b, 0x65, 0x79, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2e, 0x0a, 0x04,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x22, 0x64, 0x0a, 0x24,
	0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x28, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61,
	0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x4b, 0x65, 0x79, 0x52, 0x04, 0x6b, 0x65,
	0x79, 0x73, 0x22, 0x79, 0x0a, 0x25, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53,
	0x6f, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3a, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74,
	0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x4b,
	0x65, 0x79, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x22, 0x25, 0x0a,
	0x23, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6c, 0x6c, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x22, 0xec, 0x01, 0x0a, 0x24, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x41, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x24, 0x0a,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x10, 0x2e, 0x66, 0x6d,
	0x70, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x12, 0x32, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x3a, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f,
	0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x4b, 0x65, 0x79, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74,
	0x69, 0x6d, 0x65, 0x22, 0x94, 0x01, 0x0a, 0x20, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x4b, 0x65, 0x79, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x22, 0x9c, 0x01, 0x0a, 0x21, 0x44,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x47, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x31, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x22, 0x9a, 0x01, 0x0a, 0x24, 0x44, 0x6f,
	0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2e, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e,
	0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4b, 0x65, 0x79,
	0x52, 0x04, 0x6b, 0x65, 0x79, 0x73, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x22, 0xd4, 0x01, 0x0a, 0x25, 0x44, 0x6f, 0x6d, 0x61, 0x69,
	0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x47, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x31, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x32, 0x0a, 0x05, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x2e, 0x0a,
	0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x22, 0xb4, 0x01,
	0x0a, 0x26, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5d, 0x0a, 0x11, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x61, 0x6c, 0x5f, 0x65, 0x71, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d,
	0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x45,
	0x71, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x2b, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x74,
	0x69, 0x6d, 0x65, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x73, 0x52, 0x04,
	0x74, 0x69, 0x6d, 0x65, 0x22, 0xd7, 0x01, 0x0a, 0x27, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x47, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x31, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x33, 0x0a, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61,
	0x2e, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x6e,
	0x0a, 0x23, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f,
	0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x9f,
	0x01, 0x0a, 0x24, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x47, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e,
	0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65,
	0x22, 0x74, 0x0a, 0x27, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e,
	0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74,
	0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x06, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x61, 0x72,
	0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x22, 0x82, 0x01, 0x0a, 0x28, 0x44, 0x6f, 0x6d, 0x61, 0x69,
	0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x40, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2e, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e,
	0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4b, 0x65, 0x79,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x22, 0x6a, 0x0a, 0x26, 0x44,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61,
	0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4b,
	0x65, 0x79, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x22, 0x9b, 0x01, 0x0a, 0x27, 0x44, 0x6f, 0x6d, 0x61,
	0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x40, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2e, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e,
	0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4b, 0x65, 0x79,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x04, 0x74, 0x69, 0x6d, 0x65, 0x22, 0x70, 0x0a, 0x2a, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2e, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69,
	0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4b, 0x65,
	0x79, 0x52, 0x04, 0x6b, 0x65, 0x79, 0x73, 0x22, 0x85, 0x01, 0x0a, 0x2b, 0x44, 0x6f, 0x6d, 0x61,
	0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x6f, 0x6d, 0x65, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x40, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f,
	0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x4b, 0x65, 0x79, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x22,
	0x2b, 0x0a, 0x29, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x41, 0x6c, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0xf8, 0x01, 0x0a,
	0x2a, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x41, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x24, 0x0a, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x10, 0x2e, 0x66, 0x6d, 0x70, 0x2e,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x12, 0x32, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x40, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61,
	0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4b,
	0x65, 0x79, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x22, 0x7a, 0x0a, 0x13, 0x44, 0x6f, 0x6d, 0x61, 0x69,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x33,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x61, 0x72,
	0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74,
	0x69, 0x6d, 0x65, 0x22, 0x82, 0x01, 0x0a, 0x14, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3a, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x61, 0x72,
	0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x22, 0x80, 0x01, 0x0a, 0x17, 0x44, 0x6f, 0x6d,
	0x61, 0x69, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x35, 0x0a, 0x04, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x21, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61,
	0x69, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x04, 0x6b, 0x65, 0x79, 0x73, 0x12, 0x2e, 0x0a, 0x04, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x22, 0xba, 0x01, 0x0a, 0x18,
	0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x6f, 0x6d, 0x65,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3a, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61,
	0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x12, 0x32, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x22, 0x9a, 0x01, 0x0a, 0x19, 0x44, 0x6f, 0x6d,
	0x61, 0x69, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x11, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61,
	0x6c, 0x5f, 0x65, 0x71, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x24, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c,
	0x45, 0x71, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x2b, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e,
	0x74, 0x69, 0x6d, 0x65, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x73, 0x52,
	0x04, 0x74, 0x69, 0x6d, 0x65, 0x22, 0xbd, 0x01, 0x0a, 0x1a, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3a, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d,
	0x61, 0x69, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65,
	0x12, 0x33, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1f,
	0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x54, 0x0a, 0x16, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3a, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24,
	0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x85, 0x01, 0x0a, 0x17,
	0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3a, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e,
	0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74,
	0x69, 0x6d, 0x65, 0x22, 0x5a, 0x0a, 0x1a, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x3c, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x24, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x22,
	0x68, 0x0a, 0x1b, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53,
	0x65, 0x74, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x33,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x61, 0x72,
	0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x22, 0x50, 0x0a, 0x19, 0x44, 0x6f, 0x6d,
	0x61, 0x69, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x33, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d,
	0x61, 0x69, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x22, 0x81, 0x01, 0x0a, 0x1a,
	0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x33, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61,
	0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x22,
	0x56, 0x0a, 0x1d, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x35, 0x0a, 0x04, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21,
	0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x4b, 0x65,
	0x79, 0x52, 0x04, 0x6b, 0x65, 0x79, 0x73, 0x22, 0x6b, 0x0a, 0x1e, 0x44, 0x6f, 0x6d, 0x61, 0x69,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x6f, 0x6d,
	0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x33, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e,
	0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x22, 0x1e, 0x0a, 0x1c, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6c, 0x6c, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x22, 0xde, 0x01, 0x0a, 0x1d, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6c, 0x6c, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x24, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x10, 0x2e, 0x66, 0x6d, 0x70, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x32, 0x0a, 0x05,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74,
	0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x12, 0x33, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e,
	0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x4b, 0x65, 0x79,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x04, 0x74, 0x69, 0x6d, 0x65, 0x22, 0x7a, 0x0a, 0x13, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x33, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x61, 0x72, 0x69, 0x73,
	0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4b, 0x65, 0x79, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d,
	0x65, 0x22, 0x82, 0x01, 0x0a, 0x14, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3a, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x61, 0x72, 0x69, 0x73,
	0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x22, 0x80, 0x01, 0x0a, 0x17, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x35, 0x0a, 0x04, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x21, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x4b, 0x65, 0x79, 0x52, 0x04, 0x6b, 0x65, 0x79, 0x73, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x22, 0xba, 0x01, 0x0a, 0x18, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3a, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x32, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x22, 0x9a, 0x01, 0x0a, 0x19, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x11, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x5f,
	0x65, 0x71, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x24, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x45, 0x71,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x2b, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x74, 0x69,
	0x6d, 0x65, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x73, 0x52, 0x04, 0x74,
	0x69, 0x6d, 0x65, 0x22, 0xbd, 0x01, 0x0a, 0x1a, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x3a, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x24, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x2e,
	0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x33,
	0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x61,
	0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x22, 0x54, 0x0a, 0x16, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x61,
	0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x85, 0x01, 0x0a, 0x17, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3a, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d,
	0x65, 0x22, 0x5a, 0x0a, 0x1a, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x53, 0x65, 0x74, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3c, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x24, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x22, 0x68, 0x0a,
	0x1b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74,
	0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x33, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x61, 0x72, 0x69, 0x73,
	0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4b, 0x65, 0x79, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x22, 0x50, 0x0a, 0x19, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x33, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x21, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x4b, 0x65, 0x79, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x22, 0x81, 0x01, 0x0a, 0x1a, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x33, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4b, 0x65, 0x79, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2e, 0x0a,
	0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x22, 0x56, 0x0a,
	0x1d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x35,
	0x0a, 0x04, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x61,
	0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4b, 0x65, 0x79, 0x52,
	0x04, 0x6b, 0x65, 0x79, 0x73, 0x22, 0x6b, 0x0a, 0x1e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x6f, 0x6d, 0x65, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x33, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x4b, 0x65, 0x79, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x22, 0x1e, 0x0a, 0x1c, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6c, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x22, 0xde, 0x01, 0x0a, 0x1d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x24, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x10, 0x2e, 0x66, 0x6d, 0x70, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45,
	0x72, 0x72, 0x6f, 0x72, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x32, 0x0a, 0x05, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x33,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x61, 0x72,
	0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4b, 0x65, 0x79, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74,
	0x69, 0x6d, 0x65, 0x32, 0xd8, 0x0a, 0x0a, 0x18, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x12, 0x6d, 0x0a, 0x06, 0x47, 0x65, 0x74, 0x4f, 0x6e, 0x65, 0x12, 0x30, 0x2e, 0x61, 0x72, 0x69,
	0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x61,
	0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x78, 0x0a, 0x07, 0x47, 0x65, 0x74, 0x53, 0x6f, 0x6d, 0x65, 0x12, 0x34, 0x2e, 0x61, 0x72, 0x69,
	0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x35, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x6f, 0x6d, 0x65, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x30, 0x01, 0x12, 0x7b, 0x0a, 0x06, 0x47, 0x65, 0x74,
	0x41, 0x6c, 0x6c, 0x12, 0x36, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x61, 0x72,
	0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x30, 0x01, 0x12, 0x7e, 0x0a, 0x09, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72,
	0x69, 0x62, 0x65, 0x12, 0x36, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x61, 0x72,
	0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x30, 0x01, 0x12, 0x67, 0x0a, 0x07, 0x47, 0x65, 0x74, 0x4d, 0x65, 0x74,
	0x61, 0x12, 0x36, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x61, 0x72, 0x69, 0x73,
	0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x6f, 0x0a, 0x0d, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x4d, 0x65, 0x74, 0x61,
	0x12, 0x36, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74,
	0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x30, 0x01,
	0x12, 0x70, 0x0a, 0x03, 0x53, 0x65, 0x74, 0x12, 0x33, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61,
	0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x61,
	0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x7e, 0x0a, 0x07, 0x53, 0x65, 0x74, 0x53, 0x6f, 0x6d, 0x65, 0x12, 0x37, 0x2e,
	0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x53, 0x6f, 0x6d, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e,
	0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x53, 0x65, 0x74, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x30, 0x01, 0x12, 0x79, 0x0a, 0x06, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x12, 0x36, 0x2e, 0x61,
	0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x87, 0x01,
	0x0a, 0x0a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x6f, 0x6d, 0x65, 0x12, 0x3a, 0x2e, 0x61,
	0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x6f, 0x6d,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3b, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74,
	0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x30, 0x01, 0x12, 0x84, 0x01, 0x0a, 0x09, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x41, 0x6c, 0x6c, 0x12, 0x39, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6c, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x3a, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x41, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x30, 0x01, 0x32, 0xfe,
	0x04, 0x0a, 0x1a, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x71, 0x0a,
	0x06, 0x47, 0x65, 0x74, 0x4f, 0x6e, 0x65, 0x12, 0x32, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61,
	0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x61, 0x72,
	0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x7f, 0x0a, 0x06, 0x47, 0x65, 0x74, 0x41, 0x6c, 0x6c, 0x12, 0x38, 0x2e, 0x61, 0x72, 0x69,
	0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65,
	0x66, 0x61, 0x75, 0x6c, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x30,
	0x01, 0x12, 0x82, 0x01, 0x0a, 0x09, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x12,
	0x38, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x61, 0x72, 0x69, 0x73,
	0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x30, 0x01, 0x12, 0x71, 0x0a, 0x0d, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72,
	0x69, 0x62, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x12, 0x38, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61,
	0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x24, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x30, 0x01, 0x12, 0x74, 0x0a, 0x03, 0x53, 0x65, 0x74,
	0x12, 0x35, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c,
	0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61,
	0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x32,
	0xf1, 0x05, 0x0a, 0x1a, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e,
	0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x71,
	0x0a, 0x06, 0x47, 0x65, 0x74, 0x4f, 0x6e, 0x65, 0x12, 0x32, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74,
	0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x61,
	0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x7c, 0x0a, 0x07, 0x47, 0x65, 0x74, 0x53, 0x6f, 0x6d, 0x65, 0x12, 0x36, 0x2e, 0x61,
	0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f,
	0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x30, 0x01, 0x12,
	0x7f, 0x0a, 0x06, 0x47, 0x65, 0x74, 0x41, 0x6c, 0x6c, 0x12, 0x38, 0x2e, 0x61, 0x72, 0x69, 0x73,
	0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d,
	0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x30, 0x01,
	0x12, 0x82, 0x01, 0x0a, 0x09, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x12, 0x38,
	0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74,
	0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x30, 0x01, 0x12, 0x69, 0x0a, 0x07, 0x47, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61,
	0x12, 0x38, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e,
	0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x61, 0x72, 0x69,
	0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x71, 0x0a, 0x0d, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x4d, 0x65, 0x74,
	0x61, 0x12, 0x38, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69,
	0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x61, 0x72,
	0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x30, 0x01, 0x32, 0xe1, 0x04, 0x0a, 0x0d, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x57, 0x0a, 0x06, 0x47, 0x65, 0x74, 0x4f, 0x6e, 0x65, 0x12,
	0x25, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e,
	0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x62,
	0x0a, 0x07, 0x47, 0x65, 0x74, 0x53, 0x6f, 0x6d, 0x65, 0x12, 0x29, 0x2e, 0x61, 0x72, 0x69, 0x73,
	0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f,
	0x6d, 0x61, 0x69, 0x6e, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x30, 0x01, 0x12, 0x65, 0x0a, 0x06, 0x47, 0x65, 0x74, 0x41, 0x6c, 0x6c, 0x12, 0x2b, 0x2e, 0x61,
	0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x61, 0x72, 0x69, 0x73,
	0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x30, 0x01, 0x12, 0x68, 0x0a, 0x09, 0x53, 0x75, 0x62,
	0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x12, 0x2b, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e,
	0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d,
	0x61, 0x69, 0x6e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x30, 0x01, 0x12, 0x5c, 0x0a, 0x07, 0x47, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x12, 0x2b,
	0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x61, 0x72,
	0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x64, 0x0a, 0x0d, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x4d, 0x65,
	0x74, 0x61, 0x12, 0x2b, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61,
	0x69, 0x6e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x24, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x30, 0x01, 0x32, 0x9a, 0x0b, 0x0a, 0x1b, 0x44, 0x6f, 0x6d, 0x61,
	0x69, 0x6e, 0x49, 0x50, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x73, 0x0a, 0x06, 0x47, 0x65, 0x74, 0x4f, 0x6e,
	0x65, 0x12, 0x33, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69,
	0x6e, 0x49, 0x50, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e,
	0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x49, 0x50, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x7e, 0x0a, 0x07,
	0x47, 0x65, 0x74, 0x53, 0x6f, 0x6d, 0x65, 0x12, 0x37, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61,
	0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x49, 0x50, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x38, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e,
	0x49, 0x50, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x6f,
	0x6d, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x30, 0x01, 0x12, 0x81, 0x01, 0x0a,
	0x06, 0x47, 0x65, 0x74, 0x41, 0x6c, 0x6c, 0x12, 0x39, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61,
	0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x49, 0x50, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61,
	0x69, 0x6e, 0x49, 0x50, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x30, 0x01,
	0x12, 0x84, 0x01, 0x0a, 0x09, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x12, 0x39,
	0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x49, 0x50,
	0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x61, 0x72, 0x69, 0x73,
	0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x49, 0x50, 0x50, 0x72, 0x65, 0x66, 0x69,
	0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x30, 0x01, 0x12, 0x6a, 0x0a, 0x07, 0x47, 0x65, 0x74, 0x4d, 0x65,
	0x74, 0x61, 0x12, 0x39, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61,
	0x69, 0x6e, 0x49, 0x50, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e,
	0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x72, 0x0a, 0x0d, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65,
	0x4d, 0x65, 0x74, 0x61, 0x12, 0x39, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f,
	0x6d, 0x61, 0x69, 0x6e, 0x49, 0x50, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x24, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x30, 0x01, 0x12, 0x76, 0x0a, 0x03, 0x53, 0x65, 0x74, 0x12, 0x36,
	0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x49, 0x50,
	0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e,
	0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x49, 0x50, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x84, 0x01, 0x0a, 0x07, 0x53, 0x65, 0x74, 0x53, 0x6f, 0x6d, 0x65, 0x12, 0x3a, 0x2e, 0x61, 0x72,
	0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x49, 0x50, 0x50, 0x72, 0x65,
	0x66, 0x69, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x53, 0x6f, 0x6d, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3b, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61,
	0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x49, 0x50, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x30, 0x01, 0x12, 0x7f, 0x0a, 0x06, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x12, 0x39, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e,
	0x49, 0x50, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x61, 0x72,
	0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x49, 0x50, 0x50, 0x72, 0x65,
	0x66, 0x69, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x8d, 0x01, 0x0a, 0x0a, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x53, 0x6f, 0x6d, 0x65, 0x12, 0x3d, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e,
	0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x49, 0x50, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3e, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x49, 0x50, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x30, 0x01, 0x12, 0x8a, 0x01, 0x0a, 0x09, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x41, 0x6c, 0x6c, 0x12, 0x3c, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x49, 0x50, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6c, 0x6c, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d,
	0x61, 0x69, 0x6e, 0x49, 0x50, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x30, 0x01, 0x32, 0x84, 0x0b, 0x0a, 0x1a, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x12, 0x71, 0x0a, 0x06, 0x47, 0x65, 0x74, 0x4f, 0x6e, 0x65, 0x12, 0x32, 0x2e,
	0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67,
	0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x33, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69,
	0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x7c, 0x0a, 0x07, 0x47, 0x65, 0x74, 0x53, 0x6f, 0x6d,
	0x65, 0x12, 0x36, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69,
	0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x6f,
	0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x61, 0x72, 0x69, 0x73,
	0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x30, 0x01, 0x12, 0x7f, 0x0a, 0x06, 0x47, 0x65, 0x74, 0x41, 0x6c, 0x6c, 0x12, 0x38,
	0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74,
	0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x30, 0x01, 0x12, 0x82, 0x01, 0x0a, 0x09, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72,
	0x69, 0x62, 0x65, 0x12, 0x38, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d,
	0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e,
	0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67,
	0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x30, 0x01, 0x12, 0x69, 0x0a, 0x07, 0x47, 0x65,
	0x74, 0x4d, 0x65, 0x74, 0x61, 0x12, 0x38, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x24, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x71, 0x0a, 0x0d, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69,
	0x62, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x12, 0x38, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e,
	0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x24, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x30, 0x01, 0x12, 0x74, 0x0a, 0x03, 0x53, 0x65, 0x74, 0x12,
	0x35, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e,
	0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x82,
	0x01, 0x0a, 0x07, 0x53, 0x65, 0x74, 0x53, 0x6f, 0x6d, 0x65, 0x12, 0x39, 0x2e, 0x61, 0x72, 0x69,
	0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x53, 0x65, 0x74, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x30, 0x01, 0x12, 0x7d, 0x0a, 0x06, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x12, 0x38, 0x2e,
	0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67,
	0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61,
	0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x8b, 0x01, 0x0a, 0x0a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x6f, 0x6d,
	0x65, 0x12, 0x3c, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69,
	0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x3d, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x30, 0x01,
	0x12, 0x88, 0x01, 0x0a, 0x09, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6c, 0x6c, 0x12, 0x3b,
	0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x41, 0x6c, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3c, 0x2e, 0x61, 0x72,
	0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6c,
	0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x30, 0x01, 0x32, 0x86, 0x0c, 0x0a, 0x20,
	0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x12, 0x7d, 0x0a, 0x06, 0x47, 0x65, 0x74, 0x4f, 0x6e, 0x65, 0x12, 0x38, 0x2e, 0x61, 0x72, 0x69,
	0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e,
	0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f,
	0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x88, 0x01, 0x0a, 0x07, 0x47, 0x65, 0x74, 0x53, 0x6f, 0x6d, 0x65, 0x12, 0x3c, 0x2e, 0x61, 0x72,
	0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x6f,
	0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e, 0x61, 0x72, 0x69, 0x73,
	0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x6f, 0x6d, 0x65,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x30, 0x01, 0x12, 0x8b, 0x01, 0x0a, 0x06, 0x47,
	0x65, 0x74, 0x41, 0x6c, 0x6c, 0x12, 0x3e, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3f, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x30, 0x01, 0x12, 0x8e, 0x01, 0x0a, 0x09, 0x53, 0x75, 0x62,
	0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x12, 0x3e, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e,
	0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3f, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e,
	0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x30, 0x01, 0x12, 0x6f, 0x0a, 0x07, 0x47, 0x65, 0x74,
	0x4d, 0x65, 0x74, 0x61, 0x12, 0x3e, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f,
	0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65,
	0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x77, 0x0a, 0x0d, 0x53, 0x75,
	0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x12, 0x3e, 0x2e, 0x61, 0x72,
	0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x61, 0x72,
	0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x30, 0x01, 0x12, 0x80, 0x01, 0x0a, 0x03, 0x53, 0x65, 0x74, 0x12, 0x3b, 0x2e, 0x61, 0x72,
	0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3c, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74,
	0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x8e, 0x01, 0x0a, 0x07, 0x53, 0x65, 0x74, 0x53, 0x6f,
	0x6d, 0x65, 0x12, 0x3f, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61,
	0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x40, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d,
	0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x30, 0x01, 0x12, 0x89, 0x01, 0x0a, 0x06, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x12, 0x3e, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61,
	0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x3f, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61,
	0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x97, 0x01, 0x0a, 0x0a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x6f,
	0x6d, 0x65, 0x12, 0x42, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61,
	0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x6f, 0x6d, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x43, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e,
	0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53,
	0x6f, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x30, 0x01, 0x12, 0x94, 0x01,
	0x0a, 0x09, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6c, 0x6c, 0x12, 0x41, 0x2e, 0x61, 0x72,
	0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x41, 0x6c, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x42,
	0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x30, 0x01, 0x32, 0xed, 0x09, 0x0a, 0x13, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x63, 0x0a, 0x06,
	0x47, 0x65, 0x74, 0x4f, 0x6e, 0x65, 0x12, 0x2b, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e,
	0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d,
	0x61, 0x69, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x6e, 0x0a, 0x07, 0x47, 0x65, 0x74, 0x53, 0x6f, 0x6d, 0x65, 0x12, 0x2f, 0x2e, 0x61,
	0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e,
	0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x30,
	0x01, 0x12, 0x71, 0x0a, 0x06, 0x47, 0x65, 0x74, 0x41, 0x6c, 0x6c, 0x12, 0x31, 0x2e, 0x61, 0x72,
	0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32,
	0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x30, 0x01, 0x12, 0x74, 0x0a, 0x09, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62,
	0x65, 0x12, 0x31, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f,
	0x6d, 0x61, 0x69, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x30, 0x01, 0x12, 0x62, 0x0a, 0x07, 0x47, 0x65,
	0x74, 0x4d, 0x65, 0x74, 0x61, 0x12, 0x31, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74,
	0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x6a,
	0x0a, 0x0d, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x12,
	0x31, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x24, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x30, 0x01, 0x12, 0x66, 0x0a, 0x03, 0x53, 0x65,
	0x74, 0x12, 0x2e, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2f, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x74, 0x0a, 0x07, 0x53, 0x65, 0x74, 0x53, 0x6f, 0x6d, 0x65, 0x12, 0x32, 0x2e,
	0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x33, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x30, 0x01, 0x12, 0x6f, 0x0a, 0x06, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x12, 0x31, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61,
	0x69, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x7d, 0x0a, 0x0a, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x53, 0x6f, 0x6d, 0x65, 0x12, 0x35, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61,
	0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36,
	0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x30, 0x01, 0x12, 0x7a, 0x0a, 0x09, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x41, 0x6c, 0x6c, 0x12, 0x34, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x41, 0x6c, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x61, 0x72,
	0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x30, 0x01, 0x32, 0xed, 0x09, 0x0a, 0x13, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x63, 0x0a, 0x06,
	0x47, 0x65, 0x74, 0x4f, 0x6e, 0x65, 0x12, 0x2b, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e,
	0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x6e, 0x0a, 0x07, 0x47, 0x65, 0x74, 0x53, 0x6f, 0x6d, 0x65, 0x12, 0x2f, 0x2e, 0x61,
	0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e,
	0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x30,
	0x01, 0x12, 0x71, 0x0a, 0x06, 0x47, 0x65, 0x74, 0x41, 0x6c, 0x6c, 0x12, 0x31, 0x2e, 0x61, 0x72,
	0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32,
	0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x30, 0x01, 0x12, 0x74, 0x0a, 0x09, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62,
	0x65, 0x12, 0x31, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x30, 0x01, 0x12, 0x62, 0x0a, 0x07, 0x47, 0x65,
	0x74, 0x4d, 0x65, 0x74, 0x61, 0x12, 0x31, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74,
	0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x6a,
	0x0a, 0x0d, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x12,
	0x31, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x24, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x30, 0x01, 0x12, 0x66, 0x0a, 0x03, 0x53, 0x65,
	0x74, 0x12, 0x2e, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2f, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x74, 0x0a, 0x07, 0x53, 0x65, 0x74, 0x53, 0x6f, 0x6d, 0x65, 0x12, 0x32, 0x2e,
	0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x33, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x30, 0x01, 0x12, 0x6f, 0x0a, 0x06, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x12, 0x31, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x7d, 0x0a, 0x0a, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x53, 0x6f, 0x6d, 0x65, 0x12, 0x35, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61,
	0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36,
	0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x6f, 0x6d, 0x65, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x30, 0x01, 0x12, 0x7a, 0x0a, 0x09, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x41, 0x6c, 0x6c, 0x12, 0x34, 0x2e, 0x61, 0x72, 0x69, 0x73, 0x74, 0x61, 0x2e, 0x73,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x41, 0x6c, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x61, 0x72,
	0x69, 0x73, 0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x30, 0x01, 0x42, 0x6a, 0x0a, 0x1a, 0x63, 0x6f, 0x6d, 0x2e, 0x61, 0x72, 0x69, 0x73,
	0x74, 0x61, 0x2e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x42, 0x14, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x50, 0x01, 0x5a, 0x34, 0x61, 0x72, 0x69, 0x73,
	0x74, 0x61, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x61, 0x72, 0x69,
	0x73, 0x74, 0x61, 0x2f, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x3b, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_arista_segmentation_v1_services_gen_proto_rawDescOnce sync.Once
	file_arista_segmentation_v1_services_gen_proto_rawDescData = file_arista_segmentation_v1_services_gen_proto_rawDesc
)

func file_arista_segmentation_v1_services_gen_proto_rawDescGZIP() []byte {
	file_arista_segmentation_v1_services_gen_proto_rawDescOnce.Do(func() {
		file_arista_segmentation_v1_services_gen_proto_rawDescData = protoimpl.X.CompressGZIP(file_arista_segmentation_v1_services_gen_proto_rawDescData)
	})
	return file_arista_segmentation_v1_services_gen_proto_rawDescData
}

var file_arista_segmentation_v1_services_gen_proto_msgTypes = make([]protoimpl.MessageInfo, 115)
var file_arista_segmentation_v1_services_gen_proto_goTypes = []interface{}{
	(*MetaResponse)(nil),                                // 0: arista.segmentation.v1.MetaResponse
	(*ApplicationConfigRequest)(nil),                    // 1: arista.segmentation.v1.ApplicationConfigRequest
	(*ApplicationConfigResponse)(nil),                   // 2: arista.segmentation.v1.ApplicationConfigResponse
	(*ApplicationConfigSomeRequest)(nil),                // 3: arista.segmentation.v1.ApplicationConfigSomeRequest
	(*ApplicationConfigSomeResponse)(nil),               // 4: arista.segmentation.v1.ApplicationConfigSomeResponse
	(*ApplicationConfigStreamRequest)(nil),              // 5: arista.segmentation.v1.ApplicationConfigStreamRequest
	(*ApplicationConfigStreamResponse)(nil),             // 6: arista.segmentation.v1.ApplicationConfigStreamResponse
	(*ApplicationConfigSetRequest)(nil),                 // 7: arista.segmentation.v1.ApplicationConfigSetRequest
	(*ApplicationConfigSetResponse)(nil),                // 8: arista.segmentation.v1.ApplicationConfigSetResponse
	(*ApplicationConfigSetSomeRequest)(nil),             // 9: arista.segmentation.v1.ApplicationConfigSetSomeRequest
	(*ApplicationConfigSetSomeResponse)(nil),            // 10: arista.segmentation.v1.ApplicationConfigSetSomeResponse
	(*ApplicationConfigDeleteRequest)(nil),              // 11: arista.segmentation.v1.ApplicationConfigDeleteRequest
	(*ApplicationConfigDeleteResponse)(nil),             // 12: arista.segmentation.v1.ApplicationConfigDeleteResponse
	(*ApplicationConfigDeleteSomeRequest)(nil),          // 13: arista.segmentation.v1.ApplicationConfigDeleteSomeRequest
	(*ApplicationConfigDeleteSomeResponse)(nil),         // 14: arista.segmentation.v1.ApplicationConfigDeleteSomeResponse
	(*ApplicationConfigDeleteAllRequest)(nil),           // 15: arista.segmentation.v1.ApplicationConfigDeleteAllRequest
	(*ApplicationConfigDeleteAllResponse)(nil),          // 16: arista.segmentation.v1.ApplicationConfigDeleteAllResponse
	(*DefaultActionConfigRequest)(nil),                  // 17: arista.segmentation.v1.DefaultActionConfigRequest
	(*DefaultActionConfigResponse)(nil),                 // 18: arista.segmentation.v1.DefaultActionConfigResponse
	(*DefaultActionConfigStreamRequest)(nil),            // 19: arista.segmentation.v1.DefaultActionConfigStreamRequest
	(*DefaultActionConfigStreamResponse)(nil),           // 20: arista.segmentation.v1.DefaultActionConfigStreamResponse
	(*DefaultActionConfigSetRequest)(nil),               // 21: arista.segmentation.v1.DefaultActionConfigSetRequest
	(*DefaultActionConfigSetResponse)(nil),              // 22: arista.segmentation.v1.DefaultActionConfigSetResponse
	(*DomainSegmentPolicyRequest)(nil),                  // 23: arista.segmentation.v1.DomainSegmentPolicyRequest
	(*DomainSegmentPolicyResponse)(nil),                 // 24: arista.segmentation.v1.DomainSegmentPolicyResponse
	(*DomainSegmentPolicySomeRequest)(nil),              // 25: arista.segmentation.v1.DomainSegmentPolicySomeRequest
	(*DomainSegmentPolicySomeResponse)(nil),             // 26: arista.segmentation.v1.DomainSegmentPolicySomeResponse
	(*DomainSegmentPolicyStreamRequest)(nil),            // 27: arista.segmentation.v1.DomainSegmentPolicyStreamRequest
	(*DomainSegmentPolicyStreamResponse)(nil),           // 28: arista.segmentation.v1.DomainSegmentPolicyStreamResponse
	(*DomainRequest)(nil),                               // 29: arista.segmentation.v1.DomainRequest
	(*DomainResponse)(nil),                              // 30: arista.segmentation.v1.DomainResponse
	(*DomainSomeRequest)(nil),                           // 31: arista.segmentation.v1.DomainSomeRequest
	(*DomainSomeResponse)(nil),                          // 32: arista.segmentation.v1.DomainSomeResponse
	(*DomainStreamRequest)(nil),                         // 33: arista.segmentation.v1.DomainStreamRequest
	(*DomainStreamResponse)(nil),                        // 34: arista.segmentation.v1.DomainStreamResponse
	(*DomainIPPrefixConfigRequest)(nil),                 // 35: arista.segmentation.v1.DomainIPPrefixConfigRequest
	(*DomainIPPrefixConfigResponse)(nil),                // 36: arista.segmentation.v1.DomainIPPrefixConfigResponse
	(*DomainIPPrefixConfigSomeRequest)(nil),             // 37: arista.segmentation.v1.DomainIPPrefixConfigSomeRequest
	(*DomainIPPrefixConfigSomeResponse)(nil),            // 38: arista.segmentation.v1.DomainIPPrefixConfigSomeResponse
	(*DomainIPPrefixConfigStreamRequest)(nil),           // 39: arista.segmentation.v1.DomainIPPrefixConfigStreamRequest
	(*DomainIPPrefixConfigStreamResponse)(nil),          // 40: arista.segmentation.v1.DomainIPPrefixConfigStreamResponse
	(*DomainIPPrefixConfigSetRequest)(nil),              // 41: arista.segmentation.v1.DomainIPPrefixConfigSetRequest
	(*DomainIPPrefixConfigSetResponse)(nil),             // 42: arista.segmentation.v1.DomainIPPrefixConfigSetResponse
	(*DomainIPPrefixConfigSetSomeRequest)(nil),          // 43: arista.segmentation.v1.DomainIPPrefixConfigSetSomeRequest
	(*DomainIPPrefixConfigSetSomeResponse)(nil),         // 44: arista.segmentation.v1.DomainIPPrefixConfigSetSomeResponse
	(*DomainIPPrefixConfigDeleteRequest)(nil),           // 45: arista.segmentation.v1.DomainIPPrefixConfigDeleteRequest
	(*DomainIPPrefixConfigDeleteResponse)(nil),          // 46: arista.segmentation.v1.DomainIPPrefixConfigDeleteResponse
	(*DomainIPPrefixConfigDeleteSomeRequest)(nil),       // 47: arista.segmentation.v1.DomainIPPrefixConfigDeleteSomeRequest
	(*DomainIPPrefixConfigDeleteSomeResponse)(nil),      // 48: arista.segmentation.v1.DomainIPPrefixConfigDeleteSomeResponse
	(*DomainIPPrefixConfigDeleteAllRequest)(nil),        // 49: arista.segmentation.v1.DomainIPPrefixConfigDeleteAllRequest
	(*DomainIPPrefixConfigDeleteAllResponse)(nil),       // 50: arista.segmentation.v1.DomainIPPrefixConfigDeleteAllResponse
	(*DomainSegmentConfigRequest)(nil),                  // 51: arista.segmentation.v1.DomainSegmentConfigRequest
	(*DomainSegmentConfigResponse)(nil),                 // 52: arista.segmentation.v1.DomainSegmentConfigResponse
	(*DomainSegmentConfigSomeRequest)(nil),              // 53: arista.segmentation.v1.DomainSegmentConfigSomeRequest
	(*DomainSegmentConfigSomeResponse)(nil),             // 54: arista.segmentation.v1.DomainSegmentConfigSomeResponse
	(*DomainSegmentConfigStreamRequest)(nil),            // 55: arista.segmentation.v1.DomainSegmentConfigStreamRequest
	(*DomainSegmentConfigStreamResponse)(nil),           // 56: arista.segmentation.v1.DomainSegmentConfigStreamResponse
	(*DomainSegmentConfigSetRequest)(nil),               // 57: arista.segmentation.v1.DomainSegmentConfigSetRequest
	(*DomainSegmentConfigSetResponse)(nil),              // 58: arista.segmentation.v1.DomainSegmentConfigSetResponse
	(*DomainSegmentConfigSetSomeRequest)(nil),           // 59: arista.segmentation.v1.DomainSegmentConfigSetSomeRequest
	(*DomainSegmentConfigSetSomeResponse)(nil),          // 60: arista.segmentation.v1.DomainSegmentConfigSetSomeResponse
	(*DomainSegmentConfigDeleteRequest)(nil),            // 61: arista.segmentation.v1.DomainSegmentConfigDeleteRequest
	(*DomainSegmentConfigDeleteResponse)(nil),           // 62: arista.segmentation.v1.DomainSegmentConfigDeleteResponse
	(*DomainSegmentConfigDeleteSomeRequest)(nil),        // 63: arista.segmentation.v1.DomainSegmentConfigDeleteSomeRequest
	(*DomainSegmentConfigDeleteSomeResponse)(nil),       // 64: arista.segmentation.v1.DomainSegmentConfigDeleteSomeResponse
	(*DomainSegmentConfigDeleteAllRequest)(nil),         // 65: arista.segmentation.v1.DomainSegmentConfigDeleteAllRequest
	(*DomainSegmentConfigDeleteAllResponse)(nil),        // 66: arista.segmentation.v1.DomainSegmentConfigDeleteAllResponse
	(*DomainSegmentPolicyConfigRequest)(nil),            // 67: arista.segmentation.v1.DomainSegmentPolicyConfigRequest
	(*DomainSegmentPolicyConfigResponse)(nil),           // 68: arista.segmentation.v1.DomainSegmentPolicyConfigResponse
	(*DomainSegmentPolicyConfigSomeRequest)(nil),        // 69: arista.segmentation.v1.DomainSegmentPolicyConfigSomeRequest
	(*DomainSegmentPolicyConfigSomeResponse)(nil),       // 70: arista.segmentation.v1.DomainSegmentPolicyConfigSomeResponse
	(*DomainSegmentPolicyConfigStreamRequest)(nil),      // 71: arista.segmentation.v1.DomainSegmentPolicyConfigStreamRequest
	(*DomainSegmentPolicyConfigStreamResponse)(nil),     // 72: arista.segmentation.v1.DomainSegmentPolicyConfigStreamResponse
	(*DomainSegmentPolicyConfigSetRequest)(nil),         // 73: arista.segmentation.v1.DomainSegmentPolicyConfigSetRequest
	(*DomainSegmentPolicyConfigSetResponse)(nil),        // 74: arista.segmentation.v1.DomainSegmentPolicyConfigSetResponse
	(*DomainSegmentPolicyConfigSetSomeRequest)(nil),     // 75: arista.segmentation.v1.DomainSegmentPolicyConfigSetSomeRequest
	(*DomainSegmentPolicyConfigSetSomeResponse)(nil),    // 76: arista.segmentation.v1.DomainSegmentPolicyConfigSetSomeResponse
	(*DomainSegmentPolicyConfigDeleteRequest)(nil),      // 77: arista.segmentation.v1.DomainSegmentPolicyConfigDeleteRequest
	(*DomainSegmentPolicyConfigDeleteResponse)(nil),     // 78: arista.segmentation.v1.DomainSegmentPolicyConfigDeleteResponse
	(*DomainSegmentPolicyConfigDeleteSomeRequest)(nil),  // 79: arista.segmentation.v1.DomainSegmentPolicyConfigDeleteSomeRequest
	(*DomainSegmentPolicyConfigDeleteSomeResponse)(nil), // 80: arista.segmentation.v1.DomainSegmentPolicyConfigDeleteSomeResponse
	(*DomainSegmentPolicyConfigDeleteAllRequest)(nil),   // 81: arista.segmentation.v1.DomainSegmentPolicyConfigDeleteAllRequest
	(*DomainSegmentPolicyConfigDeleteAllResponse)(nil),  // 82: arista.segmentation.v1.DomainSegmentPolicyConfigDeleteAllResponse
	(*DomainConfigRequest)(nil),                         // 83: arista.segmentation.v1.DomainConfigRequest
	(*DomainConfigResponse)(nil),                        // 84: arista.segmentation.v1.DomainConfigResponse
	(*DomainConfigSomeRequest)(nil),                     // 85: arista.segmentation.v1.DomainConfigSomeRequest
	(*DomainConfigSomeResponse)(nil),                    // 86: arista.segmentation.v1.DomainConfigSomeResponse
	(*DomainConfigStreamRequest)(nil),                   // 87: arista.segmentation.v1.DomainConfigStreamRequest
	(*DomainConfigStreamResponse)(nil),                  // 88: arista.segmentation.v1.DomainConfigStreamResponse
	(*DomainConfigSetRequest)(nil),                      // 89: arista.segmentation.v1.DomainConfigSetRequest
	(*DomainConfigSetResponse)(nil),                     // 90: arista.segmentation.v1.DomainConfigSetResponse
	(*DomainConfigSetSomeRequest)(nil),                  // 91: arista.segmentation.v1.DomainConfigSetSomeRequest
	(*DomainConfigSetSomeResponse)(nil),                 // 92: arista.segmentation.v1.DomainConfigSetSomeResponse
	(*DomainConfigDeleteRequest)(nil),                   // 93: arista.segmentation.v1.DomainConfigDeleteRequest
	(*DomainConfigDeleteResponse)(nil),                  // 94: arista.segmentation.v1.DomainConfigDeleteResponse
	(*DomainConfigDeleteSomeRequest)(nil),               // 95: arista.segmentation.v1.DomainConfigDeleteSomeRequest
	(*DomainConfigDeleteSomeResponse)(nil),              // 96: arista.segmentation.v1.DomainConfigDeleteSomeResponse
	(*DomainConfigDeleteAllRequest)(nil),                // 97: arista.segmentation.v1.DomainConfigDeleteAllRequest
	(*DomainConfigDeleteAllResponse)(nil),               // 98: arista.segmentation.v1.DomainConfigDeleteAllResponse
	(*PolicyConfigRequest)(nil),                         // 99: arista.segmentation.v1.PolicyConfigRequest
	(*PolicyConfigResponse)(nil),                        // 100: arista.segmentation.v1.PolicyConfigResponse
	(*PolicyConfigSomeRequest)(nil),                     // 101: arista.segmentation.v1.PolicyConfigSomeRequest
	(*PolicyConfigSomeResponse)(nil),                    // 102: arista.segmentation.v1.PolicyConfigSomeResponse
	(*PolicyConfigStreamRequest)(nil),                   // 103: arista.segmentation.v1.PolicyConfigStreamRequest
	(*PolicyConfigStreamResponse)(nil),                  // 104: arista.segmentation.v1.PolicyConfigStreamResponse
	(*PolicyConfigSetRequest)(nil),                      // 105: arista.segmentation.v1.PolicyConfigSetRequest
	(*PolicyConfigSetResponse)(nil),                     // 106: arista.segmentation.v1.PolicyConfigSetResponse
	(*PolicyConfigSetSomeRequest)(nil),                  // 107: arista.segmentation.v1.PolicyConfigSetSomeRequest
	(*PolicyConfigSetSomeResponse)(nil),                 // 108: arista.segmentation.v1.PolicyConfigSetSomeResponse
	(*PolicyConfigDeleteRequest)(nil),                   // 109: arista.segmentation.v1.PolicyConfigDeleteRequest
	(*PolicyConfigDeleteResponse)(nil),                  // 110: arista.segmentation.v1.PolicyConfigDeleteResponse
	(*PolicyConfigDeleteSomeRequest)(nil),               // 111: arista.segmentation.v1.PolicyConfigDeleteSomeRequest
	(*PolicyConfigDeleteSomeResponse)(nil),              // 112: arista.segmentation.v1.PolicyConfigDeleteSomeResponse
	(*PolicyConfigDeleteAllRequest)(nil),                // 113: arista.segmentation.v1.PolicyConfigDeleteAllRequest
	(*PolicyConfigDeleteAllResponse)(nil),               // 114: arista.segmentation.v1.PolicyConfigDeleteAllResponse
	(*timestamppb.Timestamp)(nil),                       // 115: google.protobuf.Timestamp
	(subscriptions.Operation)(0),                        // 116: arista.subscriptions.Operation
	(*wrapperspb.UInt32Value)(nil),                      // 117: google.protobuf.UInt32Value
	(*ApplicationKey)(nil),                              // 118: arista.segmentation.v1.ApplicationKey
	(*ApplicationConfig)(nil),                           // 119: arista.segmentation.v1.ApplicationConfig
	(*wrapperspb.StringValue)(nil),                      // 120: google.protobuf.StringValue
	(*time.TimeBounds)(nil),                             // 121: arista.time.TimeBounds
	(fmp.DeleteError)(0),                                // 122: fmp.DeleteError
	(*DefaultActionConfig)(nil),                         // 123: arista.segmentation.v1.DefaultActionConfig
	(*DomainSegmentPolicyKey)(nil),                      // 124: arista.segmentation.v1.DomainSegmentPolicyKey
	(*DomainSegmentPolicy)(nil),                         // 125: arista.segmentation.v1.DomainSegmentPolicy
	(*DomainKey)(nil),                                   // 126: arista.segmentation.v1.DomainKey
	(*Domain)(nil),                                      // 127: arista.segmentation.v1.Domain
	(*DomainIPPrefixKey)(nil),                           // 128: arista.segmentation.v1.DomainIPPrefixKey
	(*DomainIPPrefixConfig)(nil),                        // 129: arista.segmentation.v1.DomainIPPrefixConfig
	(*DomainSegmentKey)(nil),                            // 130: arista.segmentation.v1.DomainSegmentKey
	(*DomainSegmentConfig)(nil),                         // 131: arista.segmentation.v1.DomainSegmentConfig
	(*DomainSegmentPolicyConfig)(nil),                   // 132: arista.segmentation.v1.DomainSegmentPolicyConfig
	(*DomainConfig)(nil),                                // 133: arista.segmentation.v1.DomainConfig
	(*PolicyKey)(nil),                                   // 134: arista.segmentation.v1.PolicyKey
	(*PolicyConfig)(nil),                                // 135: arista.segmentation.v1.PolicyConfig
}
var file_arista_segmentation_v1_services_gen_proto_depIdxs = []int32{
	115, // 0: arista.segmentation.v1.MetaResponse.time:type_name -> google.protobuf.Timestamp
	116, // 1: arista.segmentation.v1.MetaResponse.type:type_name -> arista.subscriptions.Operation
	117, // 2: arista.segmentation.v1.MetaResponse.count:type_name -> google.protobuf.UInt32Value
	118, // 3: arista.segmentation.v1.ApplicationConfigRequest.key:type_name -> arista.segmentation.v1.ApplicationKey
	115, // 4: arista.segmentation.v1.ApplicationConfigRequest.time:type_name -> google.protobuf.Timestamp
	119, // 5: arista.segmentation.v1.ApplicationConfigResponse.value:type_name -> arista.segmentation.v1.ApplicationConfig
	115, // 6: arista.segmentation.v1.ApplicationConfigResponse.time:type_name -> google.protobuf.Timestamp
	118, // 7: arista.segmentation.v1.ApplicationConfigSomeRequest.keys:type_name -> arista.segmentation.v1.ApplicationKey
	115, // 8: arista.segmentation.v1.ApplicationConfigSomeRequest.time:type_name -> google.protobuf.Timestamp
	119, // 9: arista.segmentation.v1.ApplicationConfigSomeResponse.value:type_name -> arista.segmentation.v1.ApplicationConfig
	120, // 10: arista.segmentation.v1.ApplicationConfigSomeResponse.error:type_name -> google.protobuf.StringValue
	115, // 11: arista.segmentation.v1.ApplicationConfigSomeResponse.time:type_name -> google.protobuf.Timestamp
	119, // 12: arista.segmentation.v1.ApplicationConfigStreamRequest.partial_eq_filter:type_name -> arista.segmentation.v1.ApplicationConfig
	121, // 13: arista.segmentation.v1.ApplicationConfigStreamRequest.time:type_name -> arista.time.TimeBounds
	119, // 14: arista.segmentation.v1.ApplicationConfigStreamResponse.value:type_name -> arista.segmentation.v1.ApplicationConfig
	115, // 15: arista.segmentation.v1.ApplicationConfigStreamResponse.time:type_name -> google.protobuf.Timestamp
	116, // 16: arista.segmentation.v1.ApplicationConfigStreamResponse.type:type_name -> arista.subscriptions.Operation
	119, // 17: arista.segmentation.v1.ApplicationConfigSetRequest.value:type_name -> arista.segmentation.v1.ApplicationConfig
	119, // 18: arista.segmentation.v1.ApplicationConfigSetResponse.value:type_name -> arista.segmentation.v1.ApplicationConfig
	115, // 19: arista.segmentation.v1.ApplicationConfigSetResponse.time:type_name -> google.protobuf.Timestamp
	119, // 20: arista.segmentation.v1.ApplicationConfigSetSomeRequest.values:type_name -> arista.segmentation.v1.ApplicationConfig
	118, // 21: arista.segmentation.v1.ApplicationConfigSetSomeResponse.key:type_name -> arista.segmentation.v1.ApplicationKey
	118, // 22: arista.segmentation.v1.ApplicationConfigDeleteRequest.key:type_name -> arista.segmentation.v1.ApplicationKey
	118, // 23: arista.segmentation.v1.ApplicationConfigDeleteResponse.key:type_name -> arista.segmentation.v1.ApplicationKey
	115, // 24: arista.segmentation.v1.ApplicationConfigDeleteResponse.time:type_name -> google.protobuf.Timestamp
	118, // 25: arista.segmentation.v1.ApplicationConfigDeleteSomeRequest.keys:type_name -> arista.segmentation.v1.ApplicationKey
	118, // 26: arista.segmentation.v1.ApplicationConfigDeleteSomeResponse.key:type_name -> arista.segmentation.v1.ApplicationKey
	122, // 27: arista.segmentation.v1.ApplicationConfigDeleteAllResponse.type:type_name -> fmp.DeleteError
	120, // 28: arista.segmentation.v1.ApplicationConfigDeleteAllResponse.error:type_name -> google.protobuf.StringValue
	118, // 29: arista.segmentation.v1.ApplicationConfigDeleteAllResponse.key:type_name -> arista.segmentation.v1.ApplicationKey
	115, // 30: arista.segmentation.v1.ApplicationConfigDeleteAllResponse.time:type_name -> google.protobuf.Timestamp
	115, // 31: arista.segmentation.v1.DefaultActionConfigRequest.time:type_name -> google.protobuf.Timestamp
	123, // 32: arista.segmentation.v1.DefaultActionConfigResponse.value:type_name -> arista.segmentation.v1.DefaultActionConfig
	115, // 33: arista.segmentation.v1.DefaultActionConfigResponse.time:type_name -> google.protobuf.Timestamp
	123, // 34: arista.segmentation.v1.DefaultActionConfigStreamRequest.partial_eq_filter:type_name -> arista.segmentation.v1.DefaultActionConfig
	121, // 35: arista.segmentation.v1.DefaultActionConfigStreamRequest.time:type_name -> arista.time.TimeBounds
	123, // 36: arista.segmentation.v1.DefaultActionConfigStreamResponse.value:type_name -> arista.segmentation.v1.DefaultActionConfig
	115, // 37: arista.segmentation.v1.DefaultActionConfigStreamResponse.time:type_name -> google.protobuf.Timestamp
	116, // 38: arista.segmentation.v1.DefaultActionConfigStreamResponse.type:type_name -> arista.subscriptions.Operation
	123, // 39: arista.segmentation.v1.DefaultActionConfigSetRequest.value:type_name -> arista.segmentation.v1.DefaultActionConfig
	123, // 40: arista.segmentation.v1.DefaultActionConfigSetResponse.value:type_name -> arista.segmentation.v1.DefaultActionConfig
	115, // 41: arista.segmentation.v1.DefaultActionConfigSetResponse.time:type_name -> google.protobuf.Timestamp
	124, // 42: arista.segmentation.v1.DomainSegmentPolicyRequest.key:type_name -> arista.segmentation.v1.DomainSegmentPolicyKey
	115, // 43: arista.segmentation.v1.DomainSegmentPolicyRequest.time:type_name -> google.protobuf.Timestamp
	125, // 44: arista.segmentation.v1.DomainSegmentPolicyResponse.value:type_name -> arista.segmentation.v1.DomainSegmentPolicy
	115, // 45: arista.segmentation.v1.DomainSegmentPolicyResponse.time:type_name -> google.protobuf.Timestamp
	124, // 46: arista.segmentation.v1.DomainSegmentPolicySomeRequest.keys:type_name -> arista.segmentation.v1.DomainSegmentPolicyKey
	115, // 47: arista.segmentation.v1.DomainSegmentPolicySomeRequest.time:type_name -> google.protobuf.Timestamp
	125, // 48: arista.segmentation.v1.DomainSegmentPolicySomeResponse.value:type_name -> arista.segmentation.v1.DomainSegmentPolicy
	120, // 49: arista.segmentation.v1.DomainSegmentPolicySomeResponse.error:type_name -> google.protobuf.StringValue
	115, // 50: arista.segmentation.v1.DomainSegmentPolicySomeResponse.time:type_name -> google.protobuf.Timestamp
	125, // 51: arista.segmentation.v1.DomainSegmentPolicyStreamRequest.partial_eq_filter:type_name -> arista.segmentation.v1.DomainSegmentPolicy
	121, // 52: arista.segmentation.v1.DomainSegmentPolicyStreamRequest.time:type_name -> arista.time.TimeBounds
	125, // 53: arista.segmentation.v1.DomainSegmentPolicyStreamResponse.value:type_name -> arista.segmentation.v1.DomainSegmentPolicy
	115, // 54: arista.segmentation.v1.DomainSegmentPolicyStreamResponse.time:type_name -> google.protobuf.Timestamp
	116, // 55: arista.segmentation.v1.DomainSegmentPolicyStreamResponse.type:type_name -> arista.subscriptions.Operation
	126, // 56: arista.segmentation.v1.DomainRequest.key:type_name -> arista.segmentation.v1.DomainKey
	115, // 57: arista.segmentation.v1.DomainRequest.time:type_name -> google.protobuf.Timestamp
	127, // 58: arista.segmentation.v1.DomainResponse.value:type_name -> arista.segmentation.v1.Domain
	115, // 59: arista.segmentation.v1.DomainResponse.time:type_name -> google.protobuf.Timestamp
	126, // 60: arista.segmentation.v1.DomainSomeRequest.keys:type_name -> arista.segmentation.v1.DomainKey
	115, // 61: arista.segmentation.v1.DomainSomeRequest.time:type_name -> google.protobuf.Timestamp
	127, // 62: arista.segmentation.v1.DomainSomeResponse.value:type_name -> arista.segmentation.v1.Domain
	120, // 63: arista.segmentation.v1.DomainSomeResponse.error:type_name -> google.protobuf.StringValue
	115, // 64: arista.segmentation.v1.DomainSomeResponse.time:type_name -> google.protobuf.Timestamp
	127, // 65: arista.segmentation.v1.DomainStreamRequest.partial_eq_filter:type_name -> arista.segmentation.v1.Domain
	121, // 66: arista.segmentation.v1.DomainStreamRequest.time:type_name -> arista.time.TimeBounds
	127, // 67: arista.segmentation.v1.DomainStreamResponse.value:type_name -> arista.segmentation.v1.Domain
	115, // 68: arista.segmentation.v1.DomainStreamResponse.time:type_name -> google.protobuf.Timestamp
	116, // 69: arista.segmentation.v1.DomainStreamResponse.type:type_name -> arista.subscriptions.Operation
	128, // 70: arista.segmentation.v1.DomainIPPrefixConfigRequest.key:type_name -> arista.segmentation.v1.DomainIPPrefixKey
	115, // 71: arista.segmentation.v1.DomainIPPrefixConfigRequest.time:type_name -> google.protobuf.Timestamp
	129, // 72: arista.segmentation.v1.DomainIPPrefixConfigResponse.value:type_name -> arista.segmentation.v1.DomainIPPrefixConfig
	115, // 73: arista.segmentation.v1.DomainIPPrefixConfigResponse.time:type_name -> google.protobuf.Timestamp
	128, // 74: arista.segmentation.v1.DomainIPPrefixConfigSomeRequest.keys:type_name -> arista.segmentation.v1.DomainIPPrefixKey
	115, // 75: arista.segmentation.v1.DomainIPPrefixConfigSomeRequest.time:type_name -> google.protobuf.Timestamp
	129, // 76: arista.segmentation.v1.DomainIPPrefixConfigSomeResponse.value:type_name -> arista.segmentation.v1.DomainIPPrefixConfig
	120, // 77: arista.segmentation.v1.DomainIPPrefixConfigSomeResponse.error:type_name -> google.protobuf.StringValue
	115, // 78: arista.segmentation.v1.DomainIPPrefixConfigSomeResponse.time:type_name -> google.protobuf.Timestamp
	129, // 79: arista.segmentation.v1.DomainIPPrefixConfigStreamRequest.partial_eq_filter:type_name -> arista.segmentation.v1.DomainIPPrefixConfig
	121, // 80: arista.segmentation.v1.DomainIPPrefixConfigStreamRequest.time:type_name -> arista.time.TimeBounds
	129, // 81: arista.segmentation.v1.DomainIPPrefixConfigStreamResponse.value:type_name -> arista.segmentation.v1.DomainIPPrefixConfig
	115, // 82: arista.segmentation.v1.DomainIPPrefixConfigStreamResponse.time:type_name -> google.protobuf.Timestamp
	116, // 83: arista.segmentation.v1.DomainIPPrefixConfigStreamResponse.type:type_name -> arista.subscriptions.Operation
	129, // 84: arista.segmentation.v1.DomainIPPrefixConfigSetRequest.value:type_name -> arista.segmentation.v1.DomainIPPrefixConfig
	129, // 85: arista.segmentation.v1.DomainIPPrefixConfigSetResponse.value:type_name -> arista.segmentation.v1.DomainIPPrefixConfig
	115, // 86: arista.segmentation.v1.DomainIPPrefixConfigSetResponse.time:type_name -> google.protobuf.Timestamp
	129, // 87: arista.segmentation.v1.DomainIPPrefixConfigSetSomeRequest.values:type_name -> arista.segmentation.v1.DomainIPPrefixConfig
	128, // 88: arista.segmentation.v1.DomainIPPrefixConfigSetSomeResponse.key:type_name -> arista.segmentation.v1.DomainIPPrefixKey
	128, // 89: arista.segmentation.v1.DomainIPPrefixConfigDeleteRequest.key:type_name -> arista.segmentation.v1.DomainIPPrefixKey
	128, // 90: arista.segmentation.v1.DomainIPPrefixConfigDeleteResponse.key:type_name -> arista.segmentation.v1.DomainIPPrefixKey
	115, // 91: arista.segmentation.v1.DomainIPPrefixConfigDeleteResponse.time:type_name -> google.protobuf.Timestamp
	128, // 92: arista.segmentation.v1.DomainIPPrefixConfigDeleteSomeRequest.keys:type_name -> arista.segmentation.v1.DomainIPPrefixKey
	128, // 93: arista.segmentation.v1.DomainIPPrefixConfigDeleteSomeResponse.key:type_name -> arista.segmentation.v1.DomainIPPrefixKey
	122, // 94: arista.segmentation.v1.DomainIPPrefixConfigDeleteAllResponse.type:type_name -> fmp.DeleteError
	120, // 95: arista.segmentation.v1.DomainIPPrefixConfigDeleteAllResponse.error:type_name -> google.protobuf.StringValue
	128, // 96: arista.segmentation.v1.DomainIPPrefixConfigDeleteAllResponse.key:type_name -> arista.segmentation.v1.DomainIPPrefixKey
	115, // 97: arista.segmentation.v1.DomainIPPrefixConfigDeleteAllResponse.time:type_name -> google.protobuf.Timestamp
	130, // 98: arista.segmentation.v1.DomainSegmentConfigRequest.key:type_name -> arista.segmentation.v1.DomainSegmentKey
	115, // 99: arista.segmentation.v1.DomainSegmentConfigRequest.time:type_name -> google.protobuf.Timestamp
	131, // 100: arista.segmentation.v1.DomainSegmentConfigResponse.value:type_name -> arista.segmentation.v1.DomainSegmentConfig
	115, // 101: arista.segmentation.v1.DomainSegmentConfigResponse.time:type_name -> google.protobuf.Timestamp
	130, // 102: arista.segmentation.v1.DomainSegmentConfigSomeRequest.keys:type_name -> arista.segmentation.v1.DomainSegmentKey
	115, // 103: arista.segmentation.v1.DomainSegmentConfigSomeRequest.time:type_name -> google.protobuf.Timestamp
	131, // 104: arista.segmentation.v1.DomainSegmentConfigSomeResponse.value:type_name -> arista.segmentation.v1.DomainSegmentConfig
	120, // 105: arista.segmentation.v1.DomainSegmentConfigSomeResponse.error:type_name -> google.protobuf.StringValue
	115, // 106: arista.segmentation.v1.DomainSegmentConfigSomeResponse.time:type_name -> google.protobuf.Timestamp
	131, // 107: arista.segmentation.v1.DomainSegmentConfigStreamRequest.partial_eq_filter:type_name -> arista.segmentation.v1.DomainSegmentConfig
	121, // 108: arista.segmentation.v1.DomainSegmentConfigStreamRequest.time:type_name -> arista.time.TimeBounds
	131, // 109: arista.segmentation.v1.DomainSegmentConfigStreamResponse.value:type_name -> arista.segmentation.v1.DomainSegmentConfig
	115, // 110: arista.segmentation.v1.DomainSegmentConfigStreamResponse.time:type_name -> google.protobuf.Timestamp
	116, // 111: arista.segmentation.v1.DomainSegmentConfigStreamResponse.type:type_name -> arista.subscriptions.Operation
	131, // 112: arista.segmentation.v1.DomainSegmentConfigSetRequest.value:type_name -> arista.segmentation.v1.DomainSegmentConfig
	131, // 113: arista.segmentation.v1.DomainSegmentConfigSetResponse.value:type_name -> arista.segmentation.v1.DomainSegmentConfig
	115, // 114: arista.segmentation.v1.DomainSegmentConfigSetResponse.time:type_name -> google.protobuf.Timestamp
	131, // 115: arista.segmentation.v1.DomainSegmentConfigSetSomeRequest.values:type_name -> arista.segmentation.v1.DomainSegmentConfig
	130, // 116: arista.segmentation.v1.DomainSegmentConfigSetSomeResponse.key:type_name -> arista.segmentation.v1.DomainSegmentKey
	130, // 117: arista.segmentation.v1.DomainSegmentConfigDeleteRequest.key:type_name -> arista.segmentation.v1.DomainSegmentKey
	130, // 118: arista.segmentation.v1.DomainSegmentConfigDeleteResponse.key:type_name -> arista.segmentation.v1.DomainSegmentKey
	115, // 119: arista.segmentation.v1.DomainSegmentConfigDeleteResponse.time:type_name -> google.protobuf.Timestamp
	130, // 120: arista.segmentation.v1.DomainSegmentConfigDeleteSomeRequest.keys:type_name -> arista.segmentation.v1.DomainSegmentKey
	130, // 121: arista.segmentation.v1.DomainSegmentConfigDeleteSomeResponse.key:type_name -> arista.segmentation.v1.DomainSegmentKey
	122, // 122: arista.segmentation.v1.DomainSegmentConfigDeleteAllResponse.type:type_name -> fmp.DeleteError
	120, // 123: arista.segmentation.v1.DomainSegmentConfigDeleteAllResponse.error:type_name -> google.protobuf.StringValue
	130, // 124: arista.segmentation.v1.DomainSegmentConfigDeleteAllResponse.key:type_name -> arista.segmentation.v1.DomainSegmentKey
	115, // 125: arista.segmentation.v1.DomainSegmentConfigDeleteAllResponse.time:type_name -> google.protobuf.Timestamp
	124, // 126: arista.segmentation.v1.DomainSegmentPolicyConfigRequest.key:type_name -> arista.segmentation.v1.DomainSegmentPolicyKey
	115, // 127: arista.segmentation.v1.DomainSegmentPolicyConfigRequest.time:type_name -> google.protobuf.Timestamp
	132, // 128: arista.segmentation.v1.DomainSegmentPolicyConfigResponse.value:type_name -> arista.segmentation.v1.DomainSegmentPolicyConfig
	115, // 129: arista.segmentation.v1.DomainSegmentPolicyConfigResponse.time:type_name -> google.protobuf.Timestamp
	124, // 130: arista.segmentation.v1.DomainSegmentPolicyConfigSomeRequest.keys:type_name -> arista.segmentation.v1.DomainSegmentPolicyKey
	115, // 131: arista.segmentation.v1.DomainSegmentPolicyConfigSomeRequest.time:type_name -> google.protobuf.Timestamp
	132, // 132: arista.segmentation.v1.DomainSegmentPolicyConfigSomeResponse.value:type_name -> arista.segmentation.v1.DomainSegmentPolicyConfig
	120, // 133: arista.segmentation.v1.DomainSegmentPolicyConfigSomeResponse.error:type_name -> google.protobuf.StringValue
	115, // 134: arista.segmentation.v1.DomainSegmentPolicyConfigSomeResponse.time:type_name -> google.protobuf.Timestamp
	132, // 135: arista.segmentation.v1.DomainSegmentPolicyConfigStreamRequest.partial_eq_filter:type_name -> arista.segmentation.v1.DomainSegmentPolicyConfig
	121, // 136: arista.segmentation.v1.DomainSegmentPolicyConfigStreamRequest.time:type_name -> arista.time.TimeBounds
	132, // 137: arista.segmentation.v1.DomainSegmentPolicyConfigStreamResponse.value:type_name -> arista.segmentation.v1.DomainSegmentPolicyConfig
	115, // 138: arista.segmentation.v1.DomainSegmentPolicyConfigStreamResponse.time:type_name -> google.protobuf.Timestamp
	116, // 139: arista.segmentation.v1.DomainSegmentPolicyConfigStreamResponse.type:type_name -> arista.subscriptions.Operation
	132, // 140: arista.segmentation.v1.DomainSegmentPolicyConfigSetRequest.value:type_name -> arista.segmentation.v1.DomainSegmentPolicyConfig
	132, // 141: arista.segmentation.v1.DomainSegmentPolicyConfigSetResponse.value:type_name -> arista.segmentation.v1.DomainSegmentPolicyConfig
	115, // 142: arista.segmentation.v1.DomainSegmentPolicyConfigSetResponse.time:type_name -> google.protobuf.Timestamp
	132, // 143: arista.segmentation.v1.DomainSegmentPolicyConfigSetSomeRequest.values:type_name -> arista.segmentation.v1.DomainSegmentPolicyConfig
	124, // 144: arista.segmentation.v1.DomainSegmentPolicyConfigSetSomeResponse.key:type_name -> arista.segmentation.v1.DomainSegmentPolicyKey
	124, // 145: arista.segmentation.v1.DomainSegmentPolicyConfigDeleteRequest.key:type_name -> arista.segmentation.v1.DomainSegmentPolicyKey
	124, // 146: arista.segmentation.v1.DomainSegmentPolicyConfigDeleteResponse.key:type_name -> arista.segmentation.v1.DomainSegmentPolicyKey
	115, // 147: arista.segmentation.v1.DomainSegmentPolicyConfigDeleteResponse.time:type_name -> google.protobuf.Timestamp
	124, // 148: arista.segmentation.v1.DomainSegmentPolicyConfigDeleteSomeRequest.keys:type_name -> arista.segmentation.v1.DomainSegmentPolicyKey
	124, // 149: arista.segmentation.v1.DomainSegmentPolicyConfigDeleteSomeResponse.key:type_name -> arista.segmentation.v1.DomainSegmentPolicyKey
	122, // 150: arista.segmentation.v1.DomainSegmentPolicyConfigDeleteAllResponse.type:type_name -> fmp.DeleteError
	120, // 151: arista.segmentation.v1.DomainSegmentPolicyConfigDeleteAllResponse.error:type_name -> google.protobuf.StringValue
	124, // 152: arista.segmentation.v1.DomainSegmentPolicyConfigDeleteAllResponse.key:type_name -> arista.segmentation.v1.DomainSegmentPolicyKey
	115, // 153: arista.segmentation.v1.DomainSegmentPolicyConfigDeleteAllResponse.time:type_name -> google.protobuf.Timestamp
	126, // 154: arista.segmentation.v1.DomainConfigRequest.key:type_name -> arista.segmentation.v1.DomainKey
	115, // 155: arista.segmentation.v1.DomainConfigRequest.time:type_name -> google.protobuf.Timestamp
	133, // 156: arista.segmentation.v1.DomainConfigResponse.value:type_name -> arista.segmentation.v1.DomainConfig
	115, // 157: arista.segmentation.v1.DomainConfigResponse.time:type_name -> google.protobuf.Timestamp
	126, // 158: arista.segmentation.v1.DomainConfigSomeRequest.keys:type_name -> arista.segmentation.v1.DomainKey
	115, // 159: arista.segmentation.v1.DomainConfigSomeRequest.time:type_name -> google.protobuf.Timestamp
	133, // 160: arista.segmentation.v1.DomainConfigSomeResponse.value:type_name -> arista.segmentation.v1.DomainConfig
	120, // 161: arista.segmentation.v1.DomainConfigSomeResponse.error:type_name -> google.protobuf.StringValue
	115, // 162: arista.segmentation.v1.DomainConfigSomeResponse.time:type_name -> google.protobuf.Timestamp
	133, // 163: arista.segmentation.v1.DomainConfigStreamRequest.partial_eq_filter:type_name -> arista.segmentation.v1.DomainConfig
	121, // 164: arista.segmentation.v1.DomainConfigStreamRequest.time:type_name -> arista.time.TimeBounds
	133, // 165: arista.segmentation.v1.DomainConfigStreamResponse.value:type_name -> arista.segmentation.v1.DomainConfig
	115, // 166: arista.segmentation.v1.DomainConfigStreamResponse.time:type_name -> google.protobuf.Timestamp
	116, // 167: arista.segmentation.v1.DomainConfigStreamResponse.type:type_name -> arista.subscriptions.Operation
	133, // 168: arista.segmentation.v1.DomainConfigSetRequest.value:type_name -> arista.segmentation.v1.DomainConfig
	133, // 169: arista.segmentation.v1.DomainConfigSetResponse.value:type_name -> arista.segmentation.v1.DomainConfig
	115, // 170: arista.segmentation.v1.DomainConfigSetResponse.time:type_name -> google.protobuf.Timestamp
	133, // 171: arista.segmentation.v1.DomainConfigSetSomeRequest.values:type_name -> arista.segmentation.v1.DomainConfig
	126, // 172: arista.segmentation.v1.DomainConfigSetSomeResponse.key:type_name -> arista.segmentation.v1.DomainKey
	126, // 173: arista.segmentation.v1.DomainConfigDeleteRequest.key:type_name -> arista.segmentation.v1.DomainKey
	126, // 174: arista.segmentation.v1.DomainConfigDeleteResponse.key:type_name -> arista.segmentation.v1.DomainKey
	115, // 175: arista.segmentation.v1.DomainConfigDeleteResponse.time:type_name -> google.protobuf.Timestamp
	126, // 176: arista.segmentation.v1.DomainConfigDeleteSomeRequest.keys:type_name -> arista.segmentation.v1.DomainKey
	126, // 177: arista.segmentation.v1.DomainConfigDeleteSomeResponse.key:type_name -> arista.segmentation.v1.DomainKey
	122, // 178: arista.segmentation.v1.DomainConfigDeleteAllResponse.type:type_name -> fmp.DeleteError
	120, // 179: arista.segmentation.v1.DomainConfigDeleteAllResponse.error:type_name -> google.protobuf.StringValue
	126, // 180: arista.segmentation.v1.DomainConfigDeleteAllResponse.key:type_name -> arista.segmentation.v1.DomainKey
	115, // 181: arista.segmentation.v1.DomainConfigDeleteAllResponse.time:type_name -> google.protobuf.Timestamp
	134, // 182: arista.segmentation.v1.PolicyConfigRequest.key:type_name -> arista.segmentation.v1.PolicyKey
	115, // 183: arista.segmentation.v1.PolicyConfigRequest.time:type_name -> google.protobuf.Timestamp
	135, // 184: arista.segmentation.v1.PolicyConfigResponse.value:type_name -> arista.segmentation.v1.PolicyConfig
	115, // 185: arista.segmentation.v1.PolicyConfigResponse.time:type_name -> google.protobuf.Timestamp
	134, // 186: arista.segmentation.v1.PolicyConfigSomeRequest.keys:type_name -> arista.segmentation.v1.PolicyKey
	115, // 187: arista.segmentation.v1.PolicyConfigSomeRequest.time:type_name -> google.protobuf.Timestamp
	135, // 188: arista.segmentation.v1.PolicyConfigSomeResponse.value:type_name -> arista.segmentation.v1.PolicyConfig
	120, // 189: arista.segmentation.v1.PolicyConfigSomeResponse.error:type_name -> google.protobuf.StringValue
	115, // 190: arista.segmentation.v1.PolicyConfigSomeResponse.time:type_name -> google.protobuf.Timestamp
	135, // 191: arista.segmentation.v1.PolicyConfigStreamRequest.partial_eq_filter:type_name -> arista.segmentation.v1.PolicyConfig
	121, // 192: arista.segmentation.v1.PolicyConfigStreamRequest.time:type_name -> arista.time.TimeBounds
	135, // 193: arista.segmentation.v1.PolicyConfigStreamResponse.value:type_name -> arista.segmentation.v1.PolicyConfig
	115, // 194: arista.segmentation.v1.PolicyConfigStreamResponse.time:type_name -> google.protobuf.Timestamp
	116, // 195: arista.segmentation.v1.PolicyConfigStreamResponse.type:type_name -> arista.subscriptions.Operation
	135, // 196: arista.segmentation.v1.PolicyConfigSetRequest.value:type_name -> arista.segmentation.v1.PolicyConfig
	135, // 197: arista.segmentation.v1.PolicyConfigSetResponse.value:type_name -> arista.segmentation.v1.PolicyConfig
	115, // 198: arista.segmentation.v1.PolicyConfigSetResponse.time:type_name -> google.protobuf.Timestamp
	135, // 199: arista.segmentation.v1.PolicyConfigSetSomeRequest.values:type_name -> arista.segmentation.v1.PolicyConfig
	134, // 200: arista.segmentation.v1.PolicyConfigSetSomeResponse.key:type_name -> arista.segmentation.v1.PolicyKey
	134, // 201: arista.segmentation.v1.PolicyConfigDeleteRequest.key:type_name -> arista.segmentation.v1.PolicyKey
	134, // 202: arista.segmentation.v1.PolicyConfigDeleteResponse.key:type_name -> arista.segmentation.v1.PolicyKey
	115, // 203: arista.segmentation.v1.PolicyConfigDeleteResponse.time:type_name -> google.protobuf.Timestamp
	134, // 204: arista.segmentation.v1.PolicyConfigDeleteSomeRequest.keys:type_name -> arista.segmentation.v1.PolicyKey
	134, // 205: arista.segmentation.v1.PolicyConfigDeleteSomeResponse.key:type_name -> arista.segmentation.v1.PolicyKey
	122, // 206: arista.segmentation.v1.PolicyConfigDeleteAllResponse.type:type_name -> fmp.DeleteError
	120, // 207: arista.segmentation.v1.PolicyConfigDeleteAllResponse.error:type_name -> google.protobuf.StringValue
	134, // 208: arista.segmentation.v1.PolicyConfigDeleteAllResponse.key:type_name -> arista.segmentation.v1.PolicyKey
	115, // 209: arista.segmentation.v1.PolicyConfigDeleteAllResponse.time:type_name -> google.protobuf.Timestamp
	1,   // 210: arista.segmentation.v1.ApplicationConfigService.GetOne:input_type -> arista.segmentation.v1.ApplicationConfigRequest
	3,   // 211: arista.segmentation.v1.ApplicationConfigService.GetSome:input_type -> arista.segmentation.v1.ApplicationConfigSomeRequest
	5,   // 212: arista.segmentation.v1.ApplicationConfigService.GetAll:input_type -> arista.segmentation.v1.ApplicationConfigStreamRequest
	5,   // 213: arista.segmentation.v1.ApplicationConfigService.Subscribe:input_type -> arista.segmentation.v1.ApplicationConfigStreamRequest
	5,   // 214: arista.segmentation.v1.ApplicationConfigService.GetMeta:input_type -> arista.segmentation.v1.ApplicationConfigStreamRequest
	5,   // 215: arista.segmentation.v1.ApplicationConfigService.SubscribeMeta:input_type -> arista.segmentation.v1.ApplicationConfigStreamRequest
	7,   // 216: arista.segmentation.v1.ApplicationConfigService.Set:input_type -> arista.segmentation.v1.ApplicationConfigSetRequest
	9,   // 217: arista.segmentation.v1.ApplicationConfigService.SetSome:input_type -> arista.segmentation.v1.ApplicationConfigSetSomeRequest
	11,  // 218: arista.segmentation.v1.ApplicationConfigService.Delete:input_type -> arista.segmentation.v1.ApplicationConfigDeleteRequest
	13,  // 219: arista.segmentation.v1.ApplicationConfigService.DeleteSome:input_type -> arista.segmentation.v1.ApplicationConfigDeleteSomeRequest
	15,  // 220: arista.segmentation.v1.ApplicationConfigService.DeleteAll:input_type -> arista.segmentation.v1.ApplicationConfigDeleteAllRequest
	17,  // 221: arista.segmentation.v1.DefaultActionConfigService.GetOne:input_type -> arista.segmentation.v1.DefaultActionConfigRequest
	19,  // 222: arista.segmentation.v1.DefaultActionConfigService.GetAll:input_type -> arista.segmentation.v1.DefaultActionConfigStreamRequest
	19,  // 223: arista.segmentation.v1.DefaultActionConfigService.Subscribe:input_type -> arista.segmentation.v1.DefaultActionConfigStreamRequest
	19,  // 224: arista.segmentation.v1.DefaultActionConfigService.SubscribeMeta:input_type -> arista.segmentation.v1.DefaultActionConfigStreamRequest
	21,  // 225: arista.segmentation.v1.DefaultActionConfigService.Set:input_type -> arista.segmentation.v1.DefaultActionConfigSetRequest
	23,  // 226: arista.segmentation.v1.DomainSegmentPolicyService.GetOne:input_type -> arista.segmentation.v1.DomainSegmentPolicyRequest
	25,  // 227: arista.segmentation.v1.DomainSegmentPolicyService.GetSome:input_type -> arista.segmentation.v1.DomainSegmentPolicySomeRequest
	27,  // 228: arista.segmentation.v1.DomainSegmentPolicyService.GetAll:input_type -> arista.segmentation.v1.DomainSegmentPolicyStreamRequest
	27,  // 229: arista.segmentation.v1.DomainSegmentPolicyService.Subscribe:input_type -> arista.segmentation.v1.DomainSegmentPolicyStreamRequest
	27,  // 230: arista.segmentation.v1.DomainSegmentPolicyService.GetMeta:input_type -> arista.segmentation.v1.DomainSegmentPolicyStreamRequest
	27,  // 231: arista.segmentation.v1.DomainSegmentPolicyService.SubscribeMeta:input_type -> arista.segmentation.v1.DomainSegmentPolicyStreamRequest
	29,  // 232: arista.segmentation.v1.DomainService.GetOne:input_type -> arista.segmentation.v1.DomainRequest
	31,  // 233: arista.segmentation.v1.DomainService.GetSome:input_type -> arista.segmentation.v1.DomainSomeRequest
	33,  // 234: arista.segmentation.v1.DomainService.GetAll:input_type -> arista.segmentation.v1.DomainStreamRequest
	33,  // 235: arista.segmentation.v1.DomainService.Subscribe:input_type -> arista.segmentation.v1.DomainStreamRequest
	33,  // 236: arista.segmentation.v1.DomainService.GetMeta:input_type -> arista.segmentation.v1.DomainStreamRequest
	33,  // 237: arista.segmentation.v1.DomainService.SubscribeMeta:input_type -> arista.segmentation.v1.DomainStreamRequest
	35,  // 238: arista.segmentation.v1.DomainIPPrefixConfigService.GetOne:input_type -> arista.segmentation.v1.DomainIPPrefixConfigRequest
	37,  // 239: arista.segmentation.v1.DomainIPPrefixConfigService.GetSome:input_type -> arista.segmentation.v1.DomainIPPrefixConfigSomeRequest
	39,  // 240: arista.segmentation.v1.DomainIPPrefixConfigService.GetAll:input_type -> arista.segmentation.v1.DomainIPPrefixConfigStreamRequest
	39,  // 241: arista.segmentation.v1.DomainIPPrefixConfigService.Subscribe:input_type -> arista.segmentation.v1.DomainIPPrefixConfigStreamRequest
	39,  // 242: arista.segmentation.v1.DomainIPPrefixConfigService.GetMeta:input_type -> arista.segmentation.v1.DomainIPPrefixConfigStreamRequest
	39,  // 243: arista.segmentation.v1.DomainIPPrefixConfigService.SubscribeMeta:input_type -> arista.segmentation.v1.DomainIPPrefixConfigStreamRequest
	41,  // 244: arista.segmentation.v1.DomainIPPrefixConfigService.Set:input_type -> arista.segmentation.v1.DomainIPPrefixConfigSetRequest
	43,  // 245: arista.segmentation.v1.DomainIPPrefixConfigService.SetSome:input_type -> arista.segmentation.v1.DomainIPPrefixConfigSetSomeRequest
	45,  // 246: arista.segmentation.v1.DomainIPPrefixConfigService.Delete:input_type -> arista.segmentation.v1.DomainIPPrefixConfigDeleteRequest
	47,  // 247: arista.segmentation.v1.DomainIPPrefixConfigService.DeleteSome:input_type -> arista.segmentation.v1.DomainIPPrefixConfigDeleteSomeRequest
	49,  // 248: arista.segmentation.v1.DomainIPPrefixConfigService.DeleteAll:input_type -> arista.segmentation.v1.DomainIPPrefixConfigDeleteAllRequest
	51,  // 249: arista.segmentation.v1.DomainSegmentConfigService.GetOne:input_type -> arista.segmentation.v1.DomainSegmentConfigRequest
	53,  // 250: arista.segmentation.v1.DomainSegmentConfigService.GetSome:input_type -> arista.segmentation.v1.DomainSegmentConfigSomeRequest
	55,  // 251: arista.segmentation.v1.DomainSegmentConfigService.GetAll:input_type -> arista.segmentation.v1.DomainSegmentConfigStreamRequest
	55,  // 252: arista.segmentation.v1.DomainSegmentConfigService.Subscribe:input_type -> arista.segmentation.v1.DomainSegmentConfigStreamRequest
	55,  // 253: arista.segmentation.v1.DomainSegmentConfigService.GetMeta:input_type -> arista.segmentation.v1.DomainSegmentConfigStreamRequest
	55,  // 254: arista.segmentation.v1.DomainSegmentConfigService.SubscribeMeta:input_type -> arista.segmentation.v1.DomainSegmentConfigStreamRequest
	57,  // 255: arista.segmentation.v1.DomainSegmentConfigService.Set:input_type -> arista.segmentation.v1.DomainSegmentConfigSetRequest
	59,  // 256: arista.segmentation.v1.DomainSegmentConfigService.SetSome:input_type -> arista.segmentation.v1.DomainSegmentConfigSetSomeRequest
	61,  // 257: arista.segmentation.v1.DomainSegmentConfigService.Delete:input_type -> arista.segmentation.v1.DomainSegmentConfigDeleteRequest
	63,  // 258: arista.segmentation.v1.DomainSegmentConfigService.DeleteSome:input_type -> arista.segmentation.v1.DomainSegmentConfigDeleteSomeRequest
	65,  // 259: arista.segmentation.v1.DomainSegmentConfigService.DeleteAll:input_type -> arista.segmentation.v1.DomainSegmentConfigDeleteAllRequest
	67,  // 260: arista.segmentation.v1.DomainSegmentPolicyConfigService.GetOne:input_type -> arista.segmentation.v1.DomainSegmentPolicyConfigRequest
	69,  // 261: arista.segmentation.v1.DomainSegmentPolicyConfigService.GetSome:input_type -> arista.segmentation.v1.DomainSegmentPolicyConfigSomeRequest
	71,  // 262: arista.segmentation.v1.DomainSegmentPolicyConfigService.GetAll:input_type -> arista.segmentation.v1.DomainSegmentPolicyConfigStreamRequest
	71,  // 263: arista.segmentation.v1.DomainSegmentPolicyConfigService.Subscribe:input_type -> arista.segmentation.v1.DomainSegmentPolicyConfigStreamRequest
	71,  // 264: arista.segmentation.v1.DomainSegmentPolicyConfigService.GetMeta:input_type -> arista.segmentation.v1.DomainSegmentPolicyConfigStreamRequest
	71,  // 265: arista.segmentation.v1.DomainSegmentPolicyConfigService.SubscribeMeta:input_type -> arista.segmentation.v1.DomainSegmentPolicyConfigStreamRequest
	73,  // 266: arista.segmentation.v1.DomainSegmentPolicyConfigService.Set:input_type -> arista.segmentation.v1.DomainSegmentPolicyConfigSetRequest
	75,  // 267: arista.segmentation.v1.DomainSegmentPolicyConfigService.SetSome:input_type -> arista.segmentation.v1.DomainSegmentPolicyConfigSetSomeRequest
	77,  // 268: arista.segmentation.v1.DomainSegmentPolicyConfigService.Delete:input_type -> arista.segmentation.v1.DomainSegmentPolicyConfigDeleteRequest
	79,  // 269: arista.segmentation.v1.DomainSegmentPolicyConfigService.DeleteSome:input_type -> arista.segmentation.v1.DomainSegmentPolicyConfigDeleteSomeRequest
	81,  // 270: arista.segmentation.v1.DomainSegmentPolicyConfigService.DeleteAll:input_type -> arista.segmentation.v1.DomainSegmentPolicyConfigDeleteAllRequest
	83,  // 271: arista.segmentation.v1.DomainConfigService.GetOne:input_type -> arista.segmentation.v1.DomainConfigRequest
	85,  // 272: arista.segmentation.v1.DomainConfigService.GetSome:input_type -> arista.segmentation.v1.DomainConfigSomeRequest
	87,  // 273: arista.segmentation.v1.DomainConfigService.GetAll:input_type -> arista.segmentation.v1.DomainConfigStreamRequest
	87,  // 274: arista.segmentation.v1.DomainConfigService.Subscribe:input_type -> arista.segmentation.v1.DomainConfigStreamRequest
	87,  // 275: arista.segmentation.v1.DomainConfigService.GetMeta:input_type -> arista.segmentation.v1.DomainConfigStreamRequest
	87,  // 276: arista.segmentation.v1.DomainConfigService.SubscribeMeta:input_type -> arista.segmentation.v1.DomainConfigStreamRequest
	89,  // 277: arista.segmentation.v1.DomainConfigService.Set:input_type -> arista.segmentation.v1.DomainConfigSetRequest
	91,  // 278: arista.segmentation.v1.DomainConfigService.SetSome:input_type -> arista.segmentation.v1.DomainConfigSetSomeRequest
	93,  // 279: arista.segmentation.v1.DomainConfigService.Delete:input_type -> arista.segmentation.v1.DomainConfigDeleteRequest
	95,  // 280: arista.segmentation.v1.DomainConfigService.DeleteSome:input_type -> arista.segmentation.v1.DomainConfigDeleteSomeRequest
	97,  // 281: arista.segmentation.v1.DomainConfigService.DeleteAll:input_type -> arista.segmentation.v1.DomainConfigDeleteAllRequest
	99,  // 282: arista.segmentation.v1.PolicyConfigService.GetOne:input_type -> arista.segmentation.v1.PolicyConfigRequest
	101, // 283: arista.segmentation.v1.PolicyConfigService.GetSome:input_type -> arista.segmentation.v1.PolicyConfigSomeRequest
	103, // 284: arista.segmentation.v1.PolicyConfigService.GetAll:input_type -> arista.segmentation.v1.PolicyConfigStreamRequest
	103, // 285: arista.segmentation.v1.PolicyConfigService.Subscribe:input_type -> arista.segmentation.v1.PolicyConfigStreamRequest
	103, // 286: arista.segmentation.v1.PolicyConfigService.GetMeta:input_type -> arista.segmentation.v1.PolicyConfigStreamRequest
	103, // 287: arista.segmentation.v1.PolicyConfigService.SubscribeMeta:input_type -> arista.segmentation.v1.PolicyConfigStreamRequest
	105, // 288: arista.segmentation.v1.PolicyConfigService.Set:input_type -> arista.segmentation.v1.PolicyConfigSetRequest
	107, // 289: arista.segmentation.v1.PolicyConfigService.SetSome:input_type -> arista.segmentation.v1.PolicyConfigSetSomeRequest
	109, // 290: arista.segmentation.v1.PolicyConfigService.Delete:input_type -> arista.segmentation.v1.PolicyConfigDeleteRequest
	111, // 291: arista.segmentation.v1.PolicyConfigService.DeleteSome:input_type -> arista.segmentation.v1.PolicyConfigDeleteSomeRequest
	113, // 292: arista.segmentation.v1.PolicyConfigService.DeleteAll:input_type -> arista.segmentation.v1.PolicyConfigDeleteAllRequest
	2,   // 293: arista.segmentation.v1.ApplicationConfigService.GetOne:output_type -> arista.segmentation.v1.ApplicationConfigResponse
	4,   // 294: arista.segmentation.v1.ApplicationConfigService.GetSome:output_type -> arista.segmentation.v1.ApplicationConfigSomeResponse
	6,   // 295: arista.segmentation.v1.ApplicationConfigService.GetAll:output_type -> arista.segmentation.v1.ApplicationConfigStreamResponse
	6,   // 296: arista.segmentation.v1.ApplicationConfigService.Subscribe:output_type -> arista.segmentation.v1.ApplicationConfigStreamResponse
	0,   // 297: arista.segmentation.v1.ApplicationConfigService.GetMeta:output_type -> arista.segmentation.v1.MetaResponse
	0,   // 298: arista.segmentation.v1.ApplicationConfigService.SubscribeMeta:output_type -> arista.segmentation.v1.MetaResponse
	8,   // 299: arista.segmentation.v1.ApplicationConfigService.Set:output_type -> arista.segmentation.v1.ApplicationConfigSetResponse
	10,  // 300: arista.segmentation.v1.ApplicationConfigService.SetSome:output_type -> arista.segmentation.v1.ApplicationConfigSetSomeResponse
	12,  // 301: arista.segmentation.v1.ApplicationConfigService.Delete:output_type -> arista.segmentation.v1.ApplicationConfigDeleteResponse
	14,  // 302: arista.segmentation.v1.ApplicationConfigService.DeleteSome:output_type -> arista.segmentation.v1.ApplicationConfigDeleteSomeResponse
	16,  // 303: arista.segmentation.v1.ApplicationConfigService.DeleteAll:output_type -> arista.segmentation.v1.ApplicationConfigDeleteAllResponse
	18,  // 304: arista.segmentation.v1.DefaultActionConfigService.GetOne:output_type -> arista.segmentation.v1.DefaultActionConfigResponse
	20,  // 305: arista.segmentation.v1.DefaultActionConfigService.GetAll:output_type -> arista.segmentation.v1.DefaultActionConfigStreamResponse
	20,  // 306: arista.segmentation.v1.DefaultActionConfigService.Subscribe:output_type -> arista.segmentation.v1.DefaultActionConfigStreamResponse
	0,   // 307: arista.segmentation.v1.DefaultActionConfigService.SubscribeMeta:output_type -> arista.segmentation.v1.MetaResponse
	22,  // 308: arista.segmentation.v1.DefaultActionConfigService.Set:output_type -> arista.segmentation.v1.DefaultActionConfigSetResponse
	24,  // 309: arista.segmentation.v1.DomainSegmentPolicyService.GetOne:output_type -> arista.segmentation.v1.DomainSegmentPolicyResponse
	26,  // 310: arista.segmentation.v1.DomainSegmentPolicyService.GetSome:output_type -> arista.segmentation.v1.DomainSegmentPolicySomeResponse
	28,  // 311: arista.segmentation.v1.DomainSegmentPolicyService.GetAll:output_type -> arista.segmentation.v1.DomainSegmentPolicyStreamResponse
	28,  // 312: arista.segmentation.v1.DomainSegmentPolicyService.Subscribe:output_type -> arista.segmentation.v1.DomainSegmentPolicyStreamResponse
	0,   // 313: arista.segmentation.v1.DomainSegmentPolicyService.GetMeta:output_type -> arista.segmentation.v1.MetaResponse
	0,   // 314: arista.segmentation.v1.DomainSegmentPolicyService.SubscribeMeta:output_type -> arista.segmentation.v1.MetaResponse
	30,  // 315: arista.segmentation.v1.DomainService.GetOne:output_type -> arista.segmentation.v1.DomainResponse
	32,  // 316: arista.segmentation.v1.DomainService.GetSome:output_type -> arista.segmentation.v1.DomainSomeResponse
	34,  // 317: arista.segmentation.v1.DomainService.GetAll:output_type -> arista.segmentation.v1.DomainStreamResponse
	34,  // 318: arista.segmentation.v1.DomainService.Subscribe:output_type -> arista.segmentation.v1.DomainStreamResponse
	0,   // 319: arista.segmentation.v1.DomainService.GetMeta:output_type -> arista.segmentation.v1.MetaResponse
	0,   // 320: arista.segmentation.v1.DomainService.SubscribeMeta:output_type -> arista.segmentation.v1.MetaResponse
	36,  // 321: arista.segmentation.v1.DomainIPPrefixConfigService.GetOne:output_type -> arista.segmentation.v1.DomainIPPrefixConfigResponse
	38,  // 322: arista.segmentation.v1.DomainIPPrefixConfigService.GetSome:output_type -> arista.segmentation.v1.DomainIPPrefixConfigSomeResponse
	40,  // 323: arista.segmentation.v1.DomainIPPrefixConfigService.GetAll:output_type -> arista.segmentation.v1.DomainIPPrefixConfigStreamResponse
	40,  // 324: arista.segmentation.v1.DomainIPPrefixConfigService.Subscribe:output_type -> arista.segmentation.v1.DomainIPPrefixConfigStreamResponse
	0,   // 325: arista.segmentation.v1.DomainIPPrefixConfigService.GetMeta:output_type -> arista.segmentation.v1.MetaResponse
	0,   // 326: arista.segmentation.v1.DomainIPPrefixConfigService.SubscribeMeta:output_type -> arista.segmentation.v1.MetaResponse
	42,  // 327: arista.segmentation.v1.DomainIPPrefixConfigService.Set:output_type -> arista.segmentation.v1.DomainIPPrefixConfigSetResponse
	44,  // 328: arista.segmentation.v1.DomainIPPrefixConfigService.SetSome:output_type -> arista.segmentation.v1.DomainIPPrefixConfigSetSomeResponse
	46,  // 329: arista.segmentation.v1.DomainIPPrefixConfigService.Delete:output_type -> arista.segmentation.v1.DomainIPPrefixConfigDeleteResponse
	48,  // 330: arista.segmentation.v1.DomainIPPrefixConfigService.DeleteSome:output_type -> arista.segmentation.v1.DomainIPPrefixConfigDeleteSomeResponse
	50,  // 331: arista.segmentation.v1.DomainIPPrefixConfigService.DeleteAll:output_type -> arista.segmentation.v1.DomainIPPrefixConfigDeleteAllResponse
	52,  // 332: arista.segmentation.v1.DomainSegmentConfigService.GetOne:output_type -> arista.segmentation.v1.DomainSegmentConfigResponse
	54,  // 333: arista.segmentation.v1.DomainSegmentConfigService.GetSome:output_type -> arista.segmentation.v1.DomainSegmentConfigSomeResponse
	56,  // 334: arista.segmentation.v1.DomainSegmentConfigService.GetAll:output_type -> arista.segmentation.v1.DomainSegmentConfigStreamResponse
	56,  // 335: arista.segmentation.v1.DomainSegmentConfigService.Subscribe:output_type -> arista.segmentation.v1.DomainSegmentConfigStreamResponse
	0,   // 336: arista.segmentation.v1.DomainSegmentConfigService.GetMeta:output_type -> arista.segmentation.v1.MetaResponse
	0,   // 337: arista.segmentation.v1.DomainSegmentConfigService.SubscribeMeta:output_type -> arista.segmentation.v1.MetaResponse
	58,  // 338: arista.segmentation.v1.DomainSegmentConfigService.Set:output_type -> arista.segmentation.v1.DomainSegmentConfigSetResponse
	60,  // 339: arista.segmentation.v1.DomainSegmentConfigService.SetSome:output_type -> arista.segmentation.v1.DomainSegmentConfigSetSomeResponse
	62,  // 340: arista.segmentation.v1.DomainSegmentConfigService.Delete:output_type -> arista.segmentation.v1.DomainSegmentConfigDeleteResponse
	64,  // 341: arista.segmentation.v1.DomainSegmentConfigService.DeleteSome:output_type -> arista.segmentation.v1.DomainSegmentConfigDeleteSomeResponse
	66,  // 342: arista.segmentation.v1.DomainSegmentConfigService.DeleteAll:output_type -> arista.segmentation.v1.DomainSegmentConfigDeleteAllResponse
	68,  // 343: arista.segmentation.v1.DomainSegmentPolicyConfigService.GetOne:output_type -> arista.segmentation.v1.DomainSegmentPolicyConfigResponse
	70,  // 344: arista.segmentation.v1.DomainSegmentPolicyConfigService.GetSome:output_type -> arista.segmentation.v1.DomainSegmentPolicyConfigSomeResponse
	72,  // 345: arista.segmentation.v1.DomainSegmentPolicyConfigService.GetAll:output_type -> arista.segmentation.v1.DomainSegmentPolicyConfigStreamResponse
	72,  // 346: arista.segmentation.v1.DomainSegmentPolicyConfigService.Subscribe:output_type -> arista.segmentation.v1.DomainSegmentPolicyConfigStreamResponse
	0,   // 347: arista.segmentation.v1.DomainSegmentPolicyConfigService.GetMeta:output_type -> arista.segmentation.v1.MetaResponse
	0,   // 348: arista.segmentation.v1.DomainSegmentPolicyConfigService.SubscribeMeta:output_type -> arista.segmentation.v1.MetaResponse
	74,  // 349: arista.segmentation.v1.DomainSegmentPolicyConfigService.Set:output_type -> arista.segmentation.v1.DomainSegmentPolicyConfigSetResponse
	76,  // 350: arista.segmentation.v1.DomainSegmentPolicyConfigService.SetSome:output_type -> arista.segmentation.v1.DomainSegmentPolicyConfigSetSomeResponse
	78,  // 351: arista.segmentation.v1.DomainSegmentPolicyConfigService.Delete:output_type -> arista.segmentation.v1.DomainSegmentPolicyConfigDeleteResponse
	80,  // 352: arista.segmentation.v1.DomainSegmentPolicyConfigService.DeleteSome:output_type -> arista.segmentation.v1.DomainSegmentPolicyConfigDeleteSomeResponse
	82,  // 353: arista.segmentation.v1.DomainSegmentPolicyConfigService.DeleteAll:output_type -> arista.segmentation.v1.DomainSegmentPolicyConfigDeleteAllResponse
	84,  // 354: arista.segmentation.v1.DomainConfigService.GetOne:output_type -> arista.segmentation.v1.DomainConfigResponse
	86,  // 355: arista.segmentation.v1.DomainConfigService.GetSome:output_type -> arista.segmentation.v1.DomainConfigSomeResponse
	88,  // 356: arista.segmentation.v1.DomainConfigService.GetAll:output_type -> arista.segmentation.v1.DomainConfigStreamResponse
	88,  // 357: arista.segmentation.v1.DomainConfigService.Subscribe:output_type -> arista.segmentation.v1.DomainConfigStreamResponse
	0,   // 358: arista.segmentation.v1.DomainConfigService.GetMeta:output_type -> arista.segmentation.v1.MetaResponse
	0,   // 359: arista.segmentation.v1.DomainConfigService.SubscribeMeta:output_type -> arista.segmentation.v1.MetaResponse
	90,  // 360: arista.segmentation.v1.DomainConfigService.Set:output_type -> arista.segmentation.v1.DomainConfigSetResponse
	92,  // 361: arista.segmentation.v1.DomainConfigService.SetSome:output_type -> arista.segmentation.v1.DomainConfigSetSomeResponse
	94,  // 362: arista.segmentation.v1.DomainConfigService.Delete:output_type -> arista.segmentation.v1.DomainConfigDeleteResponse
	96,  // 363: arista.segmentation.v1.DomainConfigService.DeleteSome:output_type -> arista.segmentation.v1.DomainConfigDeleteSomeResponse
	98,  // 364: arista.segmentation.v1.DomainConfigService.DeleteAll:output_type -> arista.segmentation.v1.DomainConfigDeleteAllResponse
	100, // 365: arista.segmentation.v1.PolicyConfigService.GetOne:output_type -> arista.segmentation.v1.PolicyConfigResponse
	102, // 366: arista.segmentation.v1.PolicyConfigService.GetSome:output_type -> arista.segmentation.v1.PolicyConfigSomeResponse
	104, // 367: arista.segmentation.v1.PolicyConfigService.GetAll:output_type -> arista.segmentation.v1.PolicyConfigStreamResponse
	104, // 368: arista.segmentation.v1.PolicyConfigService.Subscribe:output_type -> arista.segmentation.v1.PolicyConfigStreamResponse
	0,   // 369: arista.segmentation.v1.PolicyConfigService.GetMeta:output_type -> arista.segmentation.v1.MetaResponse
	0,   // 370: arista.segmentation.v1.PolicyConfigService.SubscribeMeta:output_type -> arista.segmentation.v1.MetaResponse
	106, // 371: arista.segmentation.v1.PolicyConfigService.Set:output_type -> arista.segmentation.v1.PolicyConfigSetResponse
	108, // 372: arista.segmentation.v1.PolicyConfigService.SetSome:output_type -> arista.segmentation.v1.PolicyConfigSetSomeResponse
	110, // 373: arista.segmentation.v1.PolicyConfigService.Delete:output_type -> arista.segmentation.v1.PolicyConfigDeleteResponse
	112, // 374: arista.segmentation.v1.PolicyConfigService.DeleteSome:output_type -> arista.segmentation.v1.PolicyConfigDeleteSomeResponse
	114, // 375: arista.segmentation.v1.PolicyConfigService.DeleteAll:output_type -> arista.segmentation.v1.PolicyConfigDeleteAllResponse
	293, // [293:376] is the sub-list for method output_type
	210, // [210:293] is the sub-list for method input_type
	210, // [210:210] is the sub-list for extension type_name
	210, // [210:210] is the sub-list for extension extendee
	0,   // [0:210] is the sub-list for field type_name
}

func init() { file_arista_segmentation_v1_services_gen_proto_init() }
func file_arista_segmentation_v1_services_gen_proto_init() {
	if File_arista_segmentation_v1_services_gen_proto != nil {
		return
	}
	file_arista_segmentation_v1_segmentation_proto_init()
	file_arista_segmentation_v1_extras_gen_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_arista_segmentation_v1_services_gen_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MetaResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationConfigResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationConfigSomeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationConfigSomeResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationConfigStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationConfigStreamResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationConfigSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationConfigSetResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationConfigSetSomeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationConfigSetSomeResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationConfigDeleteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationConfigDeleteResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationConfigDeleteSomeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationConfigDeleteSomeResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationConfigDeleteAllRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationConfigDeleteAllResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DefaultActionConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DefaultActionConfigResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DefaultActionConfigStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DefaultActionConfigStreamResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DefaultActionConfigSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DefaultActionConfigSetResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainSegmentPolicyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainSegmentPolicyResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainSegmentPolicySomeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainSegmentPolicySomeResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainSegmentPolicyStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainSegmentPolicyStreamResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainSomeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainSomeResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainStreamResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainIPPrefixConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainIPPrefixConfigResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainIPPrefixConfigSomeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainIPPrefixConfigSomeResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainIPPrefixConfigStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainIPPrefixConfigStreamResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainIPPrefixConfigSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainIPPrefixConfigSetResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainIPPrefixConfigSetSomeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainIPPrefixConfigSetSomeResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainIPPrefixConfigDeleteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainIPPrefixConfigDeleteResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainIPPrefixConfigDeleteSomeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainIPPrefixConfigDeleteSomeResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainIPPrefixConfigDeleteAllRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[50].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainIPPrefixConfigDeleteAllResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainSegmentConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainSegmentConfigResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[53].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainSegmentConfigSomeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[54].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainSegmentConfigSomeResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[55].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainSegmentConfigStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[56].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainSegmentConfigStreamResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[57].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainSegmentConfigSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[58].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainSegmentConfigSetResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[59].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainSegmentConfigSetSomeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[60].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainSegmentConfigSetSomeResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[61].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainSegmentConfigDeleteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[62].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainSegmentConfigDeleteResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[63].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainSegmentConfigDeleteSomeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[64].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainSegmentConfigDeleteSomeResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[65].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainSegmentConfigDeleteAllRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[66].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainSegmentConfigDeleteAllResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[67].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainSegmentPolicyConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[68].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainSegmentPolicyConfigResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[69].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainSegmentPolicyConfigSomeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[70].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainSegmentPolicyConfigSomeResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[71].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainSegmentPolicyConfigStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[72].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainSegmentPolicyConfigStreamResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[73].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainSegmentPolicyConfigSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[74].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainSegmentPolicyConfigSetResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[75].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainSegmentPolicyConfigSetSomeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[76].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainSegmentPolicyConfigSetSomeResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[77].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainSegmentPolicyConfigDeleteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[78].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainSegmentPolicyConfigDeleteResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[79].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainSegmentPolicyConfigDeleteSomeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[80].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainSegmentPolicyConfigDeleteSomeResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[81].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainSegmentPolicyConfigDeleteAllRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[82].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainSegmentPolicyConfigDeleteAllResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[83].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[84].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainConfigResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[85].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainConfigSomeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[86].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainConfigSomeResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[87].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainConfigStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[88].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainConfigStreamResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[89].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainConfigSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[90].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainConfigSetResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[91].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainConfigSetSomeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[92].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainConfigSetSomeResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[93].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainConfigDeleteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[94].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainConfigDeleteResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[95].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainConfigDeleteSomeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[96].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainConfigDeleteSomeResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[97].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainConfigDeleteAllRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[98].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DomainConfigDeleteAllResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[99].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PolicyConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[100].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PolicyConfigResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[101].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PolicyConfigSomeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[102].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PolicyConfigSomeResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[103].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PolicyConfigStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[104].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PolicyConfigStreamResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[105].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PolicyConfigSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[106].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PolicyConfigSetResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[107].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PolicyConfigSetSomeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[108].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PolicyConfigSetSomeResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[109].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PolicyConfigDeleteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[110].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PolicyConfigDeleteResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[111].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PolicyConfigDeleteSomeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[112].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PolicyConfigDeleteSomeResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[113].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PolicyConfigDeleteAllRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_arista_segmentation_v1_services_gen_proto_msgTypes[114].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PolicyConfigDeleteAllResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_arista_segmentation_v1_services_gen_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   115,
			NumExtensions: 0,
			NumServices:   9,
		},
		GoTypes:           file_arista_segmentation_v1_services_gen_proto_goTypes,
		DependencyIndexes: file_arista_segmentation_v1_services_gen_proto_depIdxs,
		MessageInfos:      file_arista_segmentation_v1_services_gen_proto_msgTypes,
	}.Build()
	File_arista_segmentation_v1_services_gen_proto = out.File
	file_arista_segmentation_v1_services_gen_proto_rawDesc = nil
	file_arista_segmentation_v1_services_gen_proto_goTypes = nil
	file_arista_segmentation_v1_services_gen_proto_depIdxs = nil
}
