# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import sys
from AsuPatchBase import AsuPatchBase

class Dot1xAsuPatchHelper( AsuPatchBase ):
   def __init__( self ):
      AsuPatchBase.__init__( self, "Dot1xAsuPStore" )

   def check( self ):
      return 0

   def reboot( self ):
      # Flush possible previous version of the plugin so we are
      # guaranteed the version we just installed runs during ASU
      # Patch
      sys.modules.pop( "AsuPStorePlugin.Dot1xAsuPStore", None )
      return 0

   def cleanup( self ):
      return 0

_dot1xAsuPatchHelper = Dot1xAsuPatchHelper()

def execute( stageVal, *args, **kwargs ):
   return _dot1xAsuPatchHelper.execute( stageVal, *args, **kwargs )
