# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import sys
from AsuPatchBase import AsuPatchBase

class SandFapAsuPatchHelper( AsuPatchBase ):
   def __init__( self ):
      AsuPatchBase.__init__( self, "SandFapAsuPStore" )

   def check( self ):
      return 0

   def reboot( self ):
      # Flush possible previous version of the plugin so we are
      # guaranteed the version we just installed runs during ASU
      # Patch
      sys.modules.pop( "AsuPStorePlugin.SandFapAsuPStorePlugin", None )
      return 0

   def cleanup( self ):
      return 0

_sandFapAsuPatchHelper = SandFapAsuPatchHelper()

def execute( stageVal, *args, **kwargs ):
   return _sandFapAsuPatchHelper.execute( stageVal, *args, **kwargs )
