# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from AsuPatchBase import AsuPatchBase
import sys

class StrataL3AsuPatchHelper( AsuPatchBase ):
   def __init__( self ):
      AsuPatchBase.__init__( self, "StrataL3AsuPStore" )

   def check( self ):
      return 0

   def reboot( self ):
      # Flush possible previous version of the plugin so we are
      # guaranteed the version we just installed runs during ASU
      # Patch
      sys.modules.pop( "AsuPStorePlugin.StrataL3AsuPStore", None )
      return 0

   def cleanup( self ):
      return 0

_strataL3AsuPatchHelper = StrataL3AsuPatchHelper()

def execute( stageVal, *args, **kwargs ):
   return _strataL3AsuPatchHelper.execute( stageVal, *args, **kwargs )
