# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

'''
This patch attempts to address an issue that GR timeout could happen even
before the watchdog reload if the system is stuck during SSU due to issues
such as corrupted flash. By default, GR timeout is set to be 300 secs and
watchdog timer is 600 secs without applying this patch, so the system can
be stuck for 600 secs if SSU fails and GR timeout will happen in 300 secs
before the system gets recovered by the watchdog reboot, this can further
prolong the outage due to bad interaction with other devices in the network.

The patch changes the watchdog timer from 600 secs to 240 secs.
'''

from __future__ import absolute_import, division, print_function
from AsuPatchBase import AsuPatchBase
import Tac

class WatchdogTimerUpdateAsuPatchHelper( AsuPatchBase ):
   def __init__( self ):
      AsuPatchBase.__init__( self, "WatchdogTimerUpdate" )

   def check( self ):
      return 0

   def reboot( self ):
      cmd = [ 'python', '-m' 'Acons', 'Sysdb' ]
      watchdogTimer = ( 'cd /ar/Sysdb/asu/hardware/status\n' +
         '_.watchdogTimeout=240' )
      self.log( 'WatchdogTimerUpdate: Updating the watchdog timer to 240 secs' )
      Tac.run( cmd, input=watchdogTimer, asRoot=True, ignoreReturnCode=True,
               stdout=Tac.DISCARD, stderr=Tac.DISCARD )
      return 0

_watchdogTimerUpdateAsuPatchHelper = (
   WatchdogTimerUpdateAsuPatchHelper() )

def execute( stageVal, *args, **kwargs ):
   return _watchdogTimerUpdateAsuPatchHelper.execute( stageVal,
                                                      *args,
                                                      **kwargs )
