# pylint: disable=undefined-variable,consider-using-f-string
import glob

for f in glob.glob('/opt/gcc/*'):
   p = "%s/share/gdb/auto-load" % f
   gdb.execute('add-auto-load-safe-path %s' % p)
   gdb.execute('add-auto-load-scripts-directory %s' % p)

# "Opaque type resolution" does not appear to be necessary in a DWARF
# environment, and can make some operations extremely expensive - we have seen
# 5-fold increases in performance of some commands disabling this, and no
# side-effects. Disable this in your local .gdbinit file if you try and print
# something, and get told a type has "{<no data fields>}"
gdb.execute('set opaque-type-resolution off')
