#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from ctypes import CDLL
import os

def main():
   # libAgentLogrotateLib will handle signal from logrotate
   CDLL( "libAgentLogrotateLib.so" )
   platforms = [ 'Sand', 'Strata' ]
   monitors = {}
   for platform in platforms:
      try:
         # pylint: disable-next=consider-using-f-string
         monitors[ platform ] = __import__( '%sDropCounterMonitor' % platform )
      except ImportError:
         pass

   if not monitors:
      print( "0" )
   elif len( monitors ) > 1:
      testPlatform = os.environ.get( 'DROPCOUNTERMONITOR_PLATFORM' )
      if os.environ.get( 'SIMULATION_VMID' ) and testPlatform:
         monitor = monitors[ testPlatform ]
      else:
         # pylint: disable-next=consider-using-f-string
         raise AssertionError( 'Found multiple platform monitors: %s' % monitors )
   else:
      monitor = next( iter( monitors.values() ) )

   monitor.run()

if __name__ == "__main__":
   main()
