#!/usr/bin/env python3
# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import argparse
import os
import sys

parser = argparse.ArgumentParser( description="Determines the correct version of"
                                              " a PSP file based on EOS version" )
parser.add_argument( "--pspRoot", required=True, type=str, help="Path to the"
                                                                " extracted PSP" )
parser.add_argument( "--eosVersion", required=True, type=str, help="EOS version" )
args = parser.parse_args()

currMatch = ( "", "" )
default = ""
with open( os.path.join( args.pspRoot, "versions" ) ) as f:
   for l in f:
      versionCandidate, pspVersion = l.split()
      if versionCandidate == "EOS_DEFAULT":
         default = pspVersion
      elif args.eosVersion.startswith( versionCandidate ):
         if versionCandidate.startswith( currMatch[ 0 ] ):
            currMatch = ( versionCandidate, pspVersion )

bestMatch = currMatch[ 1 ] if currMatch[ 1 ] else default
print( bestMatch )
# Bash's return value is 0 for success, non-zero for failure. This is backwards from
# True and False in most programming languages, hence the 'not' below.
sys.exit( not bestMatch )
