#!/usr/bin/env python3

# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# archivecheck.py:
#
# Script run every minute as a cron job for archiving logs.
#
# Does nothing if there is no archive configured or if the archive is disabled.
# Otherwise, perform a routine check of the archive status and try to reduce the
# archive size (by deleting older logs) if there is not enough free space.
# Then it starts to copy logs and core files from EOS tmpfs directories /var/log
# and /var/core to the archive.
#
# Archive operations are done using the LogMgr/ArchiveLib library.
# The actual copy mechanism is driven by archivetree.py

from LogArchiverAgentLib.ArchiveChecker import runArchiveCheck
import argparse

def parseArgs():
   parser = argparse.ArgumentParser()
   parser.add_argument( '-v',
                        '--verbose',
                        help='Log what is being done to syslog',
                        action='store_true' )
   return parser.parse_args()

if __name__ == '__main__':
   args = parseArgs()
   verbose = args.verbose
   runArchiveCheck( runInAgent=False, verboseIn=verbose )
