# Copyright (c) 2008, 2009, 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
import Tac, Tracing, Plugins, AaaPluginLib

t0 = Tracing.trace0

class Authenticator( AaaPluginLib.Authenticator ):
   # pylint: disable-next=redefined-builtin
   def __init__( self, aaaConfig, method, type, service, 
                 remoteHost, remoteUser, tty, user ):
      AaaPluginLib.Authenticator.__init__( self, aaaConfig, method, type, 
                                           service, remoteHost, remoteUser, 
                                           tty, user )
      t0( "Authenticator created: user=", user )
      if not self.user:
         self.user = "admin"

   def authenticate( self, *responses ):
      t0( "authenticate returning success" )
      r = { "status" : "success", "messages" : [], "user" : self.user,
            "authToken" : "" }
      return r

class NoAuthenPlugin( AaaPluginLib.Plugin ): # pylint: disable=abstract-method
   def __init__( self, aaaConfig ):
      AaaPluginLib.Plugin.__init__( self, aaaConfig, "none" )

   def ready( self ):
      t0( "NoAuthenPlugin ready()" )
      return True
 
   # pylint: disable-next=redefined-builtin
   def createAuthenticator( self, method, type, service, remoteHost,
                            remoteUser, tty, user=None, privLevel=0 ):
      assert method == self.name
      return Authenticator( self.aaaConfig, method, type, service, 
                            remoteHost, remoteUser, tty, user )

   def openSession( self, authenticator ):
      t0( "openSession for user", authenticator.user )
      return authenticator      

   def closeSession( self, token ):
      t0( "closeSession for user", token.user )

   def authorizeShell( self, method, user, session ):
      t0( "authorizeShell for method", method, "user", user )
      assert method == self.name
      return ( 'allowed', "", {} )

   def authorizeShellCommand( self, method, user, session, mode, privlevel, tokens ):
      t0( "authorizeShellCommand for method", method, "user", user, "mode", mode,
            "privlevel", privlevel, "tokens", tokens )
      assert method == self.name
      return ( 'allowed', "", {} )

   def hasUnknownUser( self ):
      return True

@Plugins.plugin( provides=[], requires=[] )
def Plugin( ctx ):
   return NoAuthenPlugin( ctx.aaaAgent.config )
