# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import os
import errno
from signal import SIGKILL
from AgentDirectory import agent
import Tac
import Cell

def doMounts( entMan ):
   entMan.mount( Cell.path( "agent/config" ), "Tac::Dir", "wi" )
   entMan.mount( Cell.path( "agent/status" ), "Tac::Dir", "ri" )

def terminate( sysname, agentList ):
   for agentName in sorted( agentList ):
      agentInfo = agent( sysname, agentName )
      if agentInfo == None: # pylint: disable=singleton-comparison
         # pylint: disable-next=consider-using-f-string
         print( "%s was not running" % agentName )
      else:
         pid = agentInfo[ 'pid' ]
         # Try without fork first, in case mem is low, will work at least on self
         try:
            os.kill( pid, SIGKILL )
            # pylint: disable-next=consider-using-f-string
            print( "%s was terminated" % agentName )
            continue
         except OSError as e:
            # in case of EPERM, try again below, this time as root, else give up
            if e.errno != errno.EPERM:
               continue
         try:
            # pylint: disable-next=consider-using-f-string
            Tac.run( [ "kill", "-9", "%i" % pid ], asRoot=True )
            # pylint: disable-next=consider-using-f-string
            print( "%s was terminated" % agentName )
         except Tac.SystemCommandError:
            # pylint: disable-next=consider-using-f-string
            print( "%s was already terminated" % agentName )
