# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

'''This module defines useful python bindings and enum aliases for the AlePhy
package.

It should be used by tests, FRU plugins, etc., instead of manually
declaring the TAC types/using strings.
'''

import Tac

OrchestrationConfig = Tac.Type( 'AlePhy::OrchestrationConfig' )
OrchestrationStatus = Tac.Type( 'AlePhy::OrchestrationStatus' )

OrchestrationPauseRequest = Tac.Type( 'AlePhy::OrchestrationPauseRequest' )

SalEthPhySalPtrConfig = Tac.Type( 'AlePhy::EthPhySalPtrConfig' )
SalEthPhySalPtrStatus = Tac.Type( 'AlePhy::EthPhySalPtrStatus' )

SalOperationHookRegistry = Tac.Type( 'AlePhy::SalOperationHookRegistry' )

EthPhyIntfSalBaseState = Tac.Type( 'AlePhy::EthPhyIntfSalBaseState' )
EthPhyIntfSalConfig = Tac.Type( 'AlePhy::EthPhyIntfSalConfig' )
EthPhyIntfSalStatus = Tac.Type( 'AlePhy::EthPhyIntfSalStatus' )

EthPhyCoreSalBaseState = Tac.Type( 'AlePhy::EthPhyCoreSalBaseState' )
EthPhyCoreSalConfig = Tac.Type( 'AlePhy::EthPhyCoreSalConfig' )
EthPhyCoreSalStatus = Tac.Type( 'AlePhy::EthPhyCoreSalStatus' )

EthPhyIntfOperation = Tac.Type( 'AlePhy::EthPhyIntfOperation' )
EthPhyIntfOperEntry = Tac.Type( 'AlePhy::EthPhyIntfOperEntry' )
EthPhyOperQueue = Tac.Type( 'AlePhy::EthPhyOperQueue' )

XcvrAdapterManagementType = Tac.Type(
   "AlePhy::XcvrAdapterManagementType::XcvrAdapterManagementType" )
