#!/usr/bin/env python3
# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

'''
Utilities for working with collections
'''

def difference( a, b ):
   """Reduce two similar dictionaries to a sparse dictionary containing only
   the keys/values that differ between the two."""
   # pylint: disable-next=unidiomatic-typecheck
   if type( a ) != type( b ) or not isinstance( a, dict ):
      return ( a, b )

   result = {}
   for k in set( list( a ) + list( b ) ):
      if a.get( k ) != b.get( k ):
         result[ k ] = difference( a.get( k ), b.get( k ) )
   return result

def shuffled( list_ ):
   """Like sorted(), only shuffled."""
   import random # pylint: disable=import-outside-toplevel
   result = list( list_ )
   random.shuffle( result )
   return result

def head( i ):
   '''Return the first item in a collection or iterable.
   Raises StopIteration if there are no items.'''
   return next( iter( i ) )
