#!/usr/bin/env python3
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import os
import sys

class Options:
   no = 'no'
   auto = 'auto'
   always = 'always'

fdEnabled = {}
option = Options.no

def setup( colorOpt ):
   global fdEnabled
   global option
   option = colorOpt
   # fdEnabled is initialized inside setup() instead of being global. Since,
   # value for both keys is changed at the time of setup() being called.
   fdEnabled = { sys.stdout : False,
                 sys.stderr : False }

   for fd in fdEnabled:
      fdEnabled[ fd ] = ( ( os.environ.get( 'ABUILD' ) not in ( '1', 'True' ) ) and
                          ( colorOpt == Options.always or
                            ( colorOpt == Options.auto and fd.isatty() ) ) )
   os.environ[ 'AM_COLOR_TESTS' ] = colorOpt

# SGR codes
reset = 0
red = 31
green = 32
yellow = 33
blue = 34
magenta = 35
cyan = 36
white = 37
bold = 1

def ansiCode( number=reset ):
   return '\x1b[%dm' % number # pylint: disable=consider-using-f-string

def msg( text, fd=None, color=None ):
   if fd is None:
      fd = sys.stdout
   if color and fdEnabled[ fd ]:
      text = ansiCode( color ) + text + ansiCode()
   fd.write( text )

def successMsg( text ):
   msg( "SUCCESS", color=green )
   msg( ": " + text + '\n' )

def warningMsg( text ):
   fd = sys.stderr
   msg( "WARNING", fd=fd, color=yellow )
   msg( ": " + text + '\n', fd=fd )

def errorMsg( text ):
   fd = sys.stderr
   msg( "ERROR", fd=fd, color=red )
   msg( ": " + text + '\n', fd=fd )
