# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import os

def projectName():
   """Get the name of the project for the current workspace using /p4conf.
   If we fail to read this information from /p4conf, return None."""
   root = os.environ.get( 'P4ROOT', '/' )
   try:
      with open( os.path.join( root, "p4conf" ) ) as p4Conf:
         for line in p4Conf:
            if line.startswith( 'A4PROJECT=' ):
               _, name = line.split( '=', 1 )
               return name.strip()
   except OSError:
      pass
   return None

def getWorkspaceSyncpoint( project ):
   # Assumption is that this function will called from
   # inside the chrooted workspace/container
   # pylint: disable-next=consider-using-f-string
   with open( "/eng/project/%s/syncpoint" % project ) as f:
      line = f.readline()
      syncpoint = int( line )
      return syncpoint

   return None
