# Copyright (c) 2008, 2009, 2010, 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
from Arnet.IpTestLib import newUdpPkt, UdpHdrSize, ipVersionOf

VxlanHdrSize=8

# if Vxlan::VtiConfig::vxlanWellKnownPort is changed, please change this accordingly.
# we are harcoding to avoing cyclic dependency between Arnet and Vxlan Modules
VxlanUdpPortNum = 4789

def newVxlanPkt( srcMacAddr,
                 dstMacAddr,
                 vlanId=None,
                 vlanPriority=None,
                 cfiBit=False,
                 ethType="ethTypeIp",
                 srcIpAddr="10.1.1.1",
                 dstIpAddr="10.2.2.2",
                 version=None,
                 tos=0,
                 ipTotalLen=None,
                 ipId=0,
                 fragmentOffset=0,
                 moreFrag=False,
                 dontFrag=True,
                 ttl=None,
                 ipChecksum=None,
                 routerAlert=False,
                 srcPort=1999,
                 dstPort=VxlanUdpPortNum,
                 calcUdpCheckSum=False,
                 data=b'',
                 vniValid=True,
                 vni=1000,
                 **kwargs ):
   '''Create a packet with ethernet, ip, udp and vxlan header and 
   data.  Return a tuple of the packet, the ethernet header
   wrapper, the dot1Q header wrapper, the ip header wrapper, the
   router alert option wrapper, the udp header wrapper,
   vxlan header wrapper and the current offset into the packet
   where the next header should go.
   '''

   version = ipVersionOf( version, srcIpAddr, dstIpAddr )
   dataLen = len( data )
   
   (p, ethHdr, qHdr, ipHdr, raOpt, udpHdr, currentOffset) = \
       newUdpPkt( srcMacAddr=srcMacAddr,
                  dstMacAddr=dstMacAddr,
                  vlanId=vlanId,
                  vlanPriority=vlanPriority,
                  cfiBit=cfiBit,
                  ethType=ethType,
                  srcIpAddr=srcIpAddr,
                  dstIpAddr=dstIpAddr,
                  version=version,
                  ipTotalLen=ipTotalLen,
                  ipId=ipId,
                  fragmentOffset=fragmentOffset,
                  moreFrag=moreFrag,
                  dontFrag=dontFrag,
                  ttl=ttl,
                  tos=tos,
                  ipChecksum=ipChecksum,
                  routerAlert=routerAlert,
                  srcPort=srcPort,
                  dstPort=dstPort,
                  udpLen=( UdpHdrSize + VxlanHdrSize + dataLen ),
                  **kwargs )

   vxlanHdr = Tac.newInstance( "Arnet::VxlanHdrWrapper",
                               p, currentOffset )
   vxlanHdr.flagsReserved0 = 0
   vxlanHdr.flagsVniValid = vniValid
   vxlanHdr.flagsReserved1 = 0
   vxlanHdr.vni = vni & 0xFFFFFF
   vxlanHdr.vniReserved = 0
   if vni & 0xFF000000 != 0:
      vxlanHdr.vniReserved = ( vni >> 24 ) & 0xFF
   currentOffset += VxlanHdrSize

   # fill in the data
   if isinstance( data, str ):
      data = data.encode()
   p.rawBytesAtIdxIs( currentOffset, data )

   # re-calculate udp checksum
   udpHdr.checksum = 0
   if calcUdpCheckSum:
      udpHdr.checksum = udpHdr.computedChecksum
   return (p, ethHdr, qHdr, ipHdr, raOpt, udpHdr, vxlanHdr, currentOffset)

