#!/usr/bin/env python3
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, AsuPStore
from CliPlugin.AsuPStoreModel import ReloadHitlessBlockingReason
from RoutingUtils import getUrpfGlobalHwStatus

urpfStatus = Tac.Type( 'Urpf::UrpfState' )

class AlePStoreEventHandler( AsuPStore.PStoreEventHandler ):
   ''' When UrpfStatus for either Ipv4 or Ipv6 is set to errDisabled,
   this configuration will block ASU2 hitless reload.
   '''
   def __init__( self, urpfHwStatusDir, urpf6HwStatusDir ):
      AsuPStore.PStoreEventHandler.__init__( self )
      self.urpfHwStatusDir_ = urpfHwStatusDir
      self.urpf6HwStatusDir_ = urpf6HwStatusDir

   def hitlessReloadSupported( self ):
      warningList, blockingList = [], []
      if self.urpfHwStatusDir_ and \
            getUrpfGlobalHwStatus( self.urpfHwStatusDir_ ) == \
               urpfStatus.urpfErrorDisabled:
         blockingList.append( ReloadHitlessBlockingReason( reason='IPv4uRPF' ) )
      if self.urpf6HwStatusDir_ and \
            getUrpfGlobalHwStatus( self.urpf6HwStatusDir_ ) == \
               urpfStatus.urpfErrorDisabled:
         blockingList.append( ReloadHitlessBlockingReason( reason='IPv6uRPF' ) )
      return ( warningList, blockingList )
   
def Plugin( ctx ):
   featureName = 'Ale'
   if ctx.opcode() == 'CheckHitlessReloadSupported':
      entityManager = ctx.entityManager()
      mg = entityManager.mountGroup()
      urpfHwStatusDir = mg.mount( 'routing/hardware/urpfStatus', 
                                  'Tac::Dir', 'ri' )
      urpf6HwStatusDir = mg.mount( 'routing6/hardware/urpfStatus',
                                   'Tac::Dir', 'ri' )
      mg.close( blocking=True )
      ctx.registerAsuPStoreEventHandler( 
            featureName, 
            AlePStoreEventHandler( urpfHwStatusDir, urpf6HwStatusDir ) )
   else:
      ctx.registerAsuPStoreEventHandler( 
            featureName, 
            AlePStoreEventHandler( None, None ) )

