#!/usr/bin/env python3
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import AsuPStore
from CliPlugin.AsuPStoreModel import ReloadHitlessBlockingReason

class DirectFlowPStoreEventHandler( AsuPStore.PStoreEventHandler ):
   ''' When directflow is configured,
   this configuration will block ASU2 hitless reload.
   '''
   def __init__( self, directflowHwConfig, directflowClbConfig ):
      AsuPStore.PStoreEventHandler.__init__( self )
      self.directflowHwConfig_ = directflowHwConfig
      self.directflowClbConfig_ = directflowClbConfig

   def hitlessReloadSupported( self ):
      warningList, blockingList = [], []
      if self.directflowHwConfig_ and self.directflowHwConfig_.enabled\
         and not self.directflowClbConfig_.enabled:
         blockingList.append( ReloadHitlessBlockingReason( 
                                 reason='directFlowEnabled' ) )
      return ( warningList, blockingList )
   
def Plugin( ctx ):
   featureName = 'DirectFlow'
   if ctx.opcode() == 'CheckHitlessReloadSupported':
      entityManager = ctx.entityManager()
      mg = entityManager.mountGroup()
      directflowHwConfig = mg.mount( "openflow/directflowhwconfig",
            "OpenFlowTable::DirectFlowHwConfig", "rS" )
      directflowClbConfig = mg.mount( "directflow/configDir/clb",
            "DirectFlowConfig::Config", "rS" )
      mg.close( blocking=True )
      ctx.registerAsuPStoreEventHandler(
            featureName,
            DirectFlowPStoreEventHandler( directflowHwConfig, directflowClbConfig ) )
   else:
      ctx.registerAsuPStoreEventHandler(
            featureName,
            DirectFlowPStoreEventHandler( None, None ) )
