# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import AsuPStore
import Tac

class ScdPStoreEventHandler( AsuPStore.PStoreEventHandler ):
   def __init__( self, scdDir ):
      AsuPStore.PStoreEventHandler.__init__( self )
      self.scdDir_ = scdDir

   def getScdNames( self ):
      scdNames = [ 'Scd' ]
      for scdConfig in self.scdDir_.values():
         # pylint: disable-next=consider-using-f-string
         scdNames.append( 'Scd-%s' % scdConfig.name )
      return scdNames

   def save( self, pStoreIO ):
      scdNames = self.getScdNames()
      if scdNames:
         pStoreIO.set( "scdNames", scdNames )

   def getSupportedKeys( self ):
      return [ 'scdNames' ]

   def getKeys( self ):
      keys = []
      if self.getScdNames():
         keys.append( 'scdNames' )
      return keys

def Plugin( ctx ):
   featureName = "Scd"

   if ctx.opcode() == 'GetSupportedKeys':
      ctx.registerAsuPStoreEventHandler(
            featureName, ScdPStoreEventHandler( None ) )
      return

   entityManager = ctx.entityManager()
   mg = entityManager.mountGroup()

   scdDir = mg.mount( "hardware/scd/config/slice", "Tac::Dir", "ri" )
   mg.close( blocking=True )

   ctx.registerAsuPStoreEventHandler(
         featureName, ScdPStoreEventHandler( scdDir ) )
