#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import AsuPStore, Tac
from CliPlugin.AsuPStoreModel import ReloadHitlessBlockingReason

class TunnelIntfPStoreEventHandler( AsuPStore.PStoreEventHandler ):
   ''' When there is at least one tunnel interface is configured,
      this configuration will block ASU2 hitless reload.
    '''
   def __init__( self, tunnelIntfConfigDir ):
      AsuPStore.PStoreEventHandler.__init__( self )
      self.tunnelIntfConfigDir_ = tunnelIntfConfigDir

   def hitlessReloadSupported( self ):
      warningList, blockingList = [], []
      if self.tunnelIntfConfigDir_ and self.tunnelIntfConfigDir_.intfConfig:
         blockingList.append( ReloadHitlessBlockingReason(
            reason='tunnelIntfConfigured' ) )
      return ( warningList, blockingList )

def Plugin( ctx ):
   featureName = 'TunnelIntf'
   if ctx.opcode() == 'CheckHitlessReloadSupported':
      entityManager = ctx.entityManager()
      mg = entityManager.mountGroup()
      tunnelIntfConfigDir = mg.mount( 'interface/config/tunnel/intf',
                                      'Interface::TunnelIntfConfigDir', 'r' )
      mg.close( blocking=True )
      ctx.registerAsuPStoreEventHandler(
         featureName,
         TunnelIntfPStoreEventHandler( tunnelIntfConfigDir ) )
   else:
      ctx.registerAsuPStoreEventHandler(
         featureName,
         TunnelIntfPStoreEventHandler( None ) )
