#!/usr/bin/env python3
# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import os
import ProductAttributes

def getAsuSupportedToggleForProduct( product ):
   # The purpose of this toggle association is so that ASU shutdown path testing can
   # be done with the same image, where SSU shutdown and bootup paths are controlled
   # by seperate toggles
   toggleName = ""

   # Note, we do not validate toggle name as the build ws might not have all the
   # toggles present at build time due to missing dependancies.
   # Check toggle name with your own discretion
   toggleProductMap = {
      "EaglevilleSsu": [ 'eagleville' ],
      "T4SsuBootup": [
         'blackhawkt4dd',
         'blackhawkt4p',
         'blackhawktd4ddms',
         'mulhollandddms',
         'tecopads',
         'tecopasdd',
      ]
   }

   for toggle, products in toggleProductMap.items():
      if product in products:
         # can only resolve a single non-empty toggle
         assert toggleName == "", \
            f"{product} already has a toggle association: {toggleName}"
         toggleName = toggle

   return toggleName

def getAsuSupportedProductList():
   productsToConsider = []
   asuSupportedProducts = {}
   
   if "ASU_MANIFEST_NEXT" in os.environ:
   # used in btest for AsuBlockReload.py, will allow any product to reload in btest
      return asuSupportedProducts

   productGenerator = ProductAttributes.productGenerator()
   productGenerator.getProductList()
   # get the products list dynamically.
   productsToConsider = list( productGenerator.featureSupportedProducts.keys() )
   for product in productsToConsider:
      productAttr = ProductAttributes.attributesForProduct( product )
      # Keeping this list generation limited to Strata products,
      # as for other products, the ASU supported property might not
      # be in the productAttribute yet.
      if productAttr.productAttributes.platform == "strata":
         asuSupportedProducts[ product ] = \
               ( productAttr.bootAttributes.asuHitlessSupported,
                 getAsuSupportedToggleForProduct( product ) )

   return asuSupportedProducts
