#!/usr/bin/env python3
# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# A demo collector created for two purposes:
# - To show how a custom collector can be build
# - To be used for testing
"""Demo collector for Arista's EventMgr TCollector feature"""
#
# democollector.py
#
# demo.testvalue1
# demo.testvalue2
# demo.testvalue3
# demo.testvalue4


import time

  
ts = int( time.time() )

# Counters provided by this collector are printed one per line in the following
# sequence:
# Name timestamp value parameter1=xxx parameter2=xxx ...
#
# The Name consists a number of alphanumeric words separated by "."

print( "demo.testvalue1 %d %s" % ( ts, 100 ) )
print( "demo.testvalue2 %d %s param1=%s param2=%s" % ( ts, 200, 150, '/1/2/3' ) )
print( "demo.testvalue3 %d %s param1=%s param2=%s param3=%s" %
       ( ts, ts, 350, '/3/4/5', 'file' ) )
print( "demo.testvalue4 %d %s param1=%s param2=%s param3=%s" %
       ( ts, ts // 2, 450, '/4/5/6', 'directory' ) )

