# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import os
import re
from subprocess import Popen, PIPE

def getVersionFromInitrd( data ):
   issue = None
   platform = None
   cpioCmd = [ "cpio", "-i", "--quiet", "--to-stdout" ]
   with open( os.devnull, 'w' ) as FNULL:
      try:
         issue = Popen( cpioCmd + [ "etc/issue" ],
            stdout=PIPE, stdin=PIPE, stderr=FNULL ).communicate( data )
         platform = Popen( cpioCmd + [ "etc/platform" ],
            stdout=PIPE, stdin=PIPE, stderr=FNULL ).communicate( data )
      except Exception: # pylint: disable=broad-except
         return None

   if not issue[ 0 ] or not platform[ 0 ]:
      return None

   m = re.search( br"Aboot\s+(.+)$", issue[ 0 ], re.MULTILINE )
   if m:
      issue = m.group( 1 )

   platform = platform[ 0 ].strip()
   if issue and platform:
      return f"Aboot-{platform.decode()}-{issue.decode()}"

   return None
