# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import os

# A4_MOCK is set for mock workspaces.
# Generally, the variable's value is matched for '1' or 'True'
def isMockEnv():
   mockVar = os.environ.get( 'A4_MOCK', '0' )
   return mockVar in ( '1', 'True' )

# This check assumes we're within an "a4 make" environment, where
# variables in /bld/.Amake-environ override any preset env variables.
# The SHIPPING var within /bld/.Amake-environ comes from the project's settings
# and is set at the time of building a workspace.
def isShippingEnv():
   shippingVar = os.environ.get( 'SHIPPING', '0' )
   return shippingVar in ( '1', 'True' )
