# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import os
import CEosMode
import Tracing

__defaultTraceHandle__ = Tracing.Handle( "CEosHelper.CEosHelper" )
t0 = Tracing.trace0

def isCeos():
   if os.environ.get( "A4_CHROOT" ):
      return os.environ.get( "CEOS" )
   else:
      return os.environ.get( "CEOS" ) or os.path.exists( "/etc/cEOS-release" )

def enableCeosMgmtInterface():
   if isCeos() and ( os.environ.get( "MGMT_INTF" ) or 
         os.path.exists( "/mnt/flash/.enableMgmtIntf" ) ):
      return True
   return False

def devFolderPath():
   if isCeos():
      return "/hostdev"
   else:
      return "/dev"

def getCeosMode():
   if os.environ.get( 'EOS_PLATFORM' ) == 'ceoslab':
      mode = "lab"
   elif os.environ.get( 'EOS_PLATFORM' ) == 'veos':
      mode = "ceosr"
   elif os.environ.get( 'EOS_PLATFORM' ) == 'ceossai':
      mode = "sai"
   elif os.environ.get( 'EOS_PLATFORM' ) == 'ceosdsf':
      mode = "dsf"
   else:
      mode = os.environ.get( "CEOS_MODE" )
      if not mode or mode not in CEosMode.Modes:
         mode = "unknown"

   t0( "CEOS_MODE is set to %s" % mode ) # pylint: disable=consider-using-f-string
   return CEosMode.Modes[ mode ]()

def isCeosLab():
   return isinstance( getCeosMode(), CEosMode.CeosLabMode )
