# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliCommand
import Tac
from CliPlugin.AleCapacity import gv
ThresholdEntry = Tac.Type( "AleCapacity::ThresholdEntry" )

#------------------------------------------------------------------------------------
# [ no | default ] hardware capacity alert table <table-name> [ feature
#                  <feature-name> ] threshold THRESHOLD [ clear CLEAR_THRESHOLD ]
#------------------------------------------------------------------------------------

def cfgCapacityThreshCmdHandler( mode, args ):
   # Clear-threshold should be less than or eaual to the threshold
   thresh = args.get( 'THRESHOLD' )
   clearThresh = args.get( 'CLEAR_THRESHOLD' )
   implicit = False
   if not clearThresh:
      clearThresh = thresh
      implicit = True
   elif clearThresh > thresh:
      mode.addError(
            "The clear-threshold value should be at most the threshold value" )
      return
   tableName = args.get( 'TABLE_NAME' )
   if args.get( 'all' ) == 'all':
      # Set the threshold for all the features in the table
      statusDir = mode.sysdbRoot.entity[ "hardware/capacity/status" ]
      for agentName in statusDir:
         agentDir = mode.sysdbRoot.entity[ f"hardware/capacity/status/{agentName}" ]
         if agentDir.tableList is None:
            continue
         featureMapping = agentDir.tableList.featureMapping
         if tableName in featureMapping:
            for featureName in featureMapping[ tableName ].feature:
               if featureName != '':
                  rowName = '-'.join( [ tableName, featureName ] )
               else:
                  rowName = tableName
               gv.capacityConfig.threshold[ rowName ] = \
                     ThresholdEntry( thresh, clearThresh, implicit )
   else:
      if args.get( 'FEATURE_NAME' ):
         tableName = '-'.join( [ tableName, args.get( 'FEATURE_NAME' ) ] )
      else:
         statusDir = mode.sysdbRoot.entity[ "hardware/capacity/status" ]
         emptyFeature = False
         for agentName in statusDir:
            agentDir = mode.sysdbRoot.entity[
               f"hardware/capacity/status/{agentName}" ]
            if agentDir.tableList is None:
               continue
            featureMapping = agentDir.tableList.featureMapping
            if tableName in featureMapping:
               if '' in featureMapping[ tableName ].feature:
                  emptyFeature = True
                  break
         if not emptyFeature and not mode.session_.startupConfig():
            mode.addError( "Enter a feature name" )
            return
      gv.capacityConfig.threshold[ tableName ] = \
            ThresholdEntry( thresh, clearThresh, implicit )
   return

def _noOrDefaultThreshold( args, rowName ):
   if CliCommand.isDefaultCmd( args ):
      # If set to default, delete the entry from the config
      del gv.capacityConfig.threshold[ rowName ]
   else:
      assert CliCommand.isNoCmd( args )
      # If no, set threshold to 0
      gv.capacityConfig.threshold[ rowName ] = ThresholdEntry( 0, 0, True )

def cfgCapacityThreshCmdNoOrDefaultHandler( mode, args ):
   tableName = args.get( 'TABLE_NAME' )
   if 'all' in args:
      # Set the default threshold for all the features in the table
      statusDir = mode.sysdbRoot.entity[ "hardware/capacity/status" ]
      for agentName in statusDir:
         agentDir = mode.sysdbRoot.entity[ f"hardware/capacity/status/{agentName}" ]
         if agentDir.tableList is None:
            continue
         featureMapping = agentDir.tableList.featureMapping
         if tableName in featureMapping:
            for featureName in featureMapping[ tableName ].feature:
               if featureName != '':
                  rowName = '-'.join( [ tableName, featureName ] )
               else:
                  rowName = tableName
               _noOrDefaultThreshold( args, rowName )
   else:
      featureName = args.get( 'FEATURE_NAME' )
      if featureName:
         tableName = '-'.join( [ tableName, featureName ] )
      else:
         statusDir = mode.sysdbRoot.entity[ "hardware/capacity/status" ]
         emptyFeature = False
         for agentName in statusDir:
            agentDir = mode.sysdbRoot.entity[
               f"hardware/capacity/status/{agentName}" ]
            if agentDir.tableList is None:
               continue
            featureMapping = agentDir.tableList.featureMapping
            if tableName in featureMapping:
               if '' in featureMapping[ tableName ].feature:
                  emptyFeature = True
                  break
         if not emptyFeature and not mode.session_.startupConfig():
            mode.addError( "Enter a feature name" )
            return
      _noOrDefaultThreshold( args, tableName )
   return
