# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliPlugin import EthIntfCli, IntfCli
import CliPlugin.AleCountersRateWatermarkCli as Globals
import CliDynamicSymbol
import SharedMem
import Smash
import Tac

def getMatchedIntf( mode, intfArg ):
   intfList = IntfCli.Intf.getAll(
         mode, intf=intfArg, intfType=EthIntfCli.EthPhyIntf )
   return intfList

def getRateWatermarkModels():
   return CliDynamicSymbol.loadDynamicPlugin( "AleCountersRateWatermarkCliModel" )

def showRateWatermark( mode, args ):
   models = getRateWatermarkModels()
   model = models.InterfaceRateWatermarks()
   intfArg = args.get( 'INTF' )
   intfs = getMatchedIntf( mode, intfArg )

   windowStart = 0.0
   windowStop = 0.0

   shmemEntityManager = SharedMem.entityManager( sysdbEm=Globals.gv.entityManager )
   readerInfo = Smash.mountInfo( 'keyshadow' )
   fastWriterConfigDir = Globals.gv.fastWriterConfigDir
   if not fastWriterConfigDir.entityPtr:
      model.windowStart = windowStart
      model.windowEnd = windowStop
      return model
   # Only one writer per platform expected for now
   fastWriterConfig = fastWriterConfigDir.entityPtr.values()[ 0 ]
   writerName = fastWriterConfig.writerMountName
   rateWatermarkSmashTable = shmemEntityManager.doMount(
         f'counters/fastIntf/{writerName}/rateWatermark',
         'Ale::Counters::AllIntfRateWatermarkSmash',
         readerInfo )

   watermarks = rateWatermarkSmashTable.rateWatermark

   for intf in intfs:
      intfName = intf.status().intfId
      if intfName not in watermarks:
         continue
      watermarkStat = watermarks[ intfName ]
      watermarkEntry = models.InterfaceRateWatermark(
         inBitRateWatermark=watermarkStat.inBitRateWatermark,
         outBitRateWatermark=watermarkStat.outBitRateWatermark,
         inBitRateWatermarkPct=intf.ratePct(
            watermarkStat.inBitRateWatermark,
            watermarkStat.inPktRateWatermark ),
         outBitRateWatermarkPct=intf.ratePct(
            watermarkStat.outBitRateWatermark,
            watermarkStat.outPktRateWatermark ),
         intfName=intfName )
      model.interfaces[ intfName ] = watermarkEntry
      windowStart = watermarkStat.windowStart
      windowStop = watermarkStat.windowStop
   model.windowStart = windowStart
   model.windowEnd = windowStop

   return model

def rateWatermarkWindowHandler( mode, args ):
   window = int( args[ 'TIME' ] ) / 1000.0
   Globals.gv.rateWatermarkConfig.windowSize = window

def rateWatermarkWindowNoOrDefaultHandler( mode, args ):
   Globals.gv.rateWatermarkConfig.windowSize = 0
