# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Arnet
import bisect
import CliCommand
import CliToken.Hardware
import CliToken.Ip
import CommonGuards
from CliDynamicSymbol import CliDynamicPlugin
from CliPlugin.AleGatewayMacCli import gv
from collections import defaultdict
from TypeFuture import TacLazyType

ipMatcherForShow = CliToken.Ip.ipMatcherForShow
hardwareMatcherForShow = CliToken.Hardware.hardwareMatcherForShow
aleKwForShow = CliCommand.guardedKeyword( 'ale',
      helpdesc="Ale-specific information",
      guard=CommonGuards.standbyGuard )
RouterMacStatusType = TacLazyType( "Ale::RouterMacStatus" )
RouterMacType = TacLazyType( "Ale::RouterMacType" )
AleL3CliModel = CliDynamicPlugin( "AleL3CliModel" )

def columnFormatToDotFormat( macAddr ):
   return Arnet.EthAddr( macAddr ).displayString

def doShowIpHardwareAleRouterMacAddressGateway( mode, args ):
   success = RouterMacStatusType.RouterMacInstallSuccess
   routerMacGateway = RouterMacType.RouterMacGateway
   macToVlanDict = defaultdict( AleL3CliModel.VlanListType )

   routerMacVlanSetList = []
   for name, sliceData in gv.status.items():
      # ignoring legacy entity
      if name == 'l2RouterMacStatusDb':
         continue
      routerMacs = { ( macTypeMask.macWithMask.mac,
                       int( macTypeMask.intfId.strip( 'Vlan' ) ) )
                   for macTypeMask, status in sliceData.macStatusDb.items()
                   if macTypeMask.type == routerMacGateway and
                      status.status == success }
      routerMacVlanSetList.append( routerMacs )

   # NOTE set.intersection requires at least one set to be present
   routerMacVlanSet =\
      set.intersection( *routerMacVlanSetList ) if routerMacVlanSetList else set()
   # create dict for CAPI model
   for mac, vlan in routerMacVlanSet:
      macAddress = columnFormatToDotFormat( mac )
      # maintaining order while inserting
      bisect.insort( macToVlanDict[ macAddress ].vlans, vlan )

   return AleL3CliModel.GatewayMacStatus( macs=dict( macToVlanDict ) )
