# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliPlugin.AleFibCli import fecIdValid
from CliPlugin.VrfCli import DEFAULT_VRF
from CliPlugin.AleL3UnicastDebugCli import debugCliConfig, SelectiveTraceDomain
import Tac

def handleForceL3AdjReview( mode, args ):
   debugCliConfig.forceL3AdjReview += 1

def handleForceSingleL3AdjReview( mode, args ):
   fecId = args.get( 'FECID' )
   if fecId and not fecIdValid( fecId ):
      mode.addError( "fecId not valid" )
      return
   vrf = args.get( 'VRF', DEFAULT_VRF )
   debugCliConfig.singleAdjReview = Tac.Value( 'Ale::SingleAdjReview',
                                                fecId, vrf )
   debugCliConfig.forceSingleL3AdjReview += 1

def handleForceNhgReview( mode, args ):
   nhgName = args.get( 'NHG' )
   if nhgName:
      debugCliConfig.singleNhgReview = nhgName
      debugCliConfig.forceSingleNhgReview += 1
   else:
      debugCliConfig.forceNhgReview += 1

def handleForceClearInternalErrors( mode, args ):
   debugCliConfig.forceClearInternalError += 1

def handleSelectiveTracePrefix( mode, args ):
   prefix = args.get( 'PREFIX' )
   debugCliConfig.selectedPrefix.add( prefix )

def handleNoSelectiveTracePrefix( mode, args ):
   prefix = args.get( 'PREFIX' )
   if prefix:
      del debugCliConfig.selectedPrefix[ prefix ]
   else:
      debugCliConfig.selectedPrefix.clear()

def handleSelectiveTraceL2Adj( mode, args ):
   adjIndex = args.get( 'ADJ_INDEX' )
   debugCliConfig.selectedL2Adj.add( adjIndex )

def handleNoSelectiveTraceL2Adj( mode, args ):
   adjIndex = args.get( 'ADJ_INDEX' )
   if adjIndex:
      del debugCliConfig.selectedL2Adj[ adjIndex ]
   else:
      debugCliConfig.selectedL2Adj.clear()

def handleSelectiveTraceAdj( mode, args ):
   fecId = args.get( 'FECID' )
   debugCliConfig.selectedL3Adj.add( fecId )

def handleNoSelectiveTraceAdj( mode, args ):
   fecId = args.get( 'FECID' )
   if fecId:
      del debugCliConfig.selectedL3Adj[ fecId ]
   else:
      debugCliConfig.selectedL3Adj.clear()

def handleSelectiveTracePrefixTraceSpec( mode, args ):
   traceSpec = args.get( 'TRACESPEC' )
   debugCliConfig.traceSpec[ SelectiveTraceDomain.prefixDomain ] = traceSpec

def handleNoSelectiveTracePrefixTraceSpec( mode, args ):
   del debugCliConfig.traceSpec[ SelectiveTraceDomain.prefixDomain ]

def handleSelectiveTraceL2AdjTraceSpec( mode, args ):
   traceSpec = args.get( 'TRACESPEC' )
   debugCliConfig.traceSpec[ SelectiveTraceDomain.l2AdjDomain ] = traceSpec

def handleNoSelectiveTraceL2AdjTraceSpec( mode, args ):
   del debugCliConfig.traceSpec[ SelectiveTraceDomain.l2AdjDomain ]

def handleSelectiveTraceAdjTraceSpec( mode, args ):
   traceSpec = args.get( 'TRACESPEC' )
   debugCliConfig.traceSpec[ SelectiveTraceDomain.l3AdjDomain ] = traceSpec

def handleNoSelectiveTraceAdjTraceSpec( mode, args ):
   del debugCliConfig.traceSpec[ SelectiveTraceDomain.l3AdjDomain ]

def handleForceIpRouteReview( mode, args ):
   debugCliConfig.forceIpRouteReview += 1

def handleForceIpv6RouteReview( mode, args ):
   debugCliConfig.forceIpv6RouteReview += 1

def handleForceSingleIpRouteReview( mode, args ):
   prefix = args.get( 'PREFIX' )
   vrf = args.get( 'VRF', DEFAULT_VRF )
   debugCliConfig.singleRouteReview = Tac.Value( 'Ale::SingleRouteReview',
                                                  prefix, vrf )
   debugCliConfig.forceSingleIpRouteReview += 1

def handleForceSingleIpv6RouteReview( mode, args ):
   prefix = args.get( 'PREFIX' )
   vrf = args.get( 'VRF', DEFAULT_VRF )
   debugCliConfig.singleRouteReview = Tac.Value( 'Ale::SingleRouteReview',
                                                  prefix, vrf )
   debugCliConfig.forceSingleIpv6RouteReview += 1
