# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import AgentCommandRequest
from CliPlugin import AleCliLib, AleL3UnicastShowCliModel

# ---------------------------------------------------------------------------------
# "show ip hardware ale event [ type <TYPE> ] statistics [ all ]
# ---------------------------------------------------------------------------------

def doShowAleEventStat( mode, args ):
   cmd = 'AES#'
   if 'type' in args:
      if args[ 'TYPE' ] == 'bfd-down':
         cmd += 'B'
      elif args[ 'TYPE' ] == 'link-down':
         cmd += 'L'
      elif args[ 'TYPE' ] == 'tunnel-down':
         cmd += 'T'
   cmd += '#'
   if 'all' in args:
      cmd += 'A'
   cmd += '#'

   return AgentCommandRequest.runCliPrintSocketCommand(
         AleCliLib.entityManager, 'ale', 'VrfRootSmCliCallbackWithFormat',
         cmd, mode=mode, asyncCommand=True,
         model=AleL3UnicastShowCliModel.AleEventStatModel )

# ---------------------------------------------------------------------------------
# show ip hardware ale l2-adj summary
# ---------------------------------------------------------------------------------

def doShowAleL2AdjSummary( mode, args ):
   cmd = 'AA2S#'
   return AgentCommandRequest.runCliPrintSocketCommand(
         AleCliLib.entityManager, 'ale', 'VrfRootSmCliCallbackWithFormat',
         cmd, mode=mode, asyncCommand=True,
         model=AleL3UnicastShowCliModel.AleL2AdjSummary )
