# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliPlugin import AleCliLib
from CliPlugin.AleRouting import (
   ProxyFecTuple,
   FibAdjType,
   AleMaxRoutesCmd,
   unconfigured,
)
import CliCommand
import Tac # pylint: disable-msg=E0401

def setFecDampeningSupported( mode, args ):
   enabled = not CliCommand.isNoOrDefaultCmd( args )
   AleCliLib.routingHwConfig.fecDampeningEnabled = enabled

def setAdjSharing( mode, args ):
   if CliCommand.isDefaultCmd( args ):
      val = 'platformDefault'
   elif CliCommand.isNoCmd( args ):
      val = 'disabled'
   else:
      val = 'enabled'
   AleCliLib.routingHwConfig.adjSharing = val

def handleAdjProxyIpSrTe( mode, args ):
   ipSrTe = ProxyFecTuple( FibAdjType.srTePolicyAdj, FibAdjType.fibV4Adj )
   AleCliLib.routingHwConfig.adjProxyCli.add( ipSrTe )
   ipSrTe = ProxyFecTuple( FibAdjType.srTePolicyAdj, FibAdjType.fibV6Adj )
   AleCliLib.routingHwConfig.adjProxyCli.add( ipSrTe )
   ipSrTe = ProxyFecTuple( FibAdjType.srTePolicyAdj, FibAdjType.fibGenAdj )
   AleCliLib.routingHwConfig.adjProxyCli.add( ipSrTe )

def handleNoAdjProxyIpSrTe( mode, args ):
   ipSrTe = ProxyFecTuple( FibAdjType.srTePolicyAdj, FibAdjType.fibV4Adj )
   del AleCliLib.routingHwConfig.adjProxyCli[ ipSrTe ]
   ipSrTe = ProxyFecTuple( FibAdjType.srTePolicyAdj, FibAdjType.fibV6Adj )
   del AleCliLib.routingHwConfig.adjProxyCli[ ipSrTe ]
   ipSrTe = ProxyFecTuple( FibAdjType.srTePolicyAdj, FibAdjType.fibGenAdj )
   del AleCliLib.routingHwConfig.adjProxyCli[ ipSrTe ]

def handleAleMultiPathMax( mode, args ):
   AleCliLib.routingHwConfig.maxAleEcmp = args[ 'MAX_VAL' ]

def handleNoMultiPathMax( mode, args ):
   # set to default value which maps to maxEcmp
   AleCliLib.routingHwConfig.maxAleEcmp = \
      AleCliLib.routingHwConfig.maxAleEcmpDefault

def setDefaultRouteProtection( mode, args ):
   enabled = not CliCommand.isNoOrDefaultCmd( args )
   AleCliLib.routingHwConfig.protectDefaultRoute = enabled
   AleCliLib.routing6HwConfig.protectDefaultRoute = enabled
   if not AleCliLib.routingHwStatusCommon.protectDefaultRouteHitless:
      mode.addWarning( "Please restart layer 3 forwarding agent to ensure "
                       "routes are programmed properly" )

def handleRouteDeleteDelay( mode, args ):
   timeDelay = args[ 'SECONDS' ]
   AleCliLib.routingHwConfig.deletionDelay = timeDelay
   AleCliLib.routing6HwConfig.deletionDelay = timeDelay

def handleNoRouteDeleteDelay( mode, args ):
   AleCliLib.routingHwConfig.deletionDelay = \
                           AleCliLib.routingHwConfig.defaultDeletionDelay
   AleCliLib.routing6HwConfig.deletionDelay = \
                           AleCliLib.routingHwConfig.defaultDeletionDelay

def setNhUpdateEvent( mode, args ):
   # Default results in enabling this feature.
   enabled = not CliCommand.isNoCmd( args )
   AleCliLib.routingHwConfig.bfdPeerEventEnabled = enabled

def setBfdStatusMode( mode, args ):
   useCurrentBfdPeerStatus = not CliCommand.isNoOrDefaultCmd( args )
   AleCliLib.routingHwConfig.useCurrentBfdPeerStatus = useCurrentBfdPeerStatus

def setAsymmetricIrbEcmp( mode, args ):
   enableEcmpForAirb = not CliCommand.isNoOrDefaultCmd( args )
   AleCliLib.routingHwConfig.airbEcmpEnabled = enableEcmpForAirb

def handleMaxRoutes( mode, args ):
   # pylint: disable=W0212
   AleMaxRoutesCmd._getConfig( args ).maxNumRoutes = args[ 'MAX_ROUTES' ]

def handleNoMaxRoutes( mode, args ):
   # pylint: disable=W0212
   AleMaxRoutesCmd._getConfig( args ).maxNumRoutes = 0

def handleWeightDeviation( mode, args ):
   AleCliLib.routingHwConfig.ucmpWeightDeviation = args[ 'PERCENT' ]

def handleNoWeightDeviation( mode, args ):
   AleCliLib.routingHwConfig.ucmpWeightDeviation = 0.0

def setEcmpHfecWeightExpansion( enabled ):
   AleCliLib.routingHwConfig.hfecExpandEcmpNexthopWeight = enabled

def handleHierarchicalWeightExpansion( mode, args ):
   setEcmpHfecWeightExpansion( 'ecmp' in args )

def handleNoHierarchicalWeightExpansion( mode, args ):
   setEcmpHfecWeightExpansion( False )

def setOrResetRoutingTelemetry( mode, args ):
   enabled = not CliCommand.isNoOrDefaultCmd( args )
   AleCliLib.routingHwConfig.routingTelemetryEnabled = enabled

def handleUseRetainedHwState( mode, args ):
   AleCliLib.routingHwConfig.useRetainedHwState = True

def handleNoUseRetainedHwState( mode, args ):
   AleCliLib.routingHwConfig.useRetainedHwState = False

def setHfecPlusUrpf( mode, args ):
   enabled = not CliCommand.isNoOrDefaultCmd( args )
   AleCliLib.routingHwConfig.hierarchicalFecPlusUrpfEnabled = enabled

def setHfecDisabled( mode, args ):
   disabled = not CliCommand.isNoOrDefaultCmd( args )
   AleCliLib.routingHwConfig.hierarchicalFecsDisabled = disabled

def setHfecMaxLevel( maxLevel ):
   AleCliLib.routingHwConfig.hierarchicalFecsMaxLevel = maxLevel

def handleHierarchicalNextHopMaxLevel( mode, args ):
   setHfecMaxLevel( args[ 'MAX_LEVEL' ] )

def handleNoHierarchicalNextHopMaxLevel( mode, args ):
   setHfecMaxLevel( unconfigured )

def setResourceOptimizationThresholds( mode, args ):
   if args[ 'THRESHOLD_HIGH' ] < args[ 'THRESHOLD_LOW' ]:
      mode.addWarning( "Invalid threshold values, low value should be no larger "
                        "than high value." )
      return
   thresholds = AleCliLib.routingHwConfig.adjResourceOptimizationThresholds
   thresholds.stopOptimizationThreshold = args[ 'THRESHOLD_LOW' ]
   thresholds.startOptimizationThreshold = args[ 'THRESHOLD_HIGH' ]
   thresholds.configured = True

def resetResourceOptimizationThresholds( mode, args ):
   thresh = Tac.newInstance(
         'Routing::Hardware::AdjResourceOptimizationThresholds', 'thresholds' )
   thresholds = AleCliLib.routingHwConfig.adjResourceOptimizationThresholds
   thresholds.startOptimizationThreshold = thresh.defaultStartOptimizationThreshold
   thresholds.stopOptimizationThreshold = thresh.defaultStopOptimizationThreshold
   thresholds.configured = False

def setAdjResourceOptimization( mode, args ):
   enabled = CliCommand.isNoOrDefaultCmd( args )
   AleCliLib.routingHwConfig.adjResourceOptimizationEnabled = enabled

def handleAdjProxyDisabled( mode, args ):
   AleCliLib.routingHwConfig.adjProxyEnabled = False

def handleNoAdjProxyDisabled( mode, args ):
   AleCliLib.routingHwConfig.adjProxyEnabled = True

def handleHardwareFecProgrammed( mode, args ):
   AleCliLib.routingHwConfig.fecImplicitRefEnabled = True

def handleNoHardwareFecProgrammed( mode, args ):
   AleCliLib.routingHwConfig.fecImplicitRefEnabled = False

def handleHardwareFecMultiPathMax( mode, args ):
   AleCliLib.routingHwConfig.maxConfiguredEcmpLimit = args[ 'MAX_VAL' ]

def handleNoHardwareFecMultiPathMax( mode, args ):
   AleCliLib.routingHwConfig.maxConfiguredEcmpLimit =\
      AleCliLib.routingHwConfig.maxConfiguredEcmpLimitDefault
