# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliModel

class PerAgentVerifyResultDict( CliModel.Model ):
   perAgentResult = CliModel.Dict( help='dict of { sm name : error str }',
         keyType=str, valueType=str )

   def setDictFromList( self, pythonList ):
      for errorDict in pythonList:
         for name, err in errorDict.items():
            if name in self.perAgentResult:
               self.perAgentResult[ name ] += "\n" + err.strip()
            else:
               self.perAgentResult[ name ] = err.strip()

class VerifyPlatformStateCapiModel( CliModel.Model ):
   agentVerifyState = CliModel.Dict( help='Agent verify state indexed by agent Name',
         keyType=str, valueType=PerAgentVerifyResultDict )

   def setDict( self, pythonDict ):
      for agent in pythonDict:
         resultDict = PerAgentVerifyResultDict()
         resultDict.setDictFromList( pythonDict[ agent ] )
         self.agentVerifyState[ agent ] = resultDict

   def render( self ):
      for agent in self.agentVerifyState:
         smNameDict = self.agentVerifyState[ agent ].perAgentResult
         if agent not in smNameDict or len( smNameDict ) > 1:
            smNameDict.pop( agent, None )
            print( agent + " : Verify failed/retry" )
            if smNameDict:
               for smName in smNameDict:
                  print( "\t" + smName + ":" )
                  print( "\t\t" + smNameDict[ smName ].replace( "\n", "\n\t\t" ) )
         else:
            print( agent + " : Verify Success" )
