#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from ArnetModel import IpGenericAddress
from CliModel import Enum
from CliModel import Dict, List
from CliModel import Int
from CliModel import Model
from IntfModels import Interface
from Toggles import ArBgpToggleLib

##########
# Models for "show bgp session tracker"
##########
class BgpSessionTrackerEntry( Model ):
   state = Enum( values=( 'up', 'down', 'recovery', 'init' ), help="Tracker state" )
   if ArBgpToggleLib.toggleSessionTrackerUpAllModeEnabled():
      stateUpCondition = Enum( values=( 'allPeersEstablished',
                                        'anyPeerEstablished' ),
                               help="Condition for state to be up" )
   recoveryDelay = Int( help="Delay for session recovery in seconds" )
   remainingRecoveryDelay = Int(
      help="Remaining delay for session recovery in seconds" )
   totalSessions = Int( help="Total BGP sessions this tracker tracks" )
   establishedSessions = Int( help="Established BGP sessions this tracker tracks" )
   peers = List( valueType=IpGenericAddress, help="Peer addresses" )
   interfaces = List( valueType=Interface, help="Interfaces" )

class BgpSessionTrackerAllModel( Model ):
   trackers = Dict(
      keyType=str,
      valueType=BgpSessionTrackerEntry,
      optional=True,
      help='Dictionary of session trackers keyed by tracker name' )
