#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliDynamicSymbol import CliDynamicPlugin

ArBgpCliLabelBindingsHelper = CliDynamicPlugin( "ArBgpCliLabelBindingsHelper" )

labelBindingsCliHelperMap = {}

def getCommonLibSmashBgpLuLlbtConsumerSm( entityManager ):
   helper = labelBindingsCliHelperMap.get( entityManager.sysname() )
   return helper.lbtConsumerSm

def getCommonLibSmashBgpLuLlbtBindingTable( entityManager ):
   helper = labelBindingsCliHelperMap.get( entityManager.sysname() )
   return helper.lbt

def getCommonLibSmashBgpLuPlbtConsumerSm( entityManager ):
   helper = labelBindingsCliHelperMap.get( entityManager.sysname() )
   return helper.lbtConsumerSmPeer

def getCommonLibSmashBgpLuPlbtBindingTable( entityManager ):
   helper = labelBindingsCliHelperMap.get( entityManager.sysname() )
   return helper.lbtPeer

def showMplsBgpLuBindingsCmdHandler( mode, args ):
   helper = labelBindingsCliHelperMap.get( mode.entityManager.sysname() )
   helper.showConfigWarnings( mode )

   fec = args.get( 'PREFIX' )
   summary = 'summary' in args
   # remember if we want summarized or detailed output
   outputLevel = summary or 'detail' in args

   fmt = mode.session_.outputFormat()
   return helper.renderBindings(
      fmt, detail=outputLevel, summary=summary, matchPrefix=fec )

# -------------------------------------------------------------------------------
# Have the Cli Agent mount all needed state from sysdb
# -------------------------------------------------------------------------------
def Plugin( entityManager ):
   # The LocalLbt and PeerLbt for BGP LU come from two different
   # CommonLibSmash::LabelBindingTable instances located at two
   # different SharedMem paths.
   labelBindingsCliHelperMap[ entityManager.sysname() ] = \
      ArBgpCliLabelBindingsHelper.BgpLabelBindingsCliHelper(
         entityManager,
         "mpls/labelBindingTables/bgpLu",
         lbtPathPeer="mpls/labelBindingTables/bgpLuPlbt/1" )
