#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from BgpLib import NoOrDefault
from CliDynamicSymbol import CliDynamicPlugin
from CliPlugin.RoutingBgpCli import (
   bgpNeighborConfig,
   BgpNEDCmdBaseClass,
)
from CliPlugin.RoutingBgpNeighborCli import validatePeer
from IpLibConsts import DEFAULT_VRF

RoutingBgpCliHandler = CliDynamicPlugin( "RoutingBgpCliHandler" )

# class NeighborReflectorClusterIdCmd( BgpNEDCmdBaseClass ):
def NeighborReflectorClusterIdCmd_handleNormal( mode, args ):
   peer = args[ 'PEER' ]
   validatePeer( mode, peer )
   config = bgpNeighborConfig( peer, vrfName=mode.vrfName )
   config.clusterId = args[ 'CLUSTER_ID' ]
   RoutingBgpCliHandler.delNeighborConfigIfDefault( peer, vrfName=mode.vrfName )

def NeighborReflectorClusterIdCmd_handleNoOrDefault( mode, args, noOrDefault ):
   peer = args[ 'PEER' ]
   config = bgpNeighborConfig( peer, create=False, vrfName=mode.vrfName )
   if config:
      config.clusterId = config.clusterIdDefault
      RoutingBgpCliHandler.delNeighborConfigIfDefault( peer, vrfName=mode.vrfName )

def NeighborReflectorClusterIdCmd_handler( mode, args ):
   BgpNEDCmdBaseClass.callHandler(
      NeighborReflectorClusterIdCmd_handleNormal,
      NeighborReflectorClusterIdCmd_handleNoOrDefault,
      mode,
      args )

def NeighborReflectorClusterIdCmd_noOrDefaultHandler( mode, args ):
   BgpNEDCmdBaseClass.callNoOrDefaultHandler(
      NeighborReflectorClusterIdCmd_handleNoOrDefault,
      mode,
      args )

# class NeighborSessionTrackerCmd( BgpNEDCmdBaseClass ):
def NeighborSessionTrackerCmd_handleNormal( mode, args ):
   # NOTE: Until BUG598588 is fixed, we do not support non-default VRFs
   if mode.vrfName != DEFAULT_VRF:
      mode.addError( 'Session tracker configuration is not supported for '
                     'non-default VRF' )
      return
   peer = args[ 'PEER' ]
   validatePeer( mode, peer )
   config = bgpNeighborConfig( peer, vrfName=mode.vrfName )
   config.sessionTracker = args[ 'NAME' ]
   config.sessionTrackerPresent = True
   RoutingBgpCliHandler.delNeighborConfigIfDefault( peer, vrfName=mode.vrfName )

def NeighborSessionTrackerCmd_handleNoOrDefault( mode, args, noOrDefault ):
   peer = args[ 'PEER' ]
   config = bgpNeighborConfig( peer, create=False, vrfName=mode.vrfName )
   if config:
      config.sessionTrackerPresent = ( noOrDefault != NoOrDefault.DEFAULT and
                                       config.isPeerGroupPeer )
      config.sessionTracker = config.sessionTrackerDefault
      RoutingBgpCliHandler.delNeighborConfigIfDefault( peer, vrfName=mode.vrfName )

def NeighborSessionTrackerCmd_handler( mode, args ):
   BgpNEDCmdBaseClass.callHandler(
      NeighborSessionTrackerCmd_handleNormal,
      NeighborSessionTrackerCmd_handleNoOrDefault,
      mode,
      args )

def NeighborSessionTrackerCmd_noOrDefaultHandler( mode, args ):
   BgpNEDCmdBaseClass.callNoOrDefaultHandler(
      NeighborSessionTrackerCmd_handleNoOrDefault,
      mode,
      args )
