# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliPlugin.AegisShowCommands import agentCommandRequest
import LazyMount

hardwareDefinitionConfig = None

def doShowPlatformTfaTpIntfSummary( mode, args ):
   if hardwareDefinitionConfig and hardwareDefinitionConfig.currCfg:
      print( 'Hardware configuration: %s' % hardwareDefinitionConfig.currCfg.url )
   cmds = [ ( 'tfaSummary chipId=%d', False ) ]
   agentCommandRequest( mode, args, cmds )

def Plugin( em ):
   global hardwareDefinitionConfig
   hardwareDefinitionConfig = LazyMount.mount(
      em,
      'trafficPolicies/hardware/intf/definition',
      'Aegis::HardwareDefinitionConfig', 'r' )
