#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Arnet
import Tac
from CliPlugin.BgpTraceCli import traceFacilityForVrf
from IpLibConsts import DEFAULT_VRF

def changeNeighborTrace( neighborFacility, vrfName, no=False ):
   traceFacility = traceFacilityForVrf( vrfName )
   addr = Arnet.IpGenAddr( str( neighborFacility ) )
   if not no:
      peerEntry = Tac.Value( 'Routing::Bgp::TraceFacilityPeerEntry', addr )
      peerEntry.enabled = True
      traceFacility.peerEntry.addMember( peerEntry )
   else:
      del traceFacility.peerEntry[ addr ]

def changeNeighborTraceForAll( vrfName, default=None, no=False ):
   traceFacility = traceFacilityForVrf( vrfName )
   peerEntryForAll = Tac.Value( 'Routing::Bgp::TraceFacilityEntryForAll' )
   peerEntryForAll.enabled = not no
   if ( not ( default or vrfName == DEFAULT_VRF ) ) or no:
      peerEntryForAll.isSet = True
   traceFacility.peerEntryForAll = peerEntryForAll
   traceFacility.peerEntry.clear()

def BgpTraceNeighbor_handler( mode, args ):
   if 'all' in args:
      changeNeighborTraceForAll( mode.vrfName )
   else:
      changeNeighborTrace( args[ 'PEER' ], mode.vrfName )

def BgpTraceNeighbor_noHandler( mode, args ):
   if 'all' in args:
      changeNeighborTraceForAll( mode.vrfName, no=True )
   else:
      changeNeighborTrace( args[ 'PEER' ], mode.vrfName, no=True )

def BgpTraceNeighbor_defaultHandler( mode, args ):
   if 'all' in args:
      changeNeighborTraceForAll( mode.vrfName, default=True )
   else:
      changeNeighborTrace( args[ 'PEER' ], mode.vrfName, no=True )

def setRouteKeyPrefixTrace( vrfName, prefixMatch ):
   traceFacility = traceFacilityForVrf( vrfName )
   prefix = Arnet.IpGenAddrWithMask( str( prefixMatch ) ).subnet
   routeKeyEntry = Tac.Value( 'Routing::Bgp::TraceFacilityRouteKeyEntryForPrefix',
                               prefix )
   routeKeyEntry.enabled = True
   traceFacility.routeKeyEntryForPrefix.addMember( routeKeyEntry )

def noRouteKeyPrefixTrace( vrfName, prefixMatch ):
   traceFacility = traceFacilityForVrf( vrfName )
   prefix = Arnet.IpGenAddrWithMask( str( prefixMatch ) ).subnet
   del traceFacility.routeKeyEntryForPrefix[ prefix ]

def setRouteKeyAfiSafiTrace( vrfName, afi, safi ):
   traceFacility = traceFacilityForVrf( vrfName )
   afiSafi = Tac.Value( "Routing::Bgp::AfiSafi", afi, safi )
   routeKeyEntryForAfiSafi = (
         Tac.Value( 'Routing::Bgp::TraceFacilityRouteKeyEntryForAfiSafi',
                    afiSafi ) )
   routeKeyEntryForAfiSafi.enabled = True
   routeKeyEntryForAfiSafi.isSet = True
   traceFacility.routeKeyEntryForAfiSafi.addMember( routeKeyEntryForAfiSafi )

def noRouteKeyAfiSafiTrace( vrfName, afi, safi, default=False ):
   traceFacility = traceFacilityForVrf( vrfName )
   afiSafi = Tac.Value( "Routing::Bgp::AfiSafi", afi, safi )
   if default or vrfName == DEFAULT_VRF:
      del traceFacility.routeKeyEntryForAfiSafi[ afiSafi ]
   else:
      routeKeyEntryForAfiSafi = (
            Tac.Value( 'Routing::Bgp::TraceFacilityRouteKeyEntryForAfiSafi',
                       afiSafi ) )
      routeKeyEntryForAfiSafi.enabled = False
      routeKeyEntryForAfiSafi.isSet = True
      traceFacility.routeKeyEntryForAfiSafi.addMember( routeKeyEntryForAfiSafi )

def setRouteKeyTraceForAll( vrfName, default=None ):
   traceFacility = traceFacilityForVrf( vrfName )
   routeKeyEntryForAll = Tac.Value( 'Routing::Bgp::TraceFacilityEntryForAll' )
   routeKeyEntryForAll.enabled = True
   if not default and vrfName != DEFAULT_VRF:
      routeKeyEntryForAll.isSet = True
   traceFacility.routeKeyEntryForAll = routeKeyEntryForAll
   traceFacility.routeKeyEntryForPrefix.clear()
   traceFacility.routeKeyEntryForAfiSafi.clear()

def noRouteKeyTraceForAll( vrfName ):
   traceFacility = traceFacilityForVrf( vrfName )
   routeKeyEntryForAll = Tac.Value( 'Routing::Bgp::TraceFacilityEntryForAll' )
   routeKeyEntryForAll.enabled = False
   routeKeyEntryForAll.isSet = True
   traceFacility.routeKeyEntryForAll = routeKeyEntryForAll
   traceFacility.routeKeyEntryForPrefix.clear()
   traceFacility.routeKeyEntryForAfiSafi.clear()

def BgpTraceRouteKey_handler( mode, args ):
   if 'PEER' in args:
      setRouteKeyPrefixTrace( mode.vrfName, args[ 'PEER' ] )
   elif 'AFI' in args:
      setRouteKeyAfiSafiTrace( mode.vrfName, args[ 'AFI' ], "safiUnicast" )
   else:
      setRouteKeyTraceForAll( mode.vrfName )

def BgpTraceRouteKey_noHandler( mode, args ):
   if 'PEER' in args:
      noRouteKeyPrefixTrace( mode.vrfName, args[ 'PEER' ] )
   elif 'AFI' in args:
      noRouteKeyAfiSafiTrace( mode.vrfName, args[ 'AFI' ], "safiUnicast" )
   else:
      noRouteKeyTraceForAll( mode.vrfName )

def BgpTraceRouteKey_defaultHandler( mode, args ):
   if 'PEER' in args:
      noRouteKeyPrefixTrace( mode.vrfName, args[ 'PEER' ] )
   elif 'AFI' in args:
      noRouteKeyAfiSafiTrace( mode.vrfName, args[ 'AFI' ], "safiUnicast",
                              default=True )
   else:
      setRouteKeyTraceForAll( mode.vrfName, default=True )
