#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliPlugin import BgpVpls as Globals
from CliPlugin.BgpVpls import (
   BgpVplsGroupConfigMode,
   BgpVplsGroupSignalingConfigMode,
   BgpVplsInstanceConfigMode,
)
from CliPlugin.IraServiceCli import getEffectiveProtocolModel
from CliPlugin.RoutingBgpCli import (
   afModeExtensionHook,
   configForVrf,
)
from CliPlugin.RoutingBgpInstanceCli import resetBgpAfModeConfig
from IpLibConsts import DEFAULT_VRF
from IpLibTypes import ProtocolAgentModelType
from RouteMapLib import getExtCommValue
from TypeFuture import TacLazyType

RouteDistinguisher = TacLazyType( "Arnet::RouteDistinguisher" )

# class VplsAfModeCmd( CliCommand.CliCommandClass ):
def VplsAfModeCmd_handler( mode, args ):
   if getEffectiveProtocolModel( mode ) != ProtocolAgentModelType.multiAgent:
      mode.addWarning( "Multi-agent routing protocols model must be "
                       "configured for the BGP VPLS address family" )
   assert mode.vrfName == DEFAULT_VRF
   childMode = mode.childMode(
      afModeExtensionHook.afModeExtension[ Globals.VPLS_AF_STR ] )
   mode.session_.gotoChildMode( childMode )

def VplsAfModeCmd_noOrDefaultHandler( mode, args ):
   assert mode.vrfName == DEFAULT_VRF
   config = configForVrf( mode.vrfName )
   resetBgpAfModeConfig( config, Globals.VPLS_AF_STR, mode.vrfName )

# class BgpVplsCommand( CliCommand.CliCommandClass ):
def BgpVplsCommand_handler( mode, args ):
   assert mode.vrfName == DEFAULT_VRF
   vplsName = args[ "VPLS_INSTANCE_NAME" ]
   childMode = mode.childMode( BgpVplsInstanceConfigMode, vplsName=vplsName )
   mode.session_.gotoChildMode( childMode )

def BgpVplsCommand_noOrDefaultHandler( mode, args ):
   assert mode.vrfName == DEFAULT_VRF
   vplsName = args[ "VPLS_INSTANCE_NAME" ]
   del Globals.bgpVplsConfigDir.instance[ vplsName ]

# class BgpVplsGroupCommand( CliCommand.CliCommandClass ):
def BgpVplsGroupCommand_handler( mode, args ):
   groupName = args[ "GROUP_NAME" ]
   childMode = mode.childMode(
      BgpVplsGroupConfigMode, vplsName=mode.vplsName, groupName=groupName )
   mode.session_.gotoChildMode( childMode )

def BgpVplsGroupCommand_noOrDefaultHandler( mode, args ):
   groupName = args[ "GROUP_NAME" ]
   del mode.config().group[ groupName ]

# class RdCommand( CliCommand.CliCommandClass ):
def RdCommand_handler( mode, args ):
   mode.config().rd = args[ "RD" ]

def RdCommand_noOrDefaultHandler( mode, args ):
   mode.config().rd = RouteDistinguisher()

# class RtCommand( CliCommand.CliCommandClass ):
def RtCommand_handler( mode, args ):
   u64Rt = getExtCommValue( "rt " + args[ "RT" ] ).extendedCommunity()
   cfg = mode.config()
   if "import" in args:
      cfg.importRt.add( u64Rt )
   if "export" in args:
      cfg.exportRt.add( u64Rt )

def RtCommand_noOrDefaultHandler( mode, args ):
   cfg = mode.config()
   if "all" in args:
      cfg.importRt.clear()
      cfg.exportRt.clear()
      return

   u64Rt = getExtCommValue( "rt " + args[ "RT" ] ).extendedCommunity()
   if "import" in args:
      del cfg.importRt[ u64Rt ]
   if "export" in args:
      del cfg.exportRt[ u64Rt ]

# class RtRcfCommand( CliCommand.CliCommandClass ):
def RtRcfCommand_handler( mode, args ):
   cfg = mode.config()
   function = args[ "RCF_FUNCTION" ]
   functionName = function.replace( '()', '' )
   if "import" in args:
      cfg.importRcf = functionName
   if "export" in args:
      cfg.exportRcf = functionName

def RtRcfCommand_noOrDefaultHandler( mode, args ):
   cfg = mode.config()
   if "import" in args:
      cfg.importRcf = ""
   if "export" in args:
      cfg.exportRcf = ""

# class BgpSignalingCommand( CliCommand.CliCommandClass ):
def BgpSignalingCommand_handler( mode, args ):
   childMode = mode.childMode( BgpVplsGroupSignalingConfigMode,
                               vplsName=mode.vplsName,
                               groupName=mode.groupName )
   mode.session_.gotoChildMode( childMode )

def BgpSignalingCommand_noOrDefaultHandler( mode, args ):
   cfg = mode.config()
   cfg.bgpSignalingClear()

# class BgpSignalingVeIdCommand( CliCommand.CliCommandClass ):
def BgpSignalingVeIdCommand_handler( mode, args ):
   cfg = mode.config()
   cfg.bgpSignalingVeId = args[ "VE_ID" ]

def BgpSignalingVeIdCommand_noOrDefaultHandler( mode, args ):
   cfg = mode.config()
   cfg.bgpSignalingVeId = None

# class BgpSignalingVeBlockSizeCommand( CliCommand.CliCommandClass ):
def BgpSignalingVeBlockSizeCommand_handler( mode, args ):
   cfg = mode.config()
   cfg.bgpSignalingVbs = args[ "SIZE" ]

def BgpSignalingVeBlockSizeCommand_noOrDefaultHandler( mode, args ):
   cfg = mode.config()
   cfg.bgpSignalingVbs = cfg.bgpSignalingVbsDefault

# class BgpSignalingProfileCommand( CliCommand.CliCommandClass ):
def BgpSignalingProfileCommand_handler( mode, args ):
   cfg = mode.config()
   cfg.bgpSignalingProfileName = args[ "PROFILE_NAME" ]

def BgpSignalingProfileCommand_noOrDefaultHandler( mode, args ):
   cfg = mode.config()
   cfg.bgpSignalingProfileName = cfg.bgpSignalingProfileNameDefault
