#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from BgpLib import NoOrDefault
from CliPlugin.BmpCli import RouterBmpStationModelet
from CliPlugin.IraServiceCli import getEffectiveProtocolModel
from CliPlugin.RoutingBgpCli import BgpCmdBaseClass
from IpLibTypes import ProtocolAgentModelType

def handlerAuthenticationKeyCmd( mode, args ):
   stationModelet = mode.modeletMap[ RouterBmpStationModelet ]
   stationModelet.setBmpStationKey( args[ 'AUTH_PASSWD' ] )

def noOrDefaultHandlerAuthenticationKeyCmd( mode, args ):
   stationModelet = mode.modeletMap[ RouterBmpStationModelet ]
   stationModelet.noBmpStationKey()

def handlerConnectionAddressCmd( mode, args ):
   stationModelet = mode.modeletMap[ RouterBmpStationModelet ]
   vrfName = args.get( 'VRF' )
   addr = args[ 'HOST' ]
   stationModelet.setRemoteAddr( addr, vrfName )

def noOrDefaultHandlerConnectionAddressCmd( mode, args ):
   stationModelet = mode.modeletMap[ RouterBmpStationModelet ]
   stationModelet.noRemoteAddr()

def handlerConnectionKeepaliveCmd( mode, args ):
   stationModelet = mode.modeletMap[ RouterBmpStationModelet ]
   idleTime = args[ 'IDLETIME' ]
   probeInterval = args[ 'PROBEINTERVAL' ]
   probeCount = args[ 'PROBECOUNT' ]
   stationModelet.setTcpKeepalive( idleTime, probeInterval, probeCount )

def noOrDefaultHandlerConnectionKeepaliveCmd( mode, args ):
   stationModelet = mode.modeletMap[ RouterBmpStationModelet ]
   stationModelet.noTcpKeepalive()

def handlerConnectionModeCmd( mode, args ):
   stationModelet = mode.modeletMap[ RouterBmpStationModelet ]
   if 'active' in args:
      reconnectTime = None
      if 'RECONNECTTIME' in args:
         reconnectTime = args[ 'RECONNECTTIME' ]
      stationModelet.setActiveMode( args[ 'PORT' ], reconnectTime )
   else:
      stationModelet.setPassiveMode()

def noOrDefaultHandlerConnectionModeCmd( mode, args ):
   stationModelet = mode.modeletMap[ RouterBmpStationModelet ]
   stationModelet.noMode()

def handlerDescriptionCmd( mode, args ):
   stationModelet = mode.modeletMap[ RouterBmpStationModelet ]
   stationModelet.setBmpStationDescription( args[ 'DESCRIPTION' ] )

def noOrDefaultHandlerDescriptionCmd( mode, args ):
   stationModelet = mode.modeletMap[ RouterBmpStationModelet ]
   stationModelet.noBmpStationDescription()

def handlerExportPolicyReceivedRoutesCmd( mode, args ):
   stationModelet = mode.modeletMap[ RouterBmpStationModelet ]
   stationModelet.setBmpReceivedRoutes( args[ 'POLICIES' ] )

def noHandlerExportPolicyReceivedRoutesCmd( mode, args ):
   stationModelet = mode.modeletMap[ RouterBmpStationModelet ]
   stationModelet.noBmpReceivedRoutes()

def defaultHandlerExportPolicyReceivedRoutesCmd( mode, args ):
   stationModelet = mode.modeletMap[ RouterBmpStationModelet ]
   stationModelet.defaultBmpReceivedRoutes()

def handlerExportPolicyAdditionalPathsCmd( mode, args ):
   stationModelet = mode.modeletMap[ RouterBmpStationModelet ]
   stationModelet.setBmpAdditionalPaths()

def noOrDefaultHandlerExportPolicyAdditionalPathsCmd( mode, args ):
   stationModelet = mode.modeletMap[ RouterBmpStationModelet ]
   stationModelet.noBmpAdditionalPaths()

def handlerExportPolicyAdvertisedRoutesCmd( mode, args ):
   if getEffectiveProtocolModel( mode ) != ProtocolAgentModelType.multiAgent:
      mode.addWarning( "BGP advertised routes export is only supported in "
                       "multi-agent mode" )
   stationModelet = mode.modeletMap[ RouterBmpStationModelet ]
   stationModelet.setBmpAdvertisedRoutes( args )

def ExportPolicyAdvertisedRoutesCmd_noHandler( mode, args ):
   stationModelet = mode.modeletMap[ RouterBmpStationModelet ]
   stationModelet.noBmpAdvertisedRoutes()

def ExportPolicyAdvertisedRoutesCmd_defaultHandler( mode, args ):
   stationModelet = mode.modeletMap[ RouterBmpStationModelet ]
   stationModelet.defaultBmpAdvertisedRoutes()

def handleNormalExportPolicyBribBestPathsCmd( mode, args ):
   if getEffectiveProtocolModel( mode ) != ProtocolAgentModelType.multiAgent:
      mode.addWarning( "BGP advertised routes export is only supported in "
                       "multi-agent mode" )
   stationModelet = mode.modeletMap[ RouterBmpStationModelet ]
   stationModelet.enableLocRibExport()

def handleNoOrDefaultExportPolicyBribBestPathsCmd( mode, args, noOrDefault ):
   stationModelet = mode.modeletMap[ RouterBmpStationModelet ]
   if noOrDefault == NoOrDefault.DEFAULT:
      stationModelet.defaultLocRibExport()
   else: # disable
      stationModelet.noLocRibExport()

def handlerExportPolicyBribBestPathsCmd( mode, args ):
   BgpCmdBaseClass.callHandler(
      handleNormalExportPolicyBribBestPathsCmd,
      handleNoOrDefaultExportPolicyBribBestPathsCmd,
      mode,
      args )

def noOrDefaultHandlerExportPolicyBribBestPathsCmd( mode, args ):
   BgpCmdBaseClass.callNoOrDefaultHandler(
      handleNoOrDefaultExportPolicyBribBestPathsCmd,
      mode,
      args )

def handlerShutdownCmd( mode, args ):
   stationModelet = mode.modeletMap[ RouterBmpStationModelet ]
   stationModelet.setShutdown( args.get( 'MESSAGE' ) )

def noOrDefaultHandlerShutdownCmd( mode, args ):
   stationModelet = mode.modeletMap[ RouterBmpStationModelet ]
   stationModelet.noShutdown()

def handlerStatisticsEnableCmd( mode, args ):
   stationModelet = mode.modeletMap[ RouterBmpStationModelet ]
   stationModelet.setStatistics( True )

def noOrDefaultHandlerStatisticsEnableCmd( mode, args ):
   stationModelet = mode.modeletMap[ RouterBmpStationModelet ]
   stationModelet.noStatistics()

def handlerUpdateSourceCmd( mode, args ):
   stationModelet = mode.modeletMap[ RouterBmpStationModelet ]
   stationModelet.sourceIntf( args[ 'INTF' ] )

def noOrDefaultHandlerUpdateSourceCmd( mode, args ):
   stationModelet = mode.modeletMap[ RouterBmpStationModelet ]
   stationModelet.noSourceIntf()
