# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliDynamicSymbol import CliDynamicPlugin
from CliPlugin import CpuComplexCli

CpuComplexCliModel = CliDynamicPlugin( "CpuComplexCliModel" )

#------------------------------------------------------------------------------------
# show system memory errors
#------------------------------------------------------------------------------------
def showSystemMemoryErrorsHandler( mode, args ):
   showSystemMemoryErrors = CpuComplexCliModel.ShowSystemMemoryErrorsModel()
   memStatus = CpuComplexCli.gv.memStatus

   for mcName, mc in memStatus.memoryController.items():
      memoryControllerErrors = CpuComplexCliModel.MemoryControllerErrorsModel()
      for dimmName, dimm in mc.dimm.items():
         dimmErrors = CpuComplexCliModel.DimmErrorsModel()
         dimmErrors.correctableErrorCount = dimm.correctableErrorCount
         dimmErrors.uncorrectableErrorCount = dimm.uncorrectableErrorCount
         memoryControllerErrors.dimms[ dimmName ] = dimmErrors
      showSystemMemoryErrors.memoryControllers[ mcName ] = memoryControllerErrors

   return showSystemMemoryErrors
