# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import CliCommand
import LazyMount
import ConfigMount

# Globals written by the Plugin function at the end of this file
dhcpSnoopingConfig = None
dhcpSnoopingCounterConfig = None
dhcpSnoopingStatus = None
dhcpSnoopingHwStatusDir = None
dhcp6SnoopingConfig = None
dhcp6SnoopingHwStatusDir = None
dhcp6SnoopingCounterConfig = None
platformHardwareSliceDir = None
bridgingConfig = None

#-------------------------------------------------------------------------------
# "[no|default] ip dhcp snooping interface information option circuit-id
# type <circuit-id type> value <circuit-id value>" interface command.
#-------------------------------------------------------------------------------
def setInfoCircuitIdIntf( mode, args ):
   circuitIdType = args.get( 'ID', 'none' )
   newId = args[ 'NEWID' ]
   # circuitIdVal is unique across interface
   for intfName in dhcpSnoopingConfig.userDefinedCircuitId:
      if dhcpSnoopingConfig.userDefinedCircuitId[ intfName ].circuitIdVal == newId \
         and intfName != mode.intf.name:
         mode.addError( "Circuit ID %s is already set on another interface: %s" %
               ( newId, intfName ) )
         return

   intfName = mode.intf.name
   if intfName not in dhcpSnoopingConfig.userDefinedCircuitId:
      dhcpSnoopingConfig.userDefinedCircuitId.newMember( intfName )
   if circuitIdType == 'none':
      dhcpSnoopingConfig.userDefinedCircuitId[ intfName ].circuitIdTypeValid = False
   else:
      dhcpSnoopingConfig.userDefinedCircuitId[ intfName ].circuitIdTypeValid = True
      dhcpSnoopingConfig.userDefinedCircuitId[ intfName ].circuitIdType = \
                                                               int( circuitIdType )
   dhcpSnoopingConfig.userDefinedCircuitId[ intfName ].circuitIdVal = newId

def resetInfoCircuitIdIntf( mode, args ):
   intfName = mode.intf.name
   if intfName in dhcpSnoopingConfig.userDefinedCircuitId:
      del dhcpSnoopingConfig.userDefinedCircuitId[ intfName ]

#--------------------------------------------------------------------------------
# clear ip dhcp snooping counters
#--------------------------------------------------------------------------------
def clearDhcpSnoopingCounters( mode, args ):
   dhcpSnoopingCounterConfig.resetCountersTrigger = \
      ( dhcpSnoopingCounterConfig.resetCountersTrigger + 1 ) % 256

#--------------------------------------------------------------------------------
# clear ip dhcp snooping counters debug
#--------------------------------------------------------------------------------
def clearDhcpSnoopingDebugCounters( mode, args ):
   dhcpSnoopingCounterConfig.resetDebugCountersTrigger = \
      ( dhcpSnoopingCounterConfig.resetDebugCountersTrigger + 1 ) % 256

#--------------------------------------------------------------------------------
# [ no | default ] ip dhcp snooping [ bridging ]
#--------------------------------------------------------------------------------
def noDhcpSnooping( mode, args ):
   dhcpSnoopingConfig.enabled = False
   dhcpSnoopingConfig.bridging = False

def setDhcpSnooping( mode, args ):
   dhcpSnoopingConfig.enabled = True
   dhcpSnoopingConfig.bridging = 'bridging' in args
   
#--------------------------------------------------------------------------------
# ip dhcp snooping information option circuit-id type ( none | NONE ) 
#         format ( %h:%p | %p:%v )
#--------------------------------------------------------------------------------
def setInfoCircuitId( mode, args ):
   circuitIdType = args.get( 'TYPE' )
   formatString = args.get( '%h:%p' ) 
   if formatString is None:
      formatString = args[ '%p:%v' ]
   if circuitIdType is None:
      dhcpSnoopingConfig.circuitIdTypeValid = False
   else:
      dhcpSnoopingConfig.circuitIdTypeValid = True
      dhcpSnoopingConfig.circuitIdType = int( circuitIdType )

   dhcpSnoopingConfig.circuitIdFormatString = formatString

def resetInfoCircuitId( mode, args ):
   dhcpSnoopingConfig.circuitIdType = dhcpSnoopingConfig.circuitIdTypeDefault
   dhcpSnoopingConfig.circuitIdFormatString = \
      dhcpSnoopingConfig.circuitIdFormatStringDefault
   dhcpSnoopingConfig.circuitIdTypeValid = \
      dhcpSnoopingConfig.circuitIdTypeValidDefault

#--------------------------------------------------------------------------------
# [ no | default ] ip dhcp snooping information option
#--------------------------------------------------------------------------------
def setInfoOption( mode, args ):
   no = CliCommand.isNoOrDefaultCmd( args )
   dhcpSnoopingConfig.informationOption = not no
   
#--------------------------------------------------------------------------------
# [ no | default ] ip dhcp snooping vlan VLANSET
#--------------------------------------------------------------------------------
def setDhcpSnoopingVlan( mode, args ):
   for vlan in args[ 'VLANSET' ]:
      dhcpSnoopingConfig.vlan[ vlan ] = True
   
def resetDhcpSnoopingVlan( mode, args ):
   vlans = args.get( 'VLANSET' )
   if vlans:
      for vlan in vlans:
         del dhcpSnoopingConfig.vlan[ vlan ]
   else:
      dhcpSnoopingConfig.vlan.clear()

#--------------------------------------------------------------------------------
# clear ipv6 dhcp snooping counters
#--------------------------------------------------------------------------------
def clearDhcp6SnoopingCounters( mode, args ):
   dhcp6SnoopingCounterConfig.resetCountersTrigger = \
      ( dhcp6SnoopingCounterConfig.resetCountersTrigger + 1 ) % 256

#--------------------------------------------------------------------------------
# clear ipv6 dhcp snooping counters debug
#--------------------------------------------------------------------------------
def clearDhcp6SnoopingDebugCounters( mode, args ):
   dhcp6SnoopingCounterConfig.resetDebugCountersTrigger = \
      ( dhcp6SnoopingCounterConfig.resetDebugCountersTrigger + 1 ) % 256

#--------------------------------------------------------------------------------
# [ no | default ] ipv6 dhcp snooping
#--------------------------------------------------------------------------------
def setDhcp6Snooping( mode, args ):
   no = CliCommand.isNoOrDefaultCmd( args )
   dhcp6SnoopingConfig.enabled = not no

#--------------------------------------------------------------------------------
# [ no | default ] ipv6 dhcp snooping remote-id option
#--------------------------------------------------------------------------------
def setInfoOptionV6( mode, args ):
   no = CliCommand.isNoOrDefaultCmd( args )
   dhcp6SnoopingConfig.remoteIdOption = not no
   
#--------------------------------------------------------------------------------
# [ no | default ] ipv6 dhcp snooping vlan VLANSET
#--------------------------------------------------------------------------------
def setDhcp6SnoopingVlan( mode, args ):
   for vlan in args[ 'VLANSET' ]:
      dhcp6SnoopingConfig.vlan[ vlan ] = True

def resetDhcp6SnoopingVlan( mode, args ):
   vlans = args.get( 'VLANSET' )
   if vlans:
      for vlan in vlans:
         del dhcp6SnoopingConfig.vlan[ vlan ]
   else:
      dhcp6SnoopingConfig.vlan.clear()

#-------------------------------------------------------------------------------
# Have the Cli Agent mount all needed state from sysdb
#-------------------------------------------------------------------------------
def Plugin( entityManager ):
   global dhcpSnoopingConfig, dhcpSnoopingStatus,  dhcpSnoopingHwStatusDir
   global bridgingConfig, dhcpSnoopingCounterConfig, platformHardwareSliceDir
   global dhcp6SnoopingConfig, dhcp6SnoopingHwStatusDir, dhcp6SnoopingCounterConfig

   dhcpSnoopingConfig = ConfigMount.mount( entityManager,
                                           "bridging/dhcpsnooping/config",
                                           "Bridging::DhcpSnooping::Config", "w" )
   dhcpSnoopingCounterConfig = LazyMount.mount(
         entityManager, "bridging/dhcpsnooping/counterConfig",
         "Bridging::DhcpSnooping::CounterConfig", "w" )
   dhcpSnoopingStatus = LazyMount.mount( entityManager,
                                         "bridging/dhcpsnooping/status",
                                         "Bridging::DhcpSnooping::Status", "r" )
   dhcpSnoopingHwStatusDir = LazyMount.mount( entityManager,
                                             "bridging/dhcpsnooping/hardware/status",
                                             "Tac::Dir", "ri" )
   bridgingConfig = LazyMount.mount( entityManager, "bridging/config",
                                     "Bridging::Config", "r" )
   platformHardwareSliceDir = LazyMount.mount( entityManager,
                                               "platform/hardware/slice",
                                               "Hardware::PlatformSliceDir", "r" )
   dhcp6SnoopingConfig = ConfigMount.mount(
         entityManager, "bridging/dhcpsnooping/dhcp6Config",
         "Bridging::DhcpSnooping::Dhcp6Config", "w" )
   dhcp6SnoopingHwStatusDir = LazyMount.mount( entityManager,
                                        "bridging/dhcpsnooping/hardware/dhcp6Status",
                                         "Tac::Dir", "ri" )
   dhcp6SnoopingCounterConfig = LazyMount.mount(
         entityManager, "bridging/dhcpsnooping/dhcp6CounterConfig",
         "Bridging::DhcpSnooping::CounterConfig", "w" )
