# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import TableOutput
from CliModel import (
   Int,
   List,
   Model,
   Str,
)

class CpuQueueCountersModel( Model ):
   cpuQueueId = Int( help="Identifier of the the CPU queue" )
   cpuQueueName = Str( help="Possibly truncated CPU queue name, empty if not known" )
   sampledPackets = Int( help="Number of sampled packets for the CPU queue" )
   congestionEvents = Int( help="Number of congestion events for the cpu-queue" )

class CountersModel( Model ):
   cpuQueueCounters = List(
      help="Counters for each CPU queue",
      valueType=CpuQueueCountersModel )

   def render( self ):
      if self.cpuQueueCounters is not None:
         headers = (
               'ID',
               'CPU Queue Name',
               'Sampled\nPackets',
               'Congestion\nEvents' )
         table = TableOutput.createTable( headers )
         numericFormat = TableOutput.Format( justify='right' )
         numericFormat.noPadLeftIs( True )
         numericFormat.padLimitIs( True )
         stdFormat = TableOutput.Format( justify='left' )
         stdFormat.noPadLeftIs( True )
         stdFormat.padLimitIs( True )
         table.formatColumns(
               numericFormat,
               stdFormat,
               numericFormat,
               numericFormat )
         for counter in self.cpuQueueCounters:
            table.newRow(
               counter.cpuQueueId,
               counter.cpuQueueName,
               counter.sampledPackets,
               counter.congestionEvents )
         print( table.output() )
