# Copyright (c) 2009, 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMatcher
import ConfigMount
import DesCrypt
from CliPlugin.VrfCli import DEFAULT_VRF
from CliDynamicSymbol import CliDynamicPlugin

emailDynamicSubmodes = CliDynamicPlugin( "EmailCli" )

emailConfig = None

matcherAuth = CliMatcher.KeywordMatcher( 'auth',
      helpdesc='Email account authentication' )

# --------------------------------------------------------------------------
# The email mode
# --------------------------------------------------------------------------
def gotoEmailMode( mode, args ):
   childMode = mode.childMode( emailDynamicSubmodes.EmailConfigMode )
   mode.session_.gotoChildMode( childMode )

def removeEmailMode( mode, args ):
   noServer( mode, args )
   noFromUser( mode, args )
   noUser( mode, args )
   noPassword( mode, args )
   noTls( mode, args )

# --------------------------------------------------------------------------
# The "[no|default] server [ vrf VRF ] SERVER" command, in email mode.
# --------------------------------------------------------------------------
def setServer( mode, args ):
   server = args[ 'SERVER' ]
   hostAndPort = server.split( ':', 1 )
   try:
      port = int( hostAndPort[ 1 ] )
      if not 0 < port < 65536:
         raise ValueError # Go to the error-and-stop.
   except ValueError:
      mode.addErrorAndStop( "Invalid port number" )
   except IndexError: # Wasn't specified; default to 25.
      port = 25

   emailConfig.host = hostAndPort[ 0 ]
   emailConfig.port = port
   emailConfig.vrfName = args.get( 'VRF', DEFAULT_VRF )

def noServer( mode, args ):
   emailConfig.host = ''
   emailConfig.port = 25
   emailConfig.vrfName = DEFAULT_VRF

# --------------------------------------------------------------------------
# The "[no|default] from-user EMAIL_ADDRESS" command, in email mode.
# --------------------------------------------------------------------------
def setFromUser( mode, args ):
   fromUser = args[ 'EMAIL_ADDRESS' ]
   if '@' not in fromUser:
      mode.addError( 'Email address must be fully qualified including @domain' )
      return
   emailConfig.fromUser = fromUser

def noFromUser( mode, args ):
   emailConfig.fromUser = ''

# --------------------------------------------------------------------------
# The "[no|default] auth username USERNAME" command, in email mode.
# --------------------------------------------------------------------------
def setUser( mode, args ):
   user = args[ 'USERNAME' ]
   emailConfig.user = user

def noUser( mode, args ):
   emailConfig.user = ''

# --------------------------------------------------------------------------
# The "[no] auth password [0 | 7] PASSWORD" command, in email mode.
# --------------------------------------------------------------------------
def setPassword( mode, args ):
   password = args[ 'PASSWORD' ]
   if '7' in args:
      try:
         password = DesCrypt.decrypt(
               emailConfig.name.encode() + b'_cryptkey_email',
               password.encode() ).decode()
      except: # pylint: disable-msg=bare-except
         mode.addError( "Invalid encrypted keystring" )
         return

   emailConfig.password = password

def noPassword( mode, args ):
   emailConfig.password = ''

# --------------------------------------------------------------------------
# The "[no|default] tls" command, in email mode.
# --------------------------------------------------------------------------
def setTls( mode, args ):
   emailConfig.useTls = True

def noTls( mode, args ):
   emailConfig.useTls = False

# --------------------------------------------------------------------------
def Plugin( entityManager ):
   global emailConfig
   emailConfig = ConfigMount.mount( entityManager, "sys/email/config",
                                    "System::EmailConfig", "w" )
