# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliModel import Dict, Int, Model, Str
from TableOutput import createTable, Format

class EosLabKernelInterfaceSortingInfo( Model ):
   path = Str( help="kernel device path" )
   acpiIndex = Int( help="ACPI index, if present", optional=True )

class EosLabKernelInterfacePath( Model ):
   '''Kernel devices and device path names'''
   devices = Dict( keyType=str, valueType=EosLabKernelInterfaceSortingInfo,
                   help="Maps kernel device name to interface sorting information" )

   def render( self ):
      header = ( 'Device name', 'Path', 'ACPI Index' )
      table = createTable( header )
      left = Format( justify='left' )
      table.formatColumns( *( left for _ in header ) )
      for device, info in sorted( self.devices.items() ):
         table.newRow( device, info.path, info.acpiIndex )
      print( table.output() )

class EosLabKernelInterfaceOffload( Model ):
   '''Kernel devices and offload information - note that this is just returns the
   text output of the ethtool command; we do not try to parse it and create a
   sensible model, because we want to be resilient to ethtool output changes'''
   devices = Dict( keyType=str, valueType=str,
                   help="Maps kernel device name to its offload information" )
   # This model is ugly, but it's needed only rarely for deep debugging.
   # We make it non-public to hide our shame.
   __public__ = False

   def render( self ):
      for device, offload in sorted( self.devices.items() ):
         print( f'{device}:' )
         print( offload )
